package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterServiceClassFluentImpl<A extends ClusterServiceClassFluent<A>> extends BaseFluent<A> implements ClusterServiceClassFluent<A>{
  public ClusterServiceClassFluentImpl() {
  }
  public ClusterServiceClassFluentImpl(ClusterServiceClass instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ClusterServiceClassSpecBuilder spec;
  private ClusterServiceClassStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ClusterServiceClassFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ClusterServiceClassFluentImpl.MetadataNestedImpl();
  }
  public ClusterServiceClassFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ClusterServiceClassFluentImpl.MetadataNestedImpl(item);
  }
  public ClusterServiceClassFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ClusterServiceClassFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ClusterServiceClassFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterServiceClassSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ClusterServiceClassSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ClusterServiceClassSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ClusterServiceClassSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ClusterServiceClassFluentImpl.SpecNested<A> withNewSpec() {
    return new ClusterServiceClassFluentImpl.SpecNestedImpl();
  }
  public ClusterServiceClassFluentImpl.SpecNested<A> withNewSpecLike(ClusterServiceClassSpec item) {
    return new ClusterServiceClassFluentImpl.SpecNestedImpl(item);
  }
  public ClusterServiceClassFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ClusterServiceClassFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ClusterServiceClassSpecBuilder().build());
  }
  public ClusterServiceClassFluentImpl.SpecNested<A> editOrNewSpecLike(ClusterServiceClassSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterServiceClassStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ClusterServiceClassStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ClusterServiceClassStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ClusterServiceClassStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public A withNewStatus(Boolean removedFromBrokerCatalog) {
    return (A)withStatus(new ClusterServiceClassStatus(removedFromBrokerCatalog));
  }
  public ClusterServiceClassFluentImpl.StatusNested<A> withNewStatus() {
    return new ClusterServiceClassFluentImpl.StatusNestedImpl();
  }
  public ClusterServiceClassFluentImpl.StatusNested<A> withNewStatusLike(ClusterServiceClassStatus item) {
    return new ClusterServiceClassFluentImpl.StatusNestedImpl(item);
  }
  public ClusterServiceClassFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ClusterServiceClassFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ClusterServiceClassStatusBuilder().build());
  }
  public ClusterServiceClassFluentImpl.StatusNested<A> editOrNewStatusLike(ClusterServiceClassStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterServiceClassFluentImpl that = (ClusterServiceClassFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterServiceClassFluentImpl.MetadataNested<N>> implements ClusterServiceClassFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterServiceClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ClusterServiceClassSpecFluentImpl<ClusterServiceClassFluentImpl.SpecNested<N>> implements ClusterServiceClassFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ClusterServiceClassSpec item) {
      this.builder = new ClusterServiceClassSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ClusterServiceClassSpecBuilder(this);
    }
    ClusterServiceClassSpecBuilder builder;
    public N and() {
      return (N) ClusterServiceClassFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ClusterServiceClassStatusFluentImpl<ClusterServiceClassFluentImpl.StatusNested<N>> implements ClusterServiceClassFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ClusterServiceClassStatus item) {
      this.builder = new ClusterServiceClassStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ClusterServiceClassStatusBuilder(this);
    }
    ClusterServiceClassStatusBuilder builder;
    public N and() {
      return (N) ClusterServiceClassFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}