package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerListBuilder extends ClusterServiceBrokerListFluentImpl<ClusterServiceBrokerListBuilder> implements VisitableBuilder<ClusterServiceBrokerList,ClusterServiceBrokerListBuilder>{
  public ClusterServiceBrokerListBuilder() {
    this(false);
  }
  public ClusterServiceBrokerListBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBrokerList(), validationEnabled);
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBrokerList(), validationEnabled);
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerListFluent<?> fluent,ClusterServiceBrokerList instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerListFluent<?> fluent,ClusterServiceBrokerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerList instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerListBuilder(ClusterServiceBrokerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBrokerList build() {
    ClusterServiceBrokerList buildable = new ClusterServiceBrokerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}