
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "grouprestriction",
    "serviceaccountrestriction",
    "userrestriction"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class RoleBindingRestrictionSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("grouprestriction")
    private GroupRestriction grouprestriction;
    /**
     * 
     * 
     */
    @JsonProperty("serviceaccountrestriction")
    private ServiceAccountRestriction serviceaccountrestriction;
    /**
     * 
     * 
     */
    @JsonProperty("userrestriction")
    private UserRestriction userrestriction;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public RoleBindingRestrictionSpec() {
    }

    /**
     * 
     * @param serviceaccountrestriction
     * @param grouprestriction
     * @param userrestriction
     */
    public RoleBindingRestrictionSpec(GroupRestriction grouprestriction, ServiceAccountRestriction serviceaccountrestriction, UserRestriction userrestriction) {
        this.grouprestriction = grouprestriction;
        this.serviceaccountrestriction = serviceaccountrestriction;
        this.userrestriction = userrestriction;
    }

    /**
     * 
     * 
     * @return
     *     The grouprestriction
     */
    @JsonProperty("grouprestriction")
    public GroupRestriction getGrouprestriction() {
        return grouprestriction;
    }

    /**
     * 
     * 
     * @param grouprestriction
     *     The grouprestriction
     */
    @JsonProperty("grouprestriction")
    public void setGrouprestriction(GroupRestriction grouprestriction) {
        this.grouprestriction = grouprestriction;
    }

    /**
     * 
     * 
     * @return
     *     The serviceaccountrestriction
     */
    @JsonProperty("serviceaccountrestriction")
    public ServiceAccountRestriction getServiceaccountrestriction() {
        return serviceaccountrestriction;
    }

    /**
     * 
     * 
     * @param serviceaccountrestriction
     *     The serviceaccountrestriction
     */
    @JsonProperty("serviceaccountrestriction")
    public void setServiceaccountrestriction(ServiceAccountRestriction serviceaccountrestriction) {
        this.serviceaccountrestriction = serviceaccountrestriction;
    }

    /**
     * 
     * 
     * @return
     *     The userrestriction
     */
    @JsonProperty("userrestriction")
    public UserRestriction getUserrestriction() {
        return userrestriction;
    }

    /**
     * 
     * 
     * @param userrestriction
     *     The userrestriction
     */
    @JsonProperty("userrestriction")
    public void setUserrestriction(UserRestriction userrestriction) {
        this.userrestriction = userrestriction;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
