package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DockerStrategyOptionsFluent<A extends DockerStrategyOptionsFluent<A>> extends Fluent<A>{


    public A addToBuildArgs(int index,EnvVar item);
    public A setToBuildArgs(int index,EnvVar item);
    public A addToBuildArgs(EnvVar... items);
    public A addAllToBuildArgs(Collection<EnvVar> items);
    public A removeFromBuildArgs(EnvVar... items);
    public A removeAllFromBuildArgs(Collection<EnvVar> items);
    public List<EnvVar> getBuildArgs();
    public EnvVar getBuildArg(int index);
    public EnvVar getFirstBuildArg();
    public EnvVar getLastBuildArg();
    public EnvVar getMatchingBuildArg(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate);
    public Boolean hasMatchingBuildArg(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate);
    public A withBuildArgs(List<EnvVar> buildArgs);
    public A withBuildArgs(EnvVar... buildArgs);
    public Boolean hasBuildArgs();
    public Boolean isNoCache();
    public A withNoCache(Boolean noCache);
    public Boolean hasNoCache();
    public A withNewNoCache(String arg1);
    public A withNewNoCache(boolean arg1);



}
