package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProfileSpecBuilder extends ProfileSpecFluentImpl<ProfileSpecBuilder> implements VisitableBuilder<ProfileSpec,ProfileSpecBuilder>{
  public ProfileSpecBuilder() {
    this(false);
  }
  public ProfileSpecBuilder(Boolean validationEnabled) {
    this(new ProfileSpec(), validationEnabled);
  }
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProfileSpec(), validationEnabled);
  }
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent,ProfileSpec instance) {
    this(fluent, instance, false);
  }
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent,ProfileSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfig(instance.getConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProfileSpecBuilder(ProfileSpec instance) {
    this(instance,false);
  }
  public ProfileSpecBuilder(ProfileSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProfileSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProfileSpec build() {
    ProfileSpec buildable = new ProfileSpec(fluent.getConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}