package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProfileConfigBuilder extends ProfileConfigFluentImpl<ProfileConfigBuilder> implements VisitableBuilder<ProfileConfig,ProfileConfigBuilder>{
  public ProfileConfigBuilder() {
    this(false);
  }
  public ProfileConfigBuilder(Boolean validationEnabled) {
    this(new ProfileConfig(), validationEnabled);
  }
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProfileConfig(), validationEnabled);
  }
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent,ProfileConfig instance) {
    this(fluent, instance, false);
  }
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent,ProfileConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDebug(instance.getDebug());
      fluent.withTunedProfile(instance.getTunedProfile());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProfileConfigBuilder(ProfileConfig instance) {
    this(instance,false);
  }
  public ProfileConfigBuilder(ProfileConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDebug(instance.getDebug());
      this.withTunedProfile(instance.getTunedProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProfileConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ProfileConfig build() {
    ProfileConfig buildable = new ProfileConfig(fluent.getDebug(),fluent.getTunedProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}