package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionListBuilder extends SubscriptionListFluent<SubscriptionListBuilder> implements VisitableBuilder<SubscriptionList,SubscriptionListBuilder>{
  public SubscriptionListBuilder() {
    this(false);
  }
  public SubscriptionListBuilder(Boolean validationEnabled) {
    this(new SubscriptionList(), validationEnabled);
  }
  public SubscriptionListBuilder(SubscriptionListFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionList(), validationEnabled);
  }
  public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance) {
    this(fluent, instance, false);
  }
  public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubscriptionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionListBuilder(SubscriptionList instance) {
    this(instance,false);
  }
  public SubscriptionListBuilder(SubscriptionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubscriptionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionListFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionList build() {
    SubscriptionList buildable = new SubscriptionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}