package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CatalogSourceSpecBuilder extends CatalogSourceSpecFluent<CatalogSourceSpecBuilder> implements VisitableBuilder<CatalogSourceSpec,CatalogSourceSpecBuilder>{
  public CatalogSourceSpecBuilder() {
    this(false);
  }
  public CatalogSourceSpecBuilder(Boolean validationEnabled) {
    this(new CatalogSourceSpec(), validationEnabled);
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CatalogSourceSpec(), validationEnabled);
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpecFluent<?> fluent,CatalogSourceSpec instance) {
    this(fluent, instance, false);
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpecFluent<?> fluent,CatalogSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CatalogSourceSpec());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withIcon(instance.getIcon());
      fluent.withImage(instance.getImage());
      fluent.withPriority(instance.getPriority());
      fluent.withPublisher(instance.getPublisher());
      fluent.withSecrets(instance.getSecrets());
      fluent.withSourceType(instance.getSourceType());
      fluent.withUpdateStrategy(instance.getUpdateStrategy());
      fluent.withAddress(instance.getAddress());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withIcon(instance.getIcon());
      fluent.withImage(instance.getImage());
      fluent.withPriority(instance.getPriority());
      fluent.withPublisher(instance.getPublisher());
      fluent.withSecrets(instance.getSecrets());
      fluent.withSourceType(instance.getSourceType());
      fluent.withUpdateStrategy(instance.getUpdateStrategy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpec instance) {
    this(instance,false);
  }
  public CatalogSourceSpecBuilder(CatalogSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CatalogSourceSpec());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withConfigMap(instance.getConfigMap());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withImage(instance.getImage());
      this.withPriority(instance.getPriority());
      this.withPublisher(instance.getPublisher());
      this.withSecrets(instance.getSecrets());
      this.withSourceType(instance.getSourceType());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withAddress(instance.getAddress());
      this.withConfigMap(instance.getConfigMap());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withImage(instance.getImage());
      this.withPriority(instance.getPriority());
      this.withPublisher(instance.getPublisher());
      this.withSecrets(instance.getSecrets());
      this.withSourceType(instance.getSourceType());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CatalogSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CatalogSourceSpec build() {
    CatalogSourceSpec buildable = new CatalogSourceSpec(fluent.getAddress(),fluent.getConfigMap(),fluent.getDescription(),fluent.getDisplayName(),fluent.buildIcon(),fluent.getImage(),fluent.getPriority(),fluent.getPublisher(),fluent.getSecrets(),fluent.getSourceType(),fluent.buildUpdateStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}