package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CatalogSourceListBuilder extends CatalogSourceListFluent<CatalogSourceListBuilder> implements VisitableBuilder<CatalogSourceList,CatalogSourceListBuilder>{
  public CatalogSourceListBuilder() {
    this(false);
  }
  public CatalogSourceListBuilder(Boolean validationEnabled) {
    this(new CatalogSourceList(), validationEnabled);
  }
  public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CatalogSourceList(), validationEnabled);
  }
  public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,CatalogSourceList instance) {
    this(fluent, instance, false);
  }
  public CatalogSourceListBuilder(CatalogSourceListFluent<?> fluent,CatalogSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CatalogSourceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CatalogSourceListBuilder(CatalogSourceList instance) {
    this(instance,false);
  }
  public CatalogSourceListBuilder(CatalogSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CatalogSourceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CatalogSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public CatalogSourceList build() {
    CatalogSourceList buildable = new CatalogSourceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}