package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorGroupListBuilder extends OperatorGroupListFluent<OperatorGroupListBuilder> implements VisitableBuilder<OperatorGroupList,OperatorGroupListBuilder>{
  public OperatorGroupListBuilder() {
    this(false);
  }
  public OperatorGroupListBuilder(Boolean validationEnabled) {
    this(new OperatorGroupList(), validationEnabled);
  }
  public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorGroupList(), validationEnabled);
  }
  public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,OperatorGroupList instance) {
    this(fluent, instance, false);
  }
  public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,OperatorGroupList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorGroupList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorGroupListBuilder(OperatorGroupList instance) {
    this(instance,false);
  }
  public OperatorGroupListBuilder(OperatorGroupList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorGroupList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorGroupListFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorGroupList build() {
    OperatorGroupList buildable = new OperatorGroupList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}