package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorConditionStatusBuilder extends OperatorConditionStatusFluent<OperatorConditionStatusBuilder> implements VisitableBuilder<OperatorConditionStatus,OperatorConditionStatusBuilder>{
  public OperatorConditionStatusBuilder() {
    this(false);
  }
  public OperatorConditionStatusBuilder(Boolean validationEnabled) {
    this(new OperatorConditionStatus(), validationEnabled);
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorConditionStatus(), validationEnabled);
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatusFluent<?> fluent,OperatorConditionStatus instance) {
    this(fluent, instance, false);
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatusFluent<?> fluent,OperatorConditionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorConditionStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatus instance) {
    this(instance,false);
  }
  public OperatorConditionStatusBuilder(OperatorConditionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorConditionStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorConditionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorConditionStatus build() {
    OperatorConditionStatus buildable = new OperatorConditionStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}