package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorConditionListBuilder extends OperatorConditionListFluent<OperatorConditionListBuilder> implements VisitableBuilder<OperatorConditionList,OperatorConditionListBuilder>{
  public OperatorConditionListBuilder() {
    this(false);
  }
  public OperatorConditionListBuilder(Boolean validationEnabled) {
    this(new OperatorConditionList(), validationEnabled);
  }
  public OperatorConditionListBuilder(OperatorConditionListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorConditionListBuilder(OperatorConditionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorConditionList(), validationEnabled);
  }
  public OperatorConditionListBuilder(OperatorConditionListFluent<?> fluent,OperatorConditionList instance) {
    this(fluent, instance, false);
  }
  public OperatorConditionListBuilder(OperatorConditionListFluent<?> fluent,OperatorConditionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorConditionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorConditionListBuilder(OperatorConditionList instance) {
    this(instance,false);
  }
  public OperatorConditionListBuilder(OperatorConditionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorConditionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorConditionListFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorConditionList build() {
    OperatorConditionList buildable = new OperatorConditionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}