package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PackageManifestStatusFluent<A extends PackageManifestStatusFluent<A>> extends BaseFluent<A>{
  public PackageManifestStatusFluent() {
  }
  public PackageManifestStatusFluent(PackageManifestStatus instance) {
    instance = (instance != null ? instance : new PackageManifestStatus());

    if (instance != null) {
      this.withCatalogSource(instance.getCatalogSource());
      this.withCatalogSourceDisplayName(instance.getCatalogSourceDisplayName());
      this.withCatalogSourceNamespace(instance.getCatalogSourceNamespace());
      this.withCatalogSourcePublisher(instance.getCatalogSourcePublisher());
      this.withChannels(instance.getChannels());
      this.withDefaultChannel(instance.getDefaultChannel());
      this.withPackageName(instance.getPackageName());
      this.withProvider(instance.getProvider());
      this.withCatalogSource(instance.getCatalogSource());
      this.withCatalogSourceDisplayName(instance.getCatalogSourceDisplayName());
      this.withCatalogSourceNamespace(instance.getCatalogSourceNamespace());
      this.withCatalogSourcePublisher(instance.getCatalogSourcePublisher());
      this.withChannels(instance.getChannels());
      this.withDefaultChannel(instance.getDefaultChannel());
      this.withPackageName(instance.getPackageName());
      this.withProvider(instance.getProvider());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String catalogSource;
  private String catalogSourceDisplayName;
  private String catalogSourceNamespace;
  private String catalogSourcePublisher;
  private ArrayList<PackageChannelBuilder> channels = new ArrayList<PackageChannelBuilder>();
  private String defaultChannel;
  private String packageName;
  private AppLinkBuilder provider;
  private Map<String,Object> additionalProperties;
  public String getCatalogSource() {
    return this.catalogSource;
  }
  public A withCatalogSource(String catalogSource) {
    this.catalogSource=catalogSource; return (A) this;
  }
  public boolean hasCatalogSource() {
    return this.catalogSource != null;
  }
  public String getCatalogSourceDisplayName() {
    return this.catalogSourceDisplayName;
  }
  public A withCatalogSourceDisplayName(String catalogSourceDisplayName) {
    this.catalogSourceDisplayName=catalogSourceDisplayName; return (A) this;
  }
  public boolean hasCatalogSourceDisplayName() {
    return this.catalogSourceDisplayName != null;
  }
  public String getCatalogSourceNamespace() {
    return this.catalogSourceNamespace;
  }
  public A withCatalogSourceNamespace(String catalogSourceNamespace) {
    this.catalogSourceNamespace=catalogSourceNamespace; return (A) this;
  }
  public boolean hasCatalogSourceNamespace() {
    return this.catalogSourceNamespace != null;
  }
  public String getCatalogSourcePublisher() {
    return this.catalogSourcePublisher;
  }
  public A withCatalogSourcePublisher(String catalogSourcePublisher) {
    this.catalogSourcePublisher=catalogSourcePublisher; return (A) this;
  }
  public boolean hasCatalogSourcePublisher() {
    return this.catalogSourcePublisher != null;
  }
  public A addToChannels(int index,PackageChannel item) {
    if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
    PackageChannelBuilder builder = new PackageChannelBuilder(item);
    if (index < 0 || index >= channels.size()) { _visitables.get("channels").add(builder); channels.add(builder); } else { _visitables.get("channels").add(index, builder); channels.add(index, builder);}
    return (A)this;
  }
  public A setToChannels(int index,PackageChannel item) {
    if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
    PackageChannelBuilder builder = new PackageChannelBuilder(item);
    if (index < 0 || index >= channels.size()) { _visitables.get("channels").add(builder); channels.add(builder); } else { _visitables.get("channels").set(index, builder); channels.set(index, builder);}
    return (A)this;
  }
  public A addToChannels(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannel... items) {
    if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
    for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
  }
  public A addAllToChannels(Collection<PackageChannel> items) {
    if (this.channels == null) {this.channels = new ArrayList<PackageChannelBuilder>();}
    for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
  }
  public A removeFromChannels(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannel... items) {
    if (this.channels == null) return (A)this;
    for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").remove(builder); this.channels.remove(builder);} return (A)this;
  }
  public A removeAllFromChannels(Collection<PackageChannel> items) {
    if (this.channels == null) return (A)this;
    for (PackageChannel item : items) {PackageChannelBuilder builder = new PackageChannelBuilder(item);_visitables.get("channels").remove(builder); this.channels.remove(builder);} return (A)this;
  }
  public A removeMatchingFromChannels(Predicate<PackageChannelBuilder> predicate) {
    if (channels == null) return (A) this;
    final Iterator<PackageChannelBuilder> each = channels.iterator();
    final List visitables = _visitables.get("channels");
    while (each.hasNext()) {
      PackageChannelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<PackageChannel> buildChannels() {
    return channels != null ? build(channels) : null;
  }
  public PackageChannel buildChannel(int index) {
    return this.channels.get(index).build();
  }
  public PackageChannel buildFirstChannel() {
    return this.channels.get(0).build();
  }
  public PackageChannel buildLastChannel() {
    return this.channels.get(channels.size() - 1).build();
  }
  public PackageChannel buildMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
    for (PackageChannelBuilder item: channels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
    for (PackageChannelBuilder item: channels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withChannels(List<PackageChannel> channels) {
    if (this.channels != null) { _visitables.get("channels").clear();}
    if (channels != null) {this.channels = new ArrayList(); for (PackageChannel item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
  }
  public A withChannels(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannel... channels) {
    if (this.channels != null) {this.channels.clear(); _visitables.remove("channels"); }
    if (channels != null) {for (PackageChannel item :channels){ this.addToChannels(item);}} return (A) this;
  }
  public boolean hasChannels() {
    return channels != null && !channels.isEmpty();
  }
  public ChannelsNested<A> addNewChannel() {
    return new ChannelsNested(-1, null);
  }
  public ChannelsNested<A> addNewChannelLike(PackageChannel item) {
    return new ChannelsNested(-1, item);
  }
  public ChannelsNested<A> setNewChannelLike(int index,PackageChannel item) {
    return new ChannelsNested(index, item);
  }
  public ChannelsNested<A> editChannel(int index) {
    if (channels.size() <= index) throw new RuntimeException("Can't edit channels. Index exceeds size.");
    return setNewChannelLike(index, buildChannel(index));
  }
  public ChannelsNested<A> editFirstChannel() {
    if (channels.size() == 0) throw new RuntimeException("Can't edit first channels. The list is empty.");
    return setNewChannelLike(0, buildChannel(0));
  }
  public ChannelsNested<A> editLastChannel() {
    int index = channels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last channels. The list is empty.");
    return setNewChannelLike(index, buildChannel(index));
  }
  public ChannelsNested<A> editMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<channels.size();i++) { 
    if (predicate.test(channels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching channels. No match found.");
    return setNewChannelLike(index, buildChannel(index));
  }
  public String getDefaultChannel() {
    return this.defaultChannel;
  }
  public A withDefaultChannel(String defaultChannel) {
    this.defaultChannel=defaultChannel; return (A) this;
  }
  public boolean hasDefaultChannel() {
    return this.defaultChannel != null;
  }
  public String getPackageName() {
    return this.packageName;
  }
  public A withPackageName(String packageName) {
    this.packageName=packageName; return (A) this;
  }
  public boolean hasPackageName() {
    return this.packageName != null;
  }
  public AppLink buildProvider() {
    return this.provider!=null ?this.provider.build():null;
  }
  public A withProvider(AppLink provider) {
    _visitables.get("provider").remove(this.provider);
    if (provider!=null){ this.provider= new AppLinkBuilder(provider); _visitables.get("provider").add(this.provider);} else { this.provider = null; _visitables.get("provider").remove(this.provider); } return (A) this;
  }
  public boolean hasProvider() {
    return this.provider != null;
  }
  public A withNewProvider(String name,String url) {
    return (A)withProvider(new AppLink(name, url));
  }
  public ProviderNested<A> withNewProvider() {
    return new ProviderNested(null);
  }
  public ProviderNested<A> withNewProviderLike(AppLink item) {
    return new ProviderNested(item);
  }
  public ProviderNested<A> editProvider() {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(null));
  }
  public ProviderNested<A> editOrNewProvider() {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(new AppLinkBuilder().build()));
  }
  public ProviderNested<A> editOrNewProviderLike(AppLink item) {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PackageManifestStatusFluent that = (PackageManifestStatusFluent) o;
    if (!java.util.Objects.equals(catalogSource, that.catalogSource)) return false;

    if (!java.util.Objects.equals(catalogSourceDisplayName, that.catalogSourceDisplayName)) return false;

    if (!java.util.Objects.equals(catalogSourceNamespace, that.catalogSourceNamespace)) return false;

    if (!java.util.Objects.equals(catalogSourcePublisher, that.catalogSourcePublisher)) return false;

    if (!java.util.Objects.equals(channels, that.channels)) return false;

    if (!java.util.Objects.equals(defaultChannel, that.defaultChannel)) return false;

    if (!java.util.Objects.equals(packageName, that.packageName)) return false;

    if (!java.util.Objects.equals(provider, that.provider)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(catalogSource,  catalogSourceDisplayName,  catalogSourceNamespace,  catalogSourcePublisher,  channels,  defaultChannel,  packageName,  provider,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (catalogSource != null) { sb.append("catalogSource:"); sb.append(catalogSource + ","); }
    if (catalogSourceDisplayName != null) { sb.append("catalogSourceDisplayName:"); sb.append(catalogSourceDisplayName + ","); }
    if (catalogSourceNamespace != null) { sb.append("catalogSourceNamespace:"); sb.append(catalogSourceNamespace + ","); }
    if (catalogSourcePublisher != null) { sb.append("catalogSourcePublisher:"); sb.append(catalogSourcePublisher + ","); }
    if (channels != null && !channels.isEmpty()) { sb.append("channels:"); sb.append(channels + ","); }
    if (defaultChannel != null) { sb.append("defaultChannel:"); sb.append(defaultChannel + ","); }
    if (packageName != null) { sb.append("packageName:"); sb.append(packageName + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ChannelsNested<N> extends PackageChannelFluent<ChannelsNested<N>> implements Nested<N>{
    ChannelsNested(int index,PackageChannel item) {
      this.index = index;
      this.builder = new PackageChannelBuilder(this, item);
    }
    PackageChannelBuilder builder;
    int index;
    public N and() {
      return (N) PackageManifestStatusFluent.this.setToChannels(index,builder.build());
    }
    public N endChannel() {
      return and();
    }
    
  }
  public class ProviderNested<N> extends AppLinkFluent<ProviderNested<N>> implements Nested<N>{
    ProviderNested(AppLink item) {
      this.builder = new AppLinkBuilder(this, item);
    }
    AppLinkBuilder builder;
    public N and() {
      return (N) PackageManifestStatusFluent.this.withProvider(builder.build());
    }
    public N endProvider() {
      return and();
    }
    
  }
  
}