package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PackageChannelBuilder extends PackageChannelFluent<PackageChannelBuilder> implements VisitableBuilder<PackageChannel,PackageChannelBuilder>{
  public PackageChannelBuilder() {
    this(false);
  }
  public PackageChannelBuilder(Boolean validationEnabled) {
    this(new PackageChannel(), validationEnabled);
  }
  public PackageChannelBuilder(PackageChannelFluent<?> fluent) {
    this(fluent, false);
  }
  public PackageChannelBuilder(PackageChannelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PackageChannel(), validationEnabled);
  }
  public PackageChannelBuilder(PackageChannelFluent<?> fluent,PackageChannel instance) {
    this(fluent, instance, false);
  }
  public PackageChannelBuilder(PackageChannelFluent<?> fluent,PackageChannel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PackageChannel());

    if (instance != null) {
      fluent.withCurrentCSV(instance.getCurrentCSV());
      fluent.withCurrentCSVDesc(instance.getCurrentCSVDesc());
      fluent.withName(instance.getName());
      fluent.withCurrentCSV(instance.getCurrentCSV());
      fluent.withCurrentCSVDesc(instance.getCurrentCSVDesc());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PackageChannelBuilder(PackageChannel instance) {
    this(instance,false);
  }
  public PackageChannelBuilder(PackageChannel instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PackageChannel());

    if (instance != null) {
      this.withCurrentCSV(instance.getCurrentCSV());
      this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
      this.withName(instance.getName());
      this.withCurrentCSV(instance.getCurrentCSV());
      this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PackageChannelFluent<?> fluent;
  Boolean validationEnabled;
  public PackageChannel build() {
    PackageChannel buildable = new PackageChannel(fluent.getCurrentCSV(),fluent.buildCurrentCSVDesc(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}