package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.Iterator;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ScrapeConfigSpecFluent<A extends ScrapeConfigSpecFluent<A>> extends BaseFluent<A>{
  public ScrapeConfigSpecFluent() {
  }
  
  public ScrapeConfigSpecFluent(ScrapeConfigSpec instance) {
    this.copyInstance(instance);
  }
  private SafeAuthorizationBuilder authorization;
  private ArrayList<AzureSDConfigBuilder> azureSDConfigs = new ArrayList<AzureSDConfigBuilder>();
  private BasicAuthBuilder basicAuth;
  private ArrayList<ConsulSDConfigBuilder> consulSDConfigs = new ArrayList<ConsulSDConfigBuilder>();
  private ArrayList<DigitalOceanSDConfigBuilder> digitalOceanSDConfigs = new ArrayList<DigitalOceanSDConfigBuilder>();
  private ArrayList<DNSSDConfigBuilder> dnsSDConfigs = new ArrayList<DNSSDConfigBuilder>();
  private ArrayList<DockerSDConfigBuilder> dockerSDConfigs = new ArrayList<DockerSDConfigBuilder>();
  private ArrayList<DockerSwarmSDConfigBuilder> dockerSwarmSDConfigs = new ArrayList<DockerSwarmSDConfigBuilder>();
  private ArrayList<EC2SDConfigBuilder> ec2SDConfigs = new ArrayList<EC2SDConfigBuilder>();
  private Boolean enableCompression;
  private Boolean enableHTTP2;
  private ArrayList<EurekaSDConfigBuilder> eurekaSDConfigs = new ArrayList<EurekaSDConfigBuilder>();
  private String fallbackScrapeProtocol;
  private ArrayList<FileSDConfigBuilder> fileSDConfigs = new ArrayList<FileSDConfigBuilder>();
  private ArrayList<GCESDConfigBuilder> gceSDConfigs = new ArrayList<GCESDConfigBuilder>();
  private ArrayList<HetznerSDConfigBuilder> hetznerSDConfigs = new ArrayList<HetznerSDConfigBuilder>();
  private Boolean honorLabels;
  private Boolean honorTimestamps;
  private ArrayList<HTTPSDConfigBuilder> httpSDConfigs = new ArrayList<HTTPSDConfigBuilder>();
  private ArrayList<IonosSDConfigBuilder> ionosSDConfigs = new ArrayList<IonosSDConfigBuilder>();
  private String jobName;
  private Long keepDroppedTargets;
  private ArrayList<KubernetesSDConfigBuilder> kubernetesSDConfigs = new ArrayList<KubernetesSDConfigBuilder>();
  private ArrayList<KumaSDConfigBuilder> kumaSDConfigs = new ArrayList<KumaSDConfigBuilder>();
  private Long labelLimit;
  private Long labelNameLengthLimit;
  private Long labelValueLengthLimit;
  private ArrayList<LightSailSDConfigBuilder> lightSailSDConfigs = new ArrayList<LightSailSDConfigBuilder>();
  private ArrayList<LinodeSDConfigBuilder> linodeSDConfigs = new ArrayList<LinodeSDConfigBuilder>();
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList<RelabelConfigBuilder>();
  private String metricsPath;
  private Long nativeHistogramBucketLimit;
  private Quantity nativeHistogramMinBucketFactor;
  private String noProxy;
  private ArrayList<NomadSDConfigBuilder> nomadSDConfigs = new ArrayList<NomadSDConfigBuilder>();
  private OAuth2Builder oauth2;
  private ArrayList<OpenStackSDConfigBuilder> openstackSDConfigs = new ArrayList<OpenStackSDConfigBuilder>();
  private ArrayList<OVHCloudSDConfigBuilder> ovhcloudSDConfigs = new ArrayList<OVHCloudSDConfigBuilder>();
  private Map<String,List<String>> params;
  private Map<String,List<SecretKeySelector>> proxyConnectHeader;
  private Boolean proxyFromEnvironment;
  private String proxyUrl;
  private ArrayList<PuppetDBSDConfigBuilder> puppetDBSDConfigs = new ArrayList<PuppetDBSDConfigBuilder>();
  private ArrayList<RelabelConfigBuilder> relabelings = new ArrayList<RelabelConfigBuilder>();
  private Long sampleLimit;
  private ArrayList<ScalewaySDConfigBuilder> scalewaySDConfigs = new ArrayList<ScalewaySDConfigBuilder>();
  private String scheme;
  private String scrapeClass;
  private Boolean scrapeClassicHistograms;
  private String scrapeInterval;
  private List<String> scrapeProtocols = new ArrayList<String>();
  private String scrapeTimeout;
  private ArrayList<StaticConfigBuilder> staticConfigs = new ArrayList<StaticConfigBuilder>();
  private Long targetLimit;
  private SafeTLSConfigBuilder tlsConfig;
  private Boolean trackTimestampsStaleness;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ScrapeConfigSpec instance) {
    instance = (instance != null ? instance : new ScrapeConfigSpec());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withAzureSDConfigs(instance.getAzureSDConfigs());
          this.withBasicAuth(instance.getBasicAuth());
          this.withConsulSDConfigs(instance.getConsulSDConfigs());
          this.withDigitalOceanSDConfigs(instance.getDigitalOceanSDConfigs());
          this.withDnsSDConfigs(instance.getDnsSDConfigs());
          this.withDockerSDConfigs(instance.getDockerSDConfigs());
          this.withDockerSwarmSDConfigs(instance.getDockerSwarmSDConfigs());
          this.withEc2SDConfigs(instance.getEc2SDConfigs());
          this.withEnableCompression(instance.getEnableCompression());
          this.withEnableHTTP2(instance.getEnableHTTP2());
          this.withEurekaSDConfigs(instance.getEurekaSDConfigs());
          this.withFallbackScrapeProtocol(instance.getFallbackScrapeProtocol());
          this.withFileSDConfigs(instance.getFileSDConfigs());
          this.withGceSDConfigs(instance.getGceSDConfigs());
          this.withHetznerSDConfigs(instance.getHetznerSDConfigs());
          this.withHonorLabels(instance.getHonorLabels());
          this.withHonorTimestamps(instance.getHonorTimestamps());
          this.withHttpSDConfigs(instance.getHttpSDConfigs());
          this.withIonosSDConfigs(instance.getIonosSDConfigs());
          this.withJobName(instance.getJobName());
          this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
          this.withKubernetesSDConfigs(instance.getKubernetesSDConfigs());
          this.withKumaSDConfigs(instance.getKumaSDConfigs());
          this.withLabelLimit(instance.getLabelLimit());
          this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
          this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
          this.withLightSailSDConfigs(instance.getLightSailSDConfigs());
          this.withLinodeSDConfigs(instance.getLinodeSDConfigs());
          this.withMetricRelabelings(instance.getMetricRelabelings());
          this.withMetricsPath(instance.getMetricsPath());
          this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
          this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
          this.withNoProxy(instance.getNoProxy());
          this.withNomadSDConfigs(instance.getNomadSDConfigs());
          this.withOauth2(instance.getOauth2());
          this.withOpenstackSDConfigs(instance.getOpenstackSDConfigs());
          this.withOvhcloudSDConfigs(instance.getOvhcloudSDConfigs());
          this.withParams(instance.getParams());
          this.withProxyConnectHeader(instance.getProxyConnectHeader());
          this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
          this.withProxyUrl(instance.getProxyUrl());
          this.withPuppetDBSDConfigs(instance.getPuppetDBSDConfigs());
          this.withRelabelings(instance.getRelabelings());
          this.withSampleLimit(instance.getSampleLimit());
          this.withScalewaySDConfigs(instance.getScalewaySDConfigs());
          this.withScheme(instance.getScheme());
          this.withScrapeClass(instance.getScrapeClass());
          this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
          this.withScrapeInterval(instance.getScrapeInterval());
          this.withScrapeProtocols(instance.getScrapeProtocols());
          this.withScrapeTimeout(instance.getScrapeTimeout());
          this.withStaticConfigs(instance.getStaticConfigs());
          this.withTargetLimit(instance.getTargetLimit());
          this.withTlsConfig(instance.getTlsConfig());
          this.withTrackTimestampsStaleness(instance.getTrackTimestampsStaleness());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SafeAuthorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(SafeAuthorization authorization) {
    this._visitables.remove("authorization");
    if (authorization != null) {
        this.authorization = new SafeAuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public A addToAzureSDConfigs(int index,AzureSDConfig item) {
    if (this.azureSDConfigs == null) {this.azureSDConfigs = new ArrayList<AzureSDConfigBuilder>();}
    AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);
    if (index < 0 || index >= azureSDConfigs.size()) { _visitables.get("azureSDConfigs").add(builder); azureSDConfigs.add(builder); } else { _visitables.get("azureSDConfigs").add(index, builder); azureSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzureSDConfigs(int index,AzureSDConfig item) {
    if (this.azureSDConfigs == null) {this.azureSDConfigs = new ArrayList<AzureSDConfigBuilder>();}
    AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);
    if (index < 0 || index >= azureSDConfigs.size()) { _visitables.get("azureSDConfigs").add(builder); azureSDConfigs.add(builder); } else { _visitables.get("azureSDConfigs").set(index, builder); azureSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzureSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.AzureSDConfig... items) {
    if (this.azureSDConfigs == null) {this.azureSDConfigs = new ArrayList<AzureSDConfigBuilder>();}
    for (AzureSDConfig item : items) {AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);_visitables.get("azureSDConfigs").add(builder);this.azureSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToAzureSDConfigs(Collection<AzureSDConfig> items) {
    if (this.azureSDConfigs == null) {this.azureSDConfigs = new ArrayList<AzureSDConfigBuilder>();}
    for (AzureSDConfig item : items) {AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);_visitables.get("azureSDConfigs").add(builder);this.azureSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromAzureSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.AzureSDConfig... items) {
    if (this.azureSDConfigs == null) return (A)this;
    for (AzureSDConfig item : items) {AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);_visitables.get("azureSDConfigs").remove(builder); this.azureSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzureSDConfigs(Collection<AzureSDConfig> items) {
    if (this.azureSDConfigs == null) return (A)this;
    for (AzureSDConfig item : items) {AzureSDConfigBuilder builder = new AzureSDConfigBuilder(item);_visitables.get("azureSDConfigs").remove(builder); this.azureSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzureSDConfigs(Predicate<AzureSDConfigBuilder> predicate) {
    if (azureSDConfigs == null) return (A) this;
    final Iterator<AzureSDConfigBuilder> each = azureSDConfigs.iterator();
    final List visitables = _visitables.get("azureSDConfigs");
    while (each.hasNext()) {
      AzureSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AzureSDConfig> buildAzureSDConfigs() {
    return this.azureSDConfigs != null ? build(azureSDConfigs) : null;
  }
  
  public AzureSDConfig buildAzureSDConfig(int index) {
    return this.azureSDConfigs.get(index).build();
  }
  
  public AzureSDConfig buildFirstAzureSDConfig() {
    return this.azureSDConfigs.get(0).build();
  }
  
  public AzureSDConfig buildLastAzureSDConfig() {
    return this.azureSDConfigs.get(azureSDConfigs.size() - 1).build();
  }
  
  public AzureSDConfig buildMatchingAzureSDConfig(Predicate<AzureSDConfigBuilder> predicate) {
      for (AzureSDConfigBuilder item : azureSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzureSDConfig(Predicate<AzureSDConfigBuilder> predicate) {
      for (AzureSDConfigBuilder item : azureSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAzureSDConfigs(List<AzureSDConfig> azureSDConfigs) {
    if (this.azureSDConfigs != null) {
      this._visitables.get("azureSDConfigs").clear();
    }
    if (azureSDConfigs != null) {
        this.azureSDConfigs = new ArrayList();
        for (AzureSDConfig item : azureSDConfigs) {
          this.addToAzureSDConfigs(item);
        }
    } else {
      this.azureSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withAzureSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.AzureSDConfig... azureSDConfigs) {
    if (this.azureSDConfigs != null) {
        this.azureSDConfigs.clear();
        _visitables.remove("azureSDConfigs");
    }
    if (azureSDConfigs != null) {
      for (AzureSDConfig item : azureSDConfigs) {
        this.addToAzureSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAzureSDConfigs() {
    return this.azureSDConfigs != null && !this.azureSDConfigs.isEmpty();
  }
  
  public AzureSDConfigsNested<A> addNewAzureSDConfig() {
    return new AzureSDConfigsNested(-1, null);
  }
  
  public AzureSDConfigsNested<A> addNewAzureSDConfigLike(AzureSDConfig item) {
    return new AzureSDConfigsNested(-1, item);
  }
  
  public AzureSDConfigsNested<A> setNewAzureSDConfigLike(int index,AzureSDConfig item) {
    return new AzureSDConfigsNested(index, item);
  }
  
  public AzureSDConfigsNested<A> editAzureSDConfig(int index) {
    if (azureSDConfigs.size() <= index) throw new RuntimeException("Can't edit azureSDConfigs. Index exceeds size.");
    return setNewAzureSDConfigLike(index, buildAzureSDConfig(index));
  }
  
  public AzureSDConfigsNested<A> editFirstAzureSDConfig() {
    if (azureSDConfigs.size() == 0) throw new RuntimeException("Can't edit first azureSDConfigs. The list is empty.");
    return setNewAzureSDConfigLike(0, buildAzureSDConfig(0));
  }
  
  public AzureSDConfigsNested<A> editLastAzureSDConfig() {
    int index = azureSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azureSDConfigs. The list is empty.");
    return setNewAzureSDConfigLike(index, buildAzureSDConfig(index));
  }
  
  public AzureSDConfigsNested<A> editMatchingAzureSDConfig(Predicate<AzureSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azureSDConfigs.size();i++) { 
    if (predicate.test(azureSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azureSDConfigs. No match found.");
    return setNewAzureSDConfigLike(index, buildAzureSDConfig(index));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove("basicAuth");
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public A addToConsulSDConfigs(int index,ConsulSDConfig item) {
    if (this.consulSDConfigs == null) {this.consulSDConfigs = new ArrayList<ConsulSDConfigBuilder>();}
    ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);
    if (index < 0 || index >= consulSDConfigs.size()) { _visitables.get("consulSDConfigs").add(builder); consulSDConfigs.add(builder); } else { _visitables.get("consulSDConfigs").add(index, builder); consulSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToConsulSDConfigs(int index,ConsulSDConfig item) {
    if (this.consulSDConfigs == null) {this.consulSDConfigs = new ArrayList<ConsulSDConfigBuilder>();}
    ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);
    if (index < 0 || index >= consulSDConfigs.size()) { _visitables.get("consulSDConfigs").add(builder); consulSDConfigs.add(builder); } else { _visitables.get("consulSDConfigs").set(index, builder); consulSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToConsulSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ConsulSDConfig... items) {
    if (this.consulSDConfigs == null) {this.consulSDConfigs = new ArrayList<ConsulSDConfigBuilder>();}
    for (ConsulSDConfig item : items) {ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);_visitables.get("consulSDConfigs").add(builder);this.consulSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToConsulSDConfigs(Collection<ConsulSDConfig> items) {
    if (this.consulSDConfigs == null) {this.consulSDConfigs = new ArrayList<ConsulSDConfigBuilder>();}
    for (ConsulSDConfig item : items) {ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);_visitables.get("consulSDConfigs").add(builder);this.consulSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromConsulSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ConsulSDConfig... items) {
    if (this.consulSDConfigs == null) return (A)this;
    for (ConsulSDConfig item : items) {ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);_visitables.get("consulSDConfigs").remove(builder); this.consulSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConsulSDConfigs(Collection<ConsulSDConfig> items) {
    if (this.consulSDConfigs == null) return (A)this;
    for (ConsulSDConfig item : items) {ConsulSDConfigBuilder builder = new ConsulSDConfigBuilder(item);_visitables.get("consulSDConfigs").remove(builder); this.consulSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConsulSDConfigs(Predicate<ConsulSDConfigBuilder> predicate) {
    if (consulSDConfigs == null) return (A) this;
    final Iterator<ConsulSDConfigBuilder> each = consulSDConfigs.iterator();
    final List visitables = _visitables.get("consulSDConfigs");
    while (each.hasNext()) {
      ConsulSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ConsulSDConfig> buildConsulSDConfigs() {
    return this.consulSDConfigs != null ? build(consulSDConfigs) : null;
  }
  
  public ConsulSDConfig buildConsulSDConfig(int index) {
    return this.consulSDConfigs.get(index).build();
  }
  
  public ConsulSDConfig buildFirstConsulSDConfig() {
    return this.consulSDConfigs.get(0).build();
  }
  
  public ConsulSDConfig buildLastConsulSDConfig() {
    return this.consulSDConfigs.get(consulSDConfigs.size() - 1).build();
  }
  
  public ConsulSDConfig buildMatchingConsulSDConfig(Predicate<ConsulSDConfigBuilder> predicate) {
      for (ConsulSDConfigBuilder item : consulSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConsulSDConfig(Predicate<ConsulSDConfigBuilder> predicate) {
      for (ConsulSDConfigBuilder item : consulSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConsulSDConfigs(List<ConsulSDConfig> consulSDConfigs) {
    if (this.consulSDConfigs != null) {
      this._visitables.get("consulSDConfigs").clear();
    }
    if (consulSDConfigs != null) {
        this.consulSDConfigs = new ArrayList();
        for (ConsulSDConfig item : consulSDConfigs) {
          this.addToConsulSDConfigs(item);
        }
    } else {
      this.consulSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withConsulSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ConsulSDConfig... consulSDConfigs) {
    if (this.consulSDConfigs != null) {
        this.consulSDConfigs.clear();
        _visitables.remove("consulSDConfigs");
    }
    if (consulSDConfigs != null) {
      for (ConsulSDConfig item : consulSDConfigs) {
        this.addToConsulSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConsulSDConfigs() {
    return this.consulSDConfigs != null && !this.consulSDConfigs.isEmpty();
  }
  
  public ConsulSDConfigsNested<A> addNewConsulSDConfig() {
    return new ConsulSDConfigsNested(-1, null);
  }
  
  public ConsulSDConfigsNested<A> addNewConsulSDConfigLike(ConsulSDConfig item) {
    return new ConsulSDConfigsNested(-1, item);
  }
  
  public ConsulSDConfigsNested<A> setNewConsulSDConfigLike(int index,ConsulSDConfig item) {
    return new ConsulSDConfigsNested(index, item);
  }
  
  public ConsulSDConfigsNested<A> editConsulSDConfig(int index) {
    if (consulSDConfigs.size() <= index) throw new RuntimeException("Can't edit consulSDConfigs. Index exceeds size.");
    return setNewConsulSDConfigLike(index, buildConsulSDConfig(index));
  }
  
  public ConsulSDConfigsNested<A> editFirstConsulSDConfig() {
    if (consulSDConfigs.size() == 0) throw new RuntimeException("Can't edit first consulSDConfigs. The list is empty.");
    return setNewConsulSDConfigLike(0, buildConsulSDConfig(0));
  }
  
  public ConsulSDConfigsNested<A> editLastConsulSDConfig() {
    int index = consulSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last consulSDConfigs. The list is empty.");
    return setNewConsulSDConfigLike(index, buildConsulSDConfig(index));
  }
  
  public ConsulSDConfigsNested<A> editMatchingConsulSDConfig(Predicate<ConsulSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<consulSDConfigs.size();i++) { 
    if (predicate.test(consulSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching consulSDConfigs. No match found.");
    return setNewConsulSDConfigLike(index, buildConsulSDConfig(index));
  }
  
  public A addToDigitalOceanSDConfigs(int index,DigitalOceanSDConfig item) {
    if (this.digitalOceanSDConfigs == null) {this.digitalOceanSDConfigs = new ArrayList<DigitalOceanSDConfigBuilder>();}
    DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);
    if (index < 0 || index >= digitalOceanSDConfigs.size()) { _visitables.get("digitalOceanSDConfigs").add(builder); digitalOceanSDConfigs.add(builder); } else { _visitables.get("digitalOceanSDConfigs").add(index, builder); digitalOceanSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToDigitalOceanSDConfigs(int index,DigitalOceanSDConfig item) {
    if (this.digitalOceanSDConfigs == null) {this.digitalOceanSDConfigs = new ArrayList<DigitalOceanSDConfigBuilder>();}
    DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);
    if (index < 0 || index >= digitalOceanSDConfigs.size()) { _visitables.get("digitalOceanSDConfigs").add(builder); digitalOceanSDConfigs.add(builder); } else { _visitables.get("digitalOceanSDConfigs").set(index, builder); digitalOceanSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToDigitalOceanSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DigitalOceanSDConfig... items) {
    if (this.digitalOceanSDConfigs == null) {this.digitalOceanSDConfigs = new ArrayList<DigitalOceanSDConfigBuilder>();}
    for (DigitalOceanSDConfig item : items) {DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);_visitables.get("digitalOceanSDConfigs").add(builder);this.digitalOceanSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToDigitalOceanSDConfigs(Collection<DigitalOceanSDConfig> items) {
    if (this.digitalOceanSDConfigs == null) {this.digitalOceanSDConfigs = new ArrayList<DigitalOceanSDConfigBuilder>();}
    for (DigitalOceanSDConfig item : items) {DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);_visitables.get("digitalOceanSDConfigs").add(builder);this.digitalOceanSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromDigitalOceanSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DigitalOceanSDConfig... items) {
    if (this.digitalOceanSDConfigs == null) return (A)this;
    for (DigitalOceanSDConfig item : items) {DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);_visitables.get("digitalOceanSDConfigs").remove(builder); this.digitalOceanSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDigitalOceanSDConfigs(Collection<DigitalOceanSDConfig> items) {
    if (this.digitalOceanSDConfigs == null) return (A)this;
    for (DigitalOceanSDConfig item : items) {DigitalOceanSDConfigBuilder builder = new DigitalOceanSDConfigBuilder(item);_visitables.get("digitalOceanSDConfigs").remove(builder); this.digitalOceanSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDigitalOceanSDConfigs(Predicate<DigitalOceanSDConfigBuilder> predicate) {
    if (digitalOceanSDConfigs == null) return (A) this;
    final Iterator<DigitalOceanSDConfigBuilder> each = digitalOceanSDConfigs.iterator();
    final List visitables = _visitables.get("digitalOceanSDConfigs");
    while (each.hasNext()) {
      DigitalOceanSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DigitalOceanSDConfig> buildDigitalOceanSDConfigs() {
    return this.digitalOceanSDConfigs != null ? build(digitalOceanSDConfigs) : null;
  }
  
  public DigitalOceanSDConfig buildDigitalOceanSDConfig(int index) {
    return this.digitalOceanSDConfigs.get(index).build();
  }
  
  public DigitalOceanSDConfig buildFirstDigitalOceanSDConfig() {
    return this.digitalOceanSDConfigs.get(0).build();
  }
  
  public DigitalOceanSDConfig buildLastDigitalOceanSDConfig() {
    return this.digitalOceanSDConfigs.get(digitalOceanSDConfigs.size() - 1).build();
  }
  
  public DigitalOceanSDConfig buildMatchingDigitalOceanSDConfig(Predicate<DigitalOceanSDConfigBuilder> predicate) {
      for (DigitalOceanSDConfigBuilder item : digitalOceanSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDigitalOceanSDConfig(Predicate<DigitalOceanSDConfigBuilder> predicate) {
      for (DigitalOceanSDConfigBuilder item : digitalOceanSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDigitalOceanSDConfigs(List<DigitalOceanSDConfig> digitalOceanSDConfigs) {
    if (this.digitalOceanSDConfigs != null) {
      this._visitables.get("digitalOceanSDConfigs").clear();
    }
    if (digitalOceanSDConfigs != null) {
        this.digitalOceanSDConfigs = new ArrayList();
        for (DigitalOceanSDConfig item : digitalOceanSDConfigs) {
          this.addToDigitalOceanSDConfigs(item);
        }
    } else {
      this.digitalOceanSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withDigitalOceanSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DigitalOceanSDConfig... digitalOceanSDConfigs) {
    if (this.digitalOceanSDConfigs != null) {
        this.digitalOceanSDConfigs.clear();
        _visitables.remove("digitalOceanSDConfigs");
    }
    if (digitalOceanSDConfigs != null) {
      for (DigitalOceanSDConfig item : digitalOceanSDConfigs) {
        this.addToDigitalOceanSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDigitalOceanSDConfigs() {
    return this.digitalOceanSDConfigs != null && !this.digitalOceanSDConfigs.isEmpty();
  }
  
  public DigitalOceanSDConfigsNested<A> addNewDigitalOceanSDConfig() {
    return new DigitalOceanSDConfigsNested(-1, null);
  }
  
  public DigitalOceanSDConfigsNested<A> addNewDigitalOceanSDConfigLike(DigitalOceanSDConfig item) {
    return new DigitalOceanSDConfigsNested(-1, item);
  }
  
  public DigitalOceanSDConfigsNested<A> setNewDigitalOceanSDConfigLike(int index,DigitalOceanSDConfig item) {
    return new DigitalOceanSDConfigsNested(index, item);
  }
  
  public DigitalOceanSDConfigsNested<A> editDigitalOceanSDConfig(int index) {
    if (digitalOceanSDConfigs.size() <= index) throw new RuntimeException("Can't edit digitalOceanSDConfigs. Index exceeds size.");
    return setNewDigitalOceanSDConfigLike(index, buildDigitalOceanSDConfig(index));
  }
  
  public DigitalOceanSDConfigsNested<A> editFirstDigitalOceanSDConfig() {
    if (digitalOceanSDConfigs.size() == 0) throw new RuntimeException("Can't edit first digitalOceanSDConfigs. The list is empty.");
    return setNewDigitalOceanSDConfigLike(0, buildDigitalOceanSDConfig(0));
  }
  
  public DigitalOceanSDConfigsNested<A> editLastDigitalOceanSDConfig() {
    int index = digitalOceanSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last digitalOceanSDConfigs. The list is empty.");
    return setNewDigitalOceanSDConfigLike(index, buildDigitalOceanSDConfig(index));
  }
  
  public DigitalOceanSDConfigsNested<A> editMatchingDigitalOceanSDConfig(Predicate<DigitalOceanSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<digitalOceanSDConfigs.size();i++) { 
    if (predicate.test(digitalOceanSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching digitalOceanSDConfigs. No match found.");
    return setNewDigitalOceanSDConfigLike(index, buildDigitalOceanSDConfig(index));
  }
  
  public A addToDnsSDConfigs(int index,DNSSDConfig item) {
    if (this.dnsSDConfigs == null) {this.dnsSDConfigs = new ArrayList<DNSSDConfigBuilder>();}
    DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);
    if (index < 0 || index >= dnsSDConfigs.size()) { _visitables.get("dnsSDConfigs").add(builder); dnsSDConfigs.add(builder); } else { _visitables.get("dnsSDConfigs").add(index, builder); dnsSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToDnsSDConfigs(int index,DNSSDConfig item) {
    if (this.dnsSDConfigs == null) {this.dnsSDConfigs = new ArrayList<DNSSDConfigBuilder>();}
    DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);
    if (index < 0 || index >= dnsSDConfigs.size()) { _visitables.get("dnsSDConfigs").add(builder); dnsSDConfigs.add(builder); } else { _visitables.get("dnsSDConfigs").set(index, builder); dnsSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToDnsSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DNSSDConfig... items) {
    if (this.dnsSDConfigs == null) {this.dnsSDConfigs = new ArrayList<DNSSDConfigBuilder>();}
    for (DNSSDConfig item : items) {DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);_visitables.get("dnsSDConfigs").add(builder);this.dnsSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToDnsSDConfigs(Collection<DNSSDConfig> items) {
    if (this.dnsSDConfigs == null) {this.dnsSDConfigs = new ArrayList<DNSSDConfigBuilder>();}
    for (DNSSDConfig item : items) {DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);_visitables.get("dnsSDConfigs").add(builder);this.dnsSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromDnsSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DNSSDConfig... items) {
    if (this.dnsSDConfigs == null) return (A)this;
    for (DNSSDConfig item : items) {DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);_visitables.get("dnsSDConfigs").remove(builder); this.dnsSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDnsSDConfigs(Collection<DNSSDConfig> items) {
    if (this.dnsSDConfigs == null) return (A)this;
    for (DNSSDConfig item : items) {DNSSDConfigBuilder builder = new DNSSDConfigBuilder(item);_visitables.get("dnsSDConfigs").remove(builder); this.dnsSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDnsSDConfigs(Predicate<DNSSDConfigBuilder> predicate) {
    if (dnsSDConfigs == null) return (A) this;
    final Iterator<DNSSDConfigBuilder> each = dnsSDConfigs.iterator();
    final List visitables = _visitables.get("dnsSDConfigs");
    while (each.hasNext()) {
      DNSSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DNSSDConfig> buildDnsSDConfigs() {
    return this.dnsSDConfigs != null ? build(dnsSDConfigs) : null;
  }
  
  public DNSSDConfig buildDnsSDConfig(int index) {
    return this.dnsSDConfigs.get(index).build();
  }
  
  public DNSSDConfig buildFirstDnsSDConfig() {
    return this.dnsSDConfigs.get(0).build();
  }
  
  public DNSSDConfig buildLastDnsSDConfig() {
    return this.dnsSDConfigs.get(dnsSDConfigs.size() - 1).build();
  }
  
  public DNSSDConfig buildMatchingDnsSDConfig(Predicate<DNSSDConfigBuilder> predicate) {
      for (DNSSDConfigBuilder item : dnsSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDnsSDConfig(Predicate<DNSSDConfigBuilder> predicate) {
      for (DNSSDConfigBuilder item : dnsSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDnsSDConfigs(List<DNSSDConfig> dnsSDConfigs) {
    if (this.dnsSDConfigs != null) {
      this._visitables.get("dnsSDConfigs").clear();
    }
    if (dnsSDConfigs != null) {
        this.dnsSDConfigs = new ArrayList();
        for (DNSSDConfig item : dnsSDConfigs) {
          this.addToDnsSDConfigs(item);
        }
    } else {
      this.dnsSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withDnsSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DNSSDConfig... dnsSDConfigs) {
    if (this.dnsSDConfigs != null) {
        this.dnsSDConfigs.clear();
        _visitables.remove("dnsSDConfigs");
    }
    if (dnsSDConfigs != null) {
      for (DNSSDConfig item : dnsSDConfigs) {
        this.addToDnsSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDnsSDConfigs() {
    return this.dnsSDConfigs != null && !this.dnsSDConfigs.isEmpty();
  }
  
  public DnsSDConfigsNested<A> addNewDnsSDConfig() {
    return new DnsSDConfigsNested(-1, null);
  }
  
  public DnsSDConfigsNested<A> addNewDnsSDConfigLike(DNSSDConfig item) {
    return new DnsSDConfigsNested(-1, item);
  }
  
  public DnsSDConfigsNested<A> setNewDnsSDConfigLike(int index,DNSSDConfig item) {
    return new DnsSDConfigsNested(index, item);
  }
  
  public DnsSDConfigsNested<A> editDnsSDConfig(int index) {
    if (dnsSDConfigs.size() <= index) throw new RuntimeException("Can't edit dnsSDConfigs. Index exceeds size.");
    return setNewDnsSDConfigLike(index, buildDnsSDConfig(index));
  }
  
  public DnsSDConfigsNested<A> editFirstDnsSDConfig() {
    if (dnsSDConfigs.size() == 0) throw new RuntimeException("Can't edit first dnsSDConfigs. The list is empty.");
    return setNewDnsSDConfigLike(0, buildDnsSDConfig(0));
  }
  
  public DnsSDConfigsNested<A> editLastDnsSDConfig() {
    int index = dnsSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dnsSDConfigs. The list is empty.");
    return setNewDnsSDConfigLike(index, buildDnsSDConfig(index));
  }
  
  public DnsSDConfigsNested<A> editMatchingDnsSDConfig(Predicate<DNSSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dnsSDConfigs.size();i++) { 
    if (predicate.test(dnsSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dnsSDConfigs. No match found.");
    return setNewDnsSDConfigLike(index, buildDnsSDConfig(index));
  }
  
  public A addToDockerSDConfigs(int index,DockerSDConfig item) {
    if (this.dockerSDConfigs == null) {this.dockerSDConfigs = new ArrayList<DockerSDConfigBuilder>();}
    DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);
    if (index < 0 || index >= dockerSDConfigs.size()) { _visitables.get("dockerSDConfigs").add(builder); dockerSDConfigs.add(builder); } else { _visitables.get("dockerSDConfigs").add(index, builder); dockerSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToDockerSDConfigs(int index,DockerSDConfig item) {
    if (this.dockerSDConfigs == null) {this.dockerSDConfigs = new ArrayList<DockerSDConfigBuilder>();}
    DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);
    if (index < 0 || index >= dockerSDConfigs.size()) { _visitables.get("dockerSDConfigs").add(builder); dockerSDConfigs.add(builder); } else { _visitables.get("dockerSDConfigs").set(index, builder); dockerSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToDockerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSDConfig... items) {
    if (this.dockerSDConfigs == null) {this.dockerSDConfigs = new ArrayList<DockerSDConfigBuilder>();}
    for (DockerSDConfig item : items) {DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);_visitables.get("dockerSDConfigs").add(builder);this.dockerSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToDockerSDConfigs(Collection<DockerSDConfig> items) {
    if (this.dockerSDConfigs == null) {this.dockerSDConfigs = new ArrayList<DockerSDConfigBuilder>();}
    for (DockerSDConfig item : items) {DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);_visitables.get("dockerSDConfigs").add(builder);this.dockerSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromDockerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSDConfig... items) {
    if (this.dockerSDConfigs == null) return (A)this;
    for (DockerSDConfig item : items) {DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);_visitables.get("dockerSDConfigs").remove(builder); this.dockerSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDockerSDConfigs(Collection<DockerSDConfig> items) {
    if (this.dockerSDConfigs == null) return (A)this;
    for (DockerSDConfig item : items) {DockerSDConfigBuilder builder = new DockerSDConfigBuilder(item);_visitables.get("dockerSDConfigs").remove(builder); this.dockerSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDockerSDConfigs(Predicate<DockerSDConfigBuilder> predicate) {
    if (dockerSDConfigs == null) return (A) this;
    final Iterator<DockerSDConfigBuilder> each = dockerSDConfigs.iterator();
    final List visitables = _visitables.get("dockerSDConfigs");
    while (each.hasNext()) {
      DockerSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DockerSDConfig> buildDockerSDConfigs() {
    return this.dockerSDConfigs != null ? build(dockerSDConfigs) : null;
  }
  
  public DockerSDConfig buildDockerSDConfig(int index) {
    return this.dockerSDConfigs.get(index).build();
  }
  
  public DockerSDConfig buildFirstDockerSDConfig() {
    return this.dockerSDConfigs.get(0).build();
  }
  
  public DockerSDConfig buildLastDockerSDConfig() {
    return this.dockerSDConfigs.get(dockerSDConfigs.size() - 1).build();
  }
  
  public DockerSDConfig buildMatchingDockerSDConfig(Predicate<DockerSDConfigBuilder> predicate) {
      for (DockerSDConfigBuilder item : dockerSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDockerSDConfig(Predicate<DockerSDConfigBuilder> predicate) {
      for (DockerSDConfigBuilder item : dockerSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDockerSDConfigs(List<DockerSDConfig> dockerSDConfigs) {
    if (this.dockerSDConfigs != null) {
      this._visitables.get("dockerSDConfigs").clear();
    }
    if (dockerSDConfigs != null) {
        this.dockerSDConfigs = new ArrayList();
        for (DockerSDConfig item : dockerSDConfigs) {
          this.addToDockerSDConfigs(item);
        }
    } else {
      this.dockerSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withDockerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSDConfig... dockerSDConfigs) {
    if (this.dockerSDConfigs != null) {
        this.dockerSDConfigs.clear();
        _visitables.remove("dockerSDConfigs");
    }
    if (dockerSDConfigs != null) {
      for (DockerSDConfig item : dockerSDConfigs) {
        this.addToDockerSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDockerSDConfigs() {
    return this.dockerSDConfigs != null && !this.dockerSDConfigs.isEmpty();
  }
  
  public DockerSDConfigsNested<A> addNewDockerSDConfig() {
    return new DockerSDConfigsNested(-1, null);
  }
  
  public DockerSDConfigsNested<A> addNewDockerSDConfigLike(DockerSDConfig item) {
    return new DockerSDConfigsNested(-1, item);
  }
  
  public DockerSDConfigsNested<A> setNewDockerSDConfigLike(int index,DockerSDConfig item) {
    return new DockerSDConfigsNested(index, item);
  }
  
  public DockerSDConfigsNested<A> editDockerSDConfig(int index) {
    if (dockerSDConfigs.size() <= index) throw new RuntimeException("Can't edit dockerSDConfigs. Index exceeds size.");
    return setNewDockerSDConfigLike(index, buildDockerSDConfig(index));
  }
  
  public DockerSDConfigsNested<A> editFirstDockerSDConfig() {
    if (dockerSDConfigs.size() == 0) throw new RuntimeException("Can't edit first dockerSDConfigs. The list is empty.");
    return setNewDockerSDConfigLike(0, buildDockerSDConfig(0));
  }
  
  public DockerSDConfigsNested<A> editLastDockerSDConfig() {
    int index = dockerSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dockerSDConfigs. The list is empty.");
    return setNewDockerSDConfigLike(index, buildDockerSDConfig(index));
  }
  
  public DockerSDConfigsNested<A> editMatchingDockerSDConfig(Predicate<DockerSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dockerSDConfigs.size();i++) { 
    if (predicate.test(dockerSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dockerSDConfigs. No match found.");
    return setNewDockerSDConfigLike(index, buildDockerSDConfig(index));
  }
  
  public A addToDockerSwarmSDConfigs(int index,DockerSwarmSDConfig item) {
    if (this.dockerSwarmSDConfigs == null) {this.dockerSwarmSDConfigs = new ArrayList<DockerSwarmSDConfigBuilder>();}
    DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);
    if (index < 0 || index >= dockerSwarmSDConfigs.size()) { _visitables.get("dockerSwarmSDConfigs").add(builder); dockerSwarmSDConfigs.add(builder); } else { _visitables.get("dockerSwarmSDConfigs").add(index, builder); dockerSwarmSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToDockerSwarmSDConfigs(int index,DockerSwarmSDConfig item) {
    if (this.dockerSwarmSDConfigs == null) {this.dockerSwarmSDConfigs = new ArrayList<DockerSwarmSDConfigBuilder>();}
    DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);
    if (index < 0 || index >= dockerSwarmSDConfigs.size()) { _visitables.get("dockerSwarmSDConfigs").add(builder); dockerSwarmSDConfigs.add(builder); } else { _visitables.get("dockerSwarmSDConfigs").set(index, builder); dockerSwarmSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToDockerSwarmSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSwarmSDConfig... items) {
    if (this.dockerSwarmSDConfigs == null) {this.dockerSwarmSDConfigs = new ArrayList<DockerSwarmSDConfigBuilder>();}
    for (DockerSwarmSDConfig item : items) {DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);_visitables.get("dockerSwarmSDConfigs").add(builder);this.dockerSwarmSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToDockerSwarmSDConfigs(Collection<DockerSwarmSDConfig> items) {
    if (this.dockerSwarmSDConfigs == null) {this.dockerSwarmSDConfigs = new ArrayList<DockerSwarmSDConfigBuilder>();}
    for (DockerSwarmSDConfig item : items) {DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);_visitables.get("dockerSwarmSDConfigs").add(builder);this.dockerSwarmSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromDockerSwarmSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSwarmSDConfig... items) {
    if (this.dockerSwarmSDConfigs == null) return (A)this;
    for (DockerSwarmSDConfig item : items) {DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);_visitables.get("dockerSwarmSDConfigs").remove(builder); this.dockerSwarmSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDockerSwarmSDConfigs(Collection<DockerSwarmSDConfig> items) {
    if (this.dockerSwarmSDConfigs == null) return (A)this;
    for (DockerSwarmSDConfig item : items) {DockerSwarmSDConfigBuilder builder = new DockerSwarmSDConfigBuilder(item);_visitables.get("dockerSwarmSDConfigs").remove(builder); this.dockerSwarmSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDockerSwarmSDConfigs(Predicate<DockerSwarmSDConfigBuilder> predicate) {
    if (dockerSwarmSDConfigs == null) return (A) this;
    final Iterator<DockerSwarmSDConfigBuilder> each = dockerSwarmSDConfigs.iterator();
    final List visitables = _visitables.get("dockerSwarmSDConfigs");
    while (each.hasNext()) {
      DockerSwarmSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DockerSwarmSDConfig> buildDockerSwarmSDConfigs() {
    return this.dockerSwarmSDConfigs != null ? build(dockerSwarmSDConfigs) : null;
  }
  
  public DockerSwarmSDConfig buildDockerSwarmSDConfig(int index) {
    return this.dockerSwarmSDConfigs.get(index).build();
  }
  
  public DockerSwarmSDConfig buildFirstDockerSwarmSDConfig() {
    return this.dockerSwarmSDConfigs.get(0).build();
  }
  
  public DockerSwarmSDConfig buildLastDockerSwarmSDConfig() {
    return this.dockerSwarmSDConfigs.get(dockerSwarmSDConfigs.size() - 1).build();
  }
  
  public DockerSwarmSDConfig buildMatchingDockerSwarmSDConfig(Predicate<DockerSwarmSDConfigBuilder> predicate) {
      for (DockerSwarmSDConfigBuilder item : dockerSwarmSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDockerSwarmSDConfig(Predicate<DockerSwarmSDConfigBuilder> predicate) {
      for (DockerSwarmSDConfigBuilder item : dockerSwarmSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDockerSwarmSDConfigs(List<DockerSwarmSDConfig> dockerSwarmSDConfigs) {
    if (this.dockerSwarmSDConfigs != null) {
      this._visitables.get("dockerSwarmSDConfigs").clear();
    }
    if (dockerSwarmSDConfigs != null) {
        this.dockerSwarmSDConfigs = new ArrayList();
        for (DockerSwarmSDConfig item : dockerSwarmSDConfigs) {
          this.addToDockerSwarmSDConfigs(item);
        }
    } else {
      this.dockerSwarmSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withDockerSwarmSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.DockerSwarmSDConfig... dockerSwarmSDConfigs) {
    if (this.dockerSwarmSDConfigs != null) {
        this.dockerSwarmSDConfigs.clear();
        _visitables.remove("dockerSwarmSDConfigs");
    }
    if (dockerSwarmSDConfigs != null) {
      for (DockerSwarmSDConfig item : dockerSwarmSDConfigs) {
        this.addToDockerSwarmSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDockerSwarmSDConfigs() {
    return this.dockerSwarmSDConfigs != null && !this.dockerSwarmSDConfigs.isEmpty();
  }
  
  public DockerSwarmSDConfigsNested<A> addNewDockerSwarmSDConfig() {
    return new DockerSwarmSDConfigsNested(-1, null);
  }
  
  public DockerSwarmSDConfigsNested<A> addNewDockerSwarmSDConfigLike(DockerSwarmSDConfig item) {
    return new DockerSwarmSDConfigsNested(-1, item);
  }
  
  public DockerSwarmSDConfigsNested<A> setNewDockerSwarmSDConfigLike(int index,DockerSwarmSDConfig item) {
    return new DockerSwarmSDConfigsNested(index, item);
  }
  
  public DockerSwarmSDConfigsNested<A> editDockerSwarmSDConfig(int index) {
    if (dockerSwarmSDConfigs.size() <= index) throw new RuntimeException("Can't edit dockerSwarmSDConfigs. Index exceeds size.");
    return setNewDockerSwarmSDConfigLike(index, buildDockerSwarmSDConfig(index));
  }
  
  public DockerSwarmSDConfigsNested<A> editFirstDockerSwarmSDConfig() {
    if (dockerSwarmSDConfigs.size() == 0) throw new RuntimeException("Can't edit first dockerSwarmSDConfigs. The list is empty.");
    return setNewDockerSwarmSDConfigLike(0, buildDockerSwarmSDConfig(0));
  }
  
  public DockerSwarmSDConfigsNested<A> editLastDockerSwarmSDConfig() {
    int index = dockerSwarmSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dockerSwarmSDConfigs. The list is empty.");
    return setNewDockerSwarmSDConfigLike(index, buildDockerSwarmSDConfig(index));
  }
  
  public DockerSwarmSDConfigsNested<A> editMatchingDockerSwarmSDConfig(Predicate<DockerSwarmSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dockerSwarmSDConfigs.size();i++) { 
    if (predicate.test(dockerSwarmSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dockerSwarmSDConfigs. No match found.");
    return setNewDockerSwarmSDConfigLike(index, buildDockerSwarmSDConfig(index));
  }
  
  public A addToEc2SDConfigs(int index,EC2SDConfig item) {
    if (this.ec2SDConfigs == null) {this.ec2SDConfigs = new ArrayList<EC2SDConfigBuilder>();}
    EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);
    if (index < 0 || index >= ec2SDConfigs.size()) { _visitables.get("ec2SDConfigs").add(builder); ec2SDConfigs.add(builder); } else { _visitables.get("ec2SDConfigs").add(index, builder); ec2SDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToEc2SDConfigs(int index,EC2SDConfig item) {
    if (this.ec2SDConfigs == null) {this.ec2SDConfigs = new ArrayList<EC2SDConfigBuilder>();}
    EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);
    if (index < 0 || index >= ec2SDConfigs.size()) { _visitables.get("ec2SDConfigs").add(builder); ec2SDConfigs.add(builder); } else { _visitables.get("ec2SDConfigs").set(index, builder); ec2SDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToEc2SDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EC2SDConfig... items) {
    if (this.ec2SDConfigs == null) {this.ec2SDConfigs = new ArrayList<EC2SDConfigBuilder>();}
    for (EC2SDConfig item : items) {EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);_visitables.get("ec2SDConfigs").add(builder);this.ec2SDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToEc2SDConfigs(Collection<EC2SDConfig> items) {
    if (this.ec2SDConfigs == null) {this.ec2SDConfigs = new ArrayList<EC2SDConfigBuilder>();}
    for (EC2SDConfig item : items) {EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);_visitables.get("ec2SDConfigs").add(builder);this.ec2SDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromEc2SDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EC2SDConfig... items) {
    if (this.ec2SDConfigs == null) return (A)this;
    for (EC2SDConfig item : items) {EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);_visitables.get("ec2SDConfigs").remove(builder); this.ec2SDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEc2SDConfigs(Collection<EC2SDConfig> items) {
    if (this.ec2SDConfigs == null) return (A)this;
    for (EC2SDConfig item : items) {EC2SDConfigBuilder builder = new EC2SDConfigBuilder(item);_visitables.get("ec2SDConfigs").remove(builder); this.ec2SDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEc2SDConfigs(Predicate<EC2SDConfigBuilder> predicate) {
    if (ec2SDConfigs == null) return (A) this;
    final Iterator<EC2SDConfigBuilder> each = ec2SDConfigs.iterator();
    final List visitables = _visitables.get("ec2SDConfigs");
    while (each.hasNext()) {
      EC2SDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EC2SDConfig> buildEc2SDConfigs() {
    return this.ec2SDConfigs != null ? build(ec2SDConfigs) : null;
  }
  
  public EC2SDConfig buildEc2SDConfig(int index) {
    return this.ec2SDConfigs.get(index).build();
  }
  
  public EC2SDConfig buildFirstEc2SDConfig() {
    return this.ec2SDConfigs.get(0).build();
  }
  
  public EC2SDConfig buildLastEc2SDConfig() {
    return this.ec2SDConfigs.get(ec2SDConfigs.size() - 1).build();
  }
  
  public EC2SDConfig buildMatchingEc2SDConfig(Predicate<EC2SDConfigBuilder> predicate) {
      for (EC2SDConfigBuilder item : ec2SDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEc2SDConfig(Predicate<EC2SDConfigBuilder> predicate) {
      for (EC2SDConfigBuilder item : ec2SDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEc2SDConfigs(List<EC2SDConfig> ec2SDConfigs) {
    if (this.ec2SDConfigs != null) {
      this._visitables.get("ec2SDConfigs").clear();
    }
    if (ec2SDConfigs != null) {
        this.ec2SDConfigs = new ArrayList();
        for (EC2SDConfig item : ec2SDConfigs) {
          this.addToEc2SDConfigs(item);
        }
    } else {
      this.ec2SDConfigs = null;
    }
    return (A) this;
  }
  
  public A withEc2SDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EC2SDConfig... ec2SDConfigs) {
    if (this.ec2SDConfigs != null) {
        this.ec2SDConfigs.clear();
        _visitables.remove("ec2SDConfigs");
    }
    if (ec2SDConfigs != null) {
      for (EC2SDConfig item : ec2SDConfigs) {
        this.addToEc2SDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEc2SDConfigs() {
    return this.ec2SDConfigs != null && !this.ec2SDConfigs.isEmpty();
  }
  
  public Ec2SDConfigsNested<A> addNewEc2SDConfig() {
    return new Ec2SDConfigsNested(-1, null);
  }
  
  public Ec2SDConfigsNested<A> addNewEc2SDConfigLike(EC2SDConfig item) {
    return new Ec2SDConfigsNested(-1, item);
  }
  
  public Ec2SDConfigsNested<A> setNewEc2SDConfigLike(int index,EC2SDConfig item) {
    return new Ec2SDConfigsNested(index, item);
  }
  
  public Ec2SDConfigsNested<A> editEc2SDConfig(int index) {
    if (ec2SDConfigs.size() <= index) throw new RuntimeException("Can't edit ec2SDConfigs. Index exceeds size.");
    return setNewEc2SDConfigLike(index, buildEc2SDConfig(index));
  }
  
  public Ec2SDConfigsNested<A> editFirstEc2SDConfig() {
    if (ec2SDConfigs.size() == 0) throw new RuntimeException("Can't edit first ec2SDConfigs. The list is empty.");
    return setNewEc2SDConfigLike(0, buildEc2SDConfig(0));
  }
  
  public Ec2SDConfigsNested<A> editLastEc2SDConfig() {
    int index = ec2SDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ec2SDConfigs. The list is empty.");
    return setNewEc2SDConfigLike(index, buildEc2SDConfig(index));
  }
  
  public Ec2SDConfigsNested<A> editMatchingEc2SDConfig(Predicate<EC2SDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ec2SDConfigs.size();i++) { 
    if (predicate.test(ec2SDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ec2SDConfigs. No match found.");
    return setNewEc2SDConfigLike(index, buildEc2SDConfig(index));
  }
  
  public Boolean getEnableCompression() {
    return this.enableCompression;
  }
  
  public A withEnableCompression(Boolean enableCompression) {
    this.enableCompression = enableCompression;
    return (A) this;
  }
  
  public boolean hasEnableCompression() {
    return this.enableCompression != null;
  }
  
  public Boolean getEnableHTTP2() {
    return this.enableHTTP2;
  }
  
  public A withEnableHTTP2(Boolean enableHTTP2) {
    this.enableHTTP2 = enableHTTP2;
    return (A) this;
  }
  
  public boolean hasEnableHTTP2() {
    return this.enableHTTP2 != null;
  }
  
  public A addToEurekaSDConfigs(int index,EurekaSDConfig item) {
    if (this.eurekaSDConfigs == null) {this.eurekaSDConfigs = new ArrayList<EurekaSDConfigBuilder>();}
    EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);
    if (index < 0 || index >= eurekaSDConfigs.size()) { _visitables.get("eurekaSDConfigs").add(builder); eurekaSDConfigs.add(builder); } else { _visitables.get("eurekaSDConfigs").add(index, builder); eurekaSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToEurekaSDConfigs(int index,EurekaSDConfig item) {
    if (this.eurekaSDConfigs == null) {this.eurekaSDConfigs = new ArrayList<EurekaSDConfigBuilder>();}
    EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);
    if (index < 0 || index >= eurekaSDConfigs.size()) { _visitables.get("eurekaSDConfigs").add(builder); eurekaSDConfigs.add(builder); } else { _visitables.get("eurekaSDConfigs").set(index, builder); eurekaSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToEurekaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EurekaSDConfig... items) {
    if (this.eurekaSDConfigs == null) {this.eurekaSDConfigs = new ArrayList<EurekaSDConfigBuilder>();}
    for (EurekaSDConfig item : items) {EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);_visitables.get("eurekaSDConfigs").add(builder);this.eurekaSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToEurekaSDConfigs(Collection<EurekaSDConfig> items) {
    if (this.eurekaSDConfigs == null) {this.eurekaSDConfigs = new ArrayList<EurekaSDConfigBuilder>();}
    for (EurekaSDConfig item : items) {EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);_visitables.get("eurekaSDConfigs").add(builder);this.eurekaSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromEurekaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EurekaSDConfig... items) {
    if (this.eurekaSDConfigs == null) return (A)this;
    for (EurekaSDConfig item : items) {EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);_visitables.get("eurekaSDConfigs").remove(builder); this.eurekaSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEurekaSDConfigs(Collection<EurekaSDConfig> items) {
    if (this.eurekaSDConfigs == null) return (A)this;
    for (EurekaSDConfig item : items) {EurekaSDConfigBuilder builder = new EurekaSDConfigBuilder(item);_visitables.get("eurekaSDConfigs").remove(builder); this.eurekaSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEurekaSDConfigs(Predicate<EurekaSDConfigBuilder> predicate) {
    if (eurekaSDConfigs == null) return (A) this;
    final Iterator<EurekaSDConfigBuilder> each = eurekaSDConfigs.iterator();
    final List visitables = _visitables.get("eurekaSDConfigs");
    while (each.hasNext()) {
      EurekaSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EurekaSDConfig> buildEurekaSDConfigs() {
    return this.eurekaSDConfigs != null ? build(eurekaSDConfigs) : null;
  }
  
  public EurekaSDConfig buildEurekaSDConfig(int index) {
    return this.eurekaSDConfigs.get(index).build();
  }
  
  public EurekaSDConfig buildFirstEurekaSDConfig() {
    return this.eurekaSDConfigs.get(0).build();
  }
  
  public EurekaSDConfig buildLastEurekaSDConfig() {
    return this.eurekaSDConfigs.get(eurekaSDConfigs.size() - 1).build();
  }
  
  public EurekaSDConfig buildMatchingEurekaSDConfig(Predicate<EurekaSDConfigBuilder> predicate) {
      for (EurekaSDConfigBuilder item : eurekaSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEurekaSDConfig(Predicate<EurekaSDConfigBuilder> predicate) {
      for (EurekaSDConfigBuilder item : eurekaSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEurekaSDConfigs(List<EurekaSDConfig> eurekaSDConfigs) {
    if (this.eurekaSDConfigs != null) {
      this._visitables.get("eurekaSDConfigs").clear();
    }
    if (eurekaSDConfigs != null) {
        this.eurekaSDConfigs = new ArrayList();
        for (EurekaSDConfig item : eurekaSDConfigs) {
          this.addToEurekaSDConfigs(item);
        }
    } else {
      this.eurekaSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withEurekaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.EurekaSDConfig... eurekaSDConfigs) {
    if (this.eurekaSDConfigs != null) {
        this.eurekaSDConfigs.clear();
        _visitables.remove("eurekaSDConfigs");
    }
    if (eurekaSDConfigs != null) {
      for (EurekaSDConfig item : eurekaSDConfigs) {
        this.addToEurekaSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEurekaSDConfigs() {
    return this.eurekaSDConfigs != null && !this.eurekaSDConfigs.isEmpty();
  }
  
  public EurekaSDConfigsNested<A> addNewEurekaSDConfig() {
    return new EurekaSDConfigsNested(-1, null);
  }
  
  public EurekaSDConfigsNested<A> addNewEurekaSDConfigLike(EurekaSDConfig item) {
    return new EurekaSDConfigsNested(-1, item);
  }
  
  public EurekaSDConfigsNested<A> setNewEurekaSDConfigLike(int index,EurekaSDConfig item) {
    return new EurekaSDConfigsNested(index, item);
  }
  
  public EurekaSDConfigsNested<A> editEurekaSDConfig(int index) {
    if (eurekaSDConfigs.size() <= index) throw new RuntimeException("Can't edit eurekaSDConfigs. Index exceeds size.");
    return setNewEurekaSDConfigLike(index, buildEurekaSDConfig(index));
  }
  
  public EurekaSDConfigsNested<A> editFirstEurekaSDConfig() {
    if (eurekaSDConfigs.size() == 0) throw new RuntimeException("Can't edit first eurekaSDConfigs. The list is empty.");
    return setNewEurekaSDConfigLike(0, buildEurekaSDConfig(0));
  }
  
  public EurekaSDConfigsNested<A> editLastEurekaSDConfig() {
    int index = eurekaSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last eurekaSDConfigs. The list is empty.");
    return setNewEurekaSDConfigLike(index, buildEurekaSDConfig(index));
  }
  
  public EurekaSDConfigsNested<A> editMatchingEurekaSDConfig(Predicate<EurekaSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<eurekaSDConfigs.size();i++) { 
    if (predicate.test(eurekaSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching eurekaSDConfigs. No match found.");
    return setNewEurekaSDConfigLike(index, buildEurekaSDConfig(index));
  }
  
  public String getFallbackScrapeProtocol() {
    return this.fallbackScrapeProtocol;
  }
  
  public A withFallbackScrapeProtocol(String fallbackScrapeProtocol) {
    this.fallbackScrapeProtocol = fallbackScrapeProtocol;
    return (A) this;
  }
  
  public boolean hasFallbackScrapeProtocol() {
    return this.fallbackScrapeProtocol != null;
  }
  
  public A addToFileSDConfigs(int index,FileSDConfig item) {
    if (this.fileSDConfigs == null) {this.fileSDConfigs = new ArrayList<FileSDConfigBuilder>();}
    FileSDConfigBuilder builder = new FileSDConfigBuilder(item);
    if (index < 0 || index >= fileSDConfigs.size()) { _visitables.get("fileSDConfigs").add(builder); fileSDConfigs.add(builder); } else { _visitables.get("fileSDConfigs").add(index, builder); fileSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToFileSDConfigs(int index,FileSDConfig item) {
    if (this.fileSDConfigs == null) {this.fileSDConfigs = new ArrayList<FileSDConfigBuilder>();}
    FileSDConfigBuilder builder = new FileSDConfigBuilder(item);
    if (index < 0 || index >= fileSDConfigs.size()) { _visitables.get("fileSDConfigs").add(builder); fileSDConfigs.add(builder); } else { _visitables.get("fileSDConfigs").set(index, builder); fileSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToFileSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.FileSDConfig... items) {
    if (this.fileSDConfigs == null) {this.fileSDConfigs = new ArrayList<FileSDConfigBuilder>();}
    for (FileSDConfig item : items) {FileSDConfigBuilder builder = new FileSDConfigBuilder(item);_visitables.get("fileSDConfigs").add(builder);this.fileSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToFileSDConfigs(Collection<FileSDConfig> items) {
    if (this.fileSDConfigs == null) {this.fileSDConfigs = new ArrayList<FileSDConfigBuilder>();}
    for (FileSDConfig item : items) {FileSDConfigBuilder builder = new FileSDConfigBuilder(item);_visitables.get("fileSDConfigs").add(builder);this.fileSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromFileSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.FileSDConfig... items) {
    if (this.fileSDConfigs == null) return (A)this;
    for (FileSDConfig item : items) {FileSDConfigBuilder builder = new FileSDConfigBuilder(item);_visitables.get("fileSDConfigs").remove(builder); this.fileSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFileSDConfigs(Collection<FileSDConfig> items) {
    if (this.fileSDConfigs == null) return (A)this;
    for (FileSDConfig item : items) {FileSDConfigBuilder builder = new FileSDConfigBuilder(item);_visitables.get("fileSDConfigs").remove(builder); this.fileSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFileSDConfigs(Predicate<FileSDConfigBuilder> predicate) {
    if (fileSDConfigs == null) return (A) this;
    final Iterator<FileSDConfigBuilder> each = fileSDConfigs.iterator();
    final List visitables = _visitables.get("fileSDConfigs");
    while (each.hasNext()) {
      FileSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FileSDConfig> buildFileSDConfigs() {
    return this.fileSDConfigs != null ? build(fileSDConfigs) : null;
  }
  
  public FileSDConfig buildFileSDConfig(int index) {
    return this.fileSDConfigs.get(index).build();
  }
  
  public FileSDConfig buildFirstFileSDConfig() {
    return this.fileSDConfigs.get(0).build();
  }
  
  public FileSDConfig buildLastFileSDConfig() {
    return this.fileSDConfigs.get(fileSDConfigs.size() - 1).build();
  }
  
  public FileSDConfig buildMatchingFileSDConfig(Predicate<FileSDConfigBuilder> predicate) {
      for (FileSDConfigBuilder item : fileSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFileSDConfig(Predicate<FileSDConfigBuilder> predicate) {
      for (FileSDConfigBuilder item : fileSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFileSDConfigs(List<FileSDConfig> fileSDConfigs) {
    if (this.fileSDConfigs != null) {
      this._visitables.get("fileSDConfigs").clear();
    }
    if (fileSDConfigs != null) {
        this.fileSDConfigs = new ArrayList();
        for (FileSDConfig item : fileSDConfigs) {
          this.addToFileSDConfigs(item);
        }
    } else {
      this.fileSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withFileSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.FileSDConfig... fileSDConfigs) {
    if (this.fileSDConfigs != null) {
        this.fileSDConfigs.clear();
        _visitables.remove("fileSDConfigs");
    }
    if (fileSDConfigs != null) {
      for (FileSDConfig item : fileSDConfigs) {
        this.addToFileSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFileSDConfigs() {
    return this.fileSDConfigs != null && !this.fileSDConfigs.isEmpty();
  }
  
  public FileSDConfigsNested<A> addNewFileSDConfig() {
    return new FileSDConfigsNested(-1, null);
  }
  
  public FileSDConfigsNested<A> addNewFileSDConfigLike(FileSDConfig item) {
    return new FileSDConfigsNested(-1, item);
  }
  
  public FileSDConfigsNested<A> setNewFileSDConfigLike(int index,FileSDConfig item) {
    return new FileSDConfigsNested(index, item);
  }
  
  public FileSDConfigsNested<A> editFileSDConfig(int index) {
    if (fileSDConfigs.size() <= index) throw new RuntimeException("Can't edit fileSDConfigs. Index exceeds size.");
    return setNewFileSDConfigLike(index, buildFileSDConfig(index));
  }
  
  public FileSDConfigsNested<A> editFirstFileSDConfig() {
    if (fileSDConfigs.size() == 0) throw new RuntimeException("Can't edit first fileSDConfigs. The list is empty.");
    return setNewFileSDConfigLike(0, buildFileSDConfig(0));
  }
  
  public FileSDConfigsNested<A> editLastFileSDConfig() {
    int index = fileSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fileSDConfigs. The list is empty.");
    return setNewFileSDConfigLike(index, buildFileSDConfig(index));
  }
  
  public FileSDConfigsNested<A> editMatchingFileSDConfig(Predicate<FileSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fileSDConfigs.size();i++) { 
    if (predicate.test(fileSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fileSDConfigs. No match found.");
    return setNewFileSDConfigLike(index, buildFileSDConfig(index));
  }
  
  public A addToGceSDConfigs(int index,GCESDConfig item) {
    if (this.gceSDConfigs == null) {this.gceSDConfigs = new ArrayList<GCESDConfigBuilder>();}
    GCESDConfigBuilder builder = new GCESDConfigBuilder(item);
    if (index < 0 || index >= gceSDConfigs.size()) { _visitables.get("gceSDConfigs").add(builder); gceSDConfigs.add(builder); } else { _visitables.get("gceSDConfigs").add(index, builder); gceSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToGceSDConfigs(int index,GCESDConfig item) {
    if (this.gceSDConfigs == null) {this.gceSDConfigs = new ArrayList<GCESDConfigBuilder>();}
    GCESDConfigBuilder builder = new GCESDConfigBuilder(item);
    if (index < 0 || index >= gceSDConfigs.size()) { _visitables.get("gceSDConfigs").add(builder); gceSDConfigs.add(builder); } else { _visitables.get("gceSDConfigs").set(index, builder); gceSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToGceSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.GCESDConfig... items) {
    if (this.gceSDConfigs == null) {this.gceSDConfigs = new ArrayList<GCESDConfigBuilder>();}
    for (GCESDConfig item : items) {GCESDConfigBuilder builder = new GCESDConfigBuilder(item);_visitables.get("gceSDConfigs").add(builder);this.gceSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToGceSDConfigs(Collection<GCESDConfig> items) {
    if (this.gceSDConfigs == null) {this.gceSDConfigs = new ArrayList<GCESDConfigBuilder>();}
    for (GCESDConfig item : items) {GCESDConfigBuilder builder = new GCESDConfigBuilder(item);_visitables.get("gceSDConfigs").add(builder);this.gceSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromGceSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.GCESDConfig... items) {
    if (this.gceSDConfigs == null) return (A)this;
    for (GCESDConfig item : items) {GCESDConfigBuilder builder = new GCESDConfigBuilder(item);_visitables.get("gceSDConfigs").remove(builder); this.gceSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGceSDConfigs(Collection<GCESDConfig> items) {
    if (this.gceSDConfigs == null) return (A)this;
    for (GCESDConfig item : items) {GCESDConfigBuilder builder = new GCESDConfigBuilder(item);_visitables.get("gceSDConfigs").remove(builder); this.gceSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGceSDConfigs(Predicate<GCESDConfigBuilder> predicate) {
    if (gceSDConfigs == null) return (A) this;
    final Iterator<GCESDConfigBuilder> each = gceSDConfigs.iterator();
    final List visitables = _visitables.get("gceSDConfigs");
    while (each.hasNext()) {
      GCESDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCESDConfig> buildGceSDConfigs() {
    return this.gceSDConfigs != null ? build(gceSDConfigs) : null;
  }
  
  public GCESDConfig buildGceSDConfig(int index) {
    return this.gceSDConfigs.get(index).build();
  }
  
  public GCESDConfig buildFirstGceSDConfig() {
    return this.gceSDConfigs.get(0).build();
  }
  
  public GCESDConfig buildLastGceSDConfig() {
    return this.gceSDConfigs.get(gceSDConfigs.size() - 1).build();
  }
  
  public GCESDConfig buildMatchingGceSDConfig(Predicate<GCESDConfigBuilder> predicate) {
      for (GCESDConfigBuilder item : gceSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGceSDConfig(Predicate<GCESDConfigBuilder> predicate) {
      for (GCESDConfigBuilder item : gceSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGceSDConfigs(List<GCESDConfig> gceSDConfigs) {
    if (this.gceSDConfigs != null) {
      this._visitables.get("gceSDConfigs").clear();
    }
    if (gceSDConfigs != null) {
        this.gceSDConfigs = new ArrayList();
        for (GCESDConfig item : gceSDConfigs) {
          this.addToGceSDConfigs(item);
        }
    } else {
      this.gceSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withGceSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.GCESDConfig... gceSDConfigs) {
    if (this.gceSDConfigs != null) {
        this.gceSDConfigs.clear();
        _visitables.remove("gceSDConfigs");
    }
    if (gceSDConfigs != null) {
      for (GCESDConfig item : gceSDConfigs) {
        this.addToGceSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGceSDConfigs() {
    return this.gceSDConfigs != null && !this.gceSDConfigs.isEmpty();
  }
  
  public GceSDConfigsNested<A> addNewGceSDConfig() {
    return new GceSDConfigsNested(-1, null);
  }
  
  public GceSDConfigsNested<A> addNewGceSDConfigLike(GCESDConfig item) {
    return new GceSDConfigsNested(-1, item);
  }
  
  public GceSDConfigsNested<A> setNewGceSDConfigLike(int index,GCESDConfig item) {
    return new GceSDConfigsNested(index, item);
  }
  
  public GceSDConfigsNested<A> editGceSDConfig(int index) {
    if (gceSDConfigs.size() <= index) throw new RuntimeException("Can't edit gceSDConfigs. Index exceeds size.");
    return setNewGceSDConfigLike(index, buildGceSDConfig(index));
  }
  
  public GceSDConfigsNested<A> editFirstGceSDConfig() {
    if (gceSDConfigs.size() == 0) throw new RuntimeException("Can't edit first gceSDConfigs. The list is empty.");
    return setNewGceSDConfigLike(0, buildGceSDConfig(0));
  }
  
  public GceSDConfigsNested<A> editLastGceSDConfig() {
    int index = gceSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gceSDConfigs. The list is empty.");
    return setNewGceSDConfigLike(index, buildGceSDConfig(index));
  }
  
  public GceSDConfigsNested<A> editMatchingGceSDConfig(Predicate<GCESDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gceSDConfigs.size();i++) { 
    if (predicate.test(gceSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gceSDConfigs. No match found.");
    return setNewGceSDConfigLike(index, buildGceSDConfig(index));
  }
  
  public A addToHetznerSDConfigs(int index,HetznerSDConfig item) {
    if (this.hetznerSDConfigs == null) {this.hetznerSDConfigs = new ArrayList<HetznerSDConfigBuilder>();}
    HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);
    if (index < 0 || index >= hetznerSDConfigs.size()) { _visitables.get("hetznerSDConfigs").add(builder); hetznerSDConfigs.add(builder); } else { _visitables.get("hetznerSDConfigs").add(index, builder); hetznerSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToHetznerSDConfigs(int index,HetznerSDConfig item) {
    if (this.hetznerSDConfigs == null) {this.hetznerSDConfigs = new ArrayList<HetznerSDConfigBuilder>();}
    HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);
    if (index < 0 || index >= hetznerSDConfigs.size()) { _visitables.get("hetznerSDConfigs").add(builder); hetznerSDConfigs.add(builder); } else { _visitables.get("hetznerSDConfigs").set(index, builder); hetznerSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToHetznerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HetznerSDConfig... items) {
    if (this.hetznerSDConfigs == null) {this.hetznerSDConfigs = new ArrayList<HetznerSDConfigBuilder>();}
    for (HetznerSDConfig item : items) {HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);_visitables.get("hetznerSDConfigs").add(builder);this.hetznerSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToHetznerSDConfigs(Collection<HetznerSDConfig> items) {
    if (this.hetznerSDConfigs == null) {this.hetznerSDConfigs = new ArrayList<HetznerSDConfigBuilder>();}
    for (HetznerSDConfig item : items) {HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);_visitables.get("hetznerSDConfigs").add(builder);this.hetznerSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromHetznerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HetznerSDConfig... items) {
    if (this.hetznerSDConfigs == null) return (A)this;
    for (HetznerSDConfig item : items) {HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);_visitables.get("hetznerSDConfigs").remove(builder); this.hetznerSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHetznerSDConfigs(Collection<HetznerSDConfig> items) {
    if (this.hetznerSDConfigs == null) return (A)this;
    for (HetznerSDConfig item : items) {HetznerSDConfigBuilder builder = new HetznerSDConfigBuilder(item);_visitables.get("hetznerSDConfigs").remove(builder); this.hetznerSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHetznerSDConfigs(Predicate<HetznerSDConfigBuilder> predicate) {
    if (hetznerSDConfigs == null) return (A) this;
    final Iterator<HetznerSDConfigBuilder> each = hetznerSDConfigs.iterator();
    final List visitables = _visitables.get("hetznerSDConfigs");
    while (each.hasNext()) {
      HetznerSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HetznerSDConfig> buildHetznerSDConfigs() {
    return this.hetznerSDConfigs != null ? build(hetznerSDConfigs) : null;
  }
  
  public HetznerSDConfig buildHetznerSDConfig(int index) {
    return this.hetznerSDConfigs.get(index).build();
  }
  
  public HetznerSDConfig buildFirstHetznerSDConfig() {
    return this.hetznerSDConfigs.get(0).build();
  }
  
  public HetznerSDConfig buildLastHetznerSDConfig() {
    return this.hetznerSDConfigs.get(hetznerSDConfigs.size() - 1).build();
  }
  
  public HetznerSDConfig buildMatchingHetznerSDConfig(Predicate<HetznerSDConfigBuilder> predicate) {
      for (HetznerSDConfigBuilder item : hetznerSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHetznerSDConfig(Predicate<HetznerSDConfigBuilder> predicate) {
      for (HetznerSDConfigBuilder item : hetznerSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHetznerSDConfigs(List<HetznerSDConfig> hetznerSDConfigs) {
    if (this.hetznerSDConfigs != null) {
      this._visitables.get("hetznerSDConfigs").clear();
    }
    if (hetznerSDConfigs != null) {
        this.hetznerSDConfigs = new ArrayList();
        for (HetznerSDConfig item : hetznerSDConfigs) {
          this.addToHetznerSDConfigs(item);
        }
    } else {
      this.hetznerSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withHetznerSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HetznerSDConfig... hetznerSDConfigs) {
    if (this.hetznerSDConfigs != null) {
        this.hetznerSDConfigs.clear();
        _visitables.remove("hetznerSDConfigs");
    }
    if (hetznerSDConfigs != null) {
      for (HetznerSDConfig item : hetznerSDConfigs) {
        this.addToHetznerSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHetznerSDConfigs() {
    return this.hetznerSDConfigs != null && !this.hetznerSDConfigs.isEmpty();
  }
  
  public HetznerSDConfigsNested<A> addNewHetznerSDConfig() {
    return new HetznerSDConfigsNested(-1, null);
  }
  
  public HetznerSDConfigsNested<A> addNewHetznerSDConfigLike(HetznerSDConfig item) {
    return new HetznerSDConfigsNested(-1, item);
  }
  
  public HetznerSDConfigsNested<A> setNewHetznerSDConfigLike(int index,HetznerSDConfig item) {
    return new HetznerSDConfigsNested(index, item);
  }
  
  public HetznerSDConfigsNested<A> editHetznerSDConfig(int index) {
    if (hetznerSDConfigs.size() <= index) throw new RuntimeException("Can't edit hetznerSDConfigs. Index exceeds size.");
    return setNewHetznerSDConfigLike(index, buildHetznerSDConfig(index));
  }
  
  public HetznerSDConfigsNested<A> editFirstHetznerSDConfig() {
    if (hetznerSDConfigs.size() == 0) throw new RuntimeException("Can't edit first hetznerSDConfigs. The list is empty.");
    return setNewHetznerSDConfigLike(0, buildHetznerSDConfig(0));
  }
  
  public HetznerSDConfigsNested<A> editLastHetznerSDConfig() {
    int index = hetznerSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hetznerSDConfigs. The list is empty.");
    return setNewHetznerSDConfigLike(index, buildHetznerSDConfig(index));
  }
  
  public HetznerSDConfigsNested<A> editMatchingHetznerSDConfig(Predicate<HetznerSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hetznerSDConfigs.size();i++) { 
    if (predicate.test(hetznerSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hetznerSDConfigs. No match found.");
    return setNewHetznerSDConfigLike(index, buildHetznerSDConfig(index));
  }
  
  public Boolean getHonorLabels() {
    return this.honorLabels;
  }
  
  public A withHonorLabels(Boolean honorLabels) {
    this.honorLabels = honorLabels;
    return (A) this;
  }
  
  public boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  
  public Boolean getHonorTimestamps() {
    return this.honorTimestamps;
  }
  
  public A withHonorTimestamps(Boolean honorTimestamps) {
    this.honorTimestamps = honorTimestamps;
    return (A) this;
  }
  
  public boolean hasHonorTimestamps() {
    return this.honorTimestamps != null;
  }
  
  public A addToHttpSDConfigs(int index,HTTPSDConfig item) {
    if (this.httpSDConfigs == null) {this.httpSDConfigs = new ArrayList<HTTPSDConfigBuilder>();}
    HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);
    if (index < 0 || index >= httpSDConfigs.size()) { _visitables.get("httpSDConfigs").add(builder); httpSDConfigs.add(builder); } else { _visitables.get("httpSDConfigs").add(index, builder); httpSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToHttpSDConfigs(int index,HTTPSDConfig item) {
    if (this.httpSDConfigs == null) {this.httpSDConfigs = new ArrayList<HTTPSDConfigBuilder>();}
    HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);
    if (index < 0 || index >= httpSDConfigs.size()) { _visitables.get("httpSDConfigs").add(builder); httpSDConfigs.add(builder); } else { _visitables.get("httpSDConfigs").set(index, builder); httpSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToHttpSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPSDConfig... items) {
    if (this.httpSDConfigs == null) {this.httpSDConfigs = new ArrayList<HTTPSDConfigBuilder>();}
    for (HTTPSDConfig item : items) {HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);_visitables.get("httpSDConfigs").add(builder);this.httpSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToHttpSDConfigs(Collection<HTTPSDConfig> items) {
    if (this.httpSDConfigs == null) {this.httpSDConfigs = new ArrayList<HTTPSDConfigBuilder>();}
    for (HTTPSDConfig item : items) {HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);_visitables.get("httpSDConfigs").add(builder);this.httpSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromHttpSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPSDConfig... items) {
    if (this.httpSDConfigs == null) return (A)this;
    for (HTTPSDConfig item : items) {HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);_visitables.get("httpSDConfigs").remove(builder); this.httpSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHttpSDConfigs(Collection<HTTPSDConfig> items) {
    if (this.httpSDConfigs == null) return (A)this;
    for (HTTPSDConfig item : items) {HTTPSDConfigBuilder builder = new HTTPSDConfigBuilder(item);_visitables.get("httpSDConfigs").remove(builder); this.httpSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHttpSDConfigs(Predicate<HTTPSDConfigBuilder> predicate) {
    if (httpSDConfigs == null) return (A) this;
    final Iterator<HTTPSDConfigBuilder> each = httpSDConfigs.iterator();
    final List visitables = _visitables.get("httpSDConfigs");
    while (each.hasNext()) {
      HTTPSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPSDConfig> buildHttpSDConfigs() {
    return this.httpSDConfigs != null ? build(httpSDConfigs) : null;
  }
  
  public HTTPSDConfig buildHttpSDConfig(int index) {
    return this.httpSDConfigs.get(index).build();
  }
  
  public HTTPSDConfig buildFirstHttpSDConfig() {
    return this.httpSDConfigs.get(0).build();
  }
  
  public HTTPSDConfig buildLastHttpSDConfig() {
    return this.httpSDConfigs.get(httpSDConfigs.size() - 1).build();
  }
  
  public HTTPSDConfig buildMatchingHttpSDConfig(Predicate<HTTPSDConfigBuilder> predicate) {
      for (HTTPSDConfigBuilder item : httpSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHttpSDConfig(Predicate<HTTPSDConfigBuilder> predicate) {
      for (HTTPSDConfigBuilder item : httpSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHttpSDConfigs(List<HTTPSDConfig> httpSDConfigs) {
    if (this.httpSDConfigs != null) {
      this._visitables.get("httpSDConfigs").clear();
    }
    if (httpSDConfigs != null) {
        this.httpSDConfigs = new ArrayList();
        for (HTTPSDConfig item : httpSDConfigs) {
          this.addToHttpSDConfigs(item);
        }
    } else {
      this.httpSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withHttpSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPSDConfig... httpSDConfigs) {
    if (this.httpSDConfigs != null) {
        this.httpSDConfigs.clear();
        _visitables.remove("httpSDConfigs");
    }
    if (httpSDConfigs != null) {
      for (HTTPSDConfig item : httpSDConfigs) {
        this.addToHttpSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHttpSDConfigs() {
    return this.httpSDConfigs != null && !this.httpSDConfigs.isEmpty();
  }
  
  public HttpSDConfigsNested<A> addNewHttpSDConfig() {
    return new HttpSDConfigsNested(-1, null);
  }
  
  public HttpSDConfigsNested<A> addNewHttpSDConfigLike(HTTPSDConfig item) {
    return new HttpSDConfigsNested(-1, item);
  }
  
  public HttpSDConfigsNested<A> setNewHttpSDConfigLike(int index,HTTPSDConfig item) {
    return new HttpSDConfigsNested(index, item);
  }
  
  public HttpSDConfigsNested<A> editHttpSDConfig(int index) {
    if (httpSDConfigs.size() <= index) throw new RuntimeException("Can't edit httpSDConfigs. Index exceeds size.");
    return setNewHttpSDConfigLike(index, buildHttpSDConfig(index));
  }
  
  public HttpSDConfigsNested<A> editFirstHttpSDConfig() {
    if (httpSDConfigs.size() == 0) throw new RuntimeException("Can't edit first httpSDConfigs. The list is empty.");
    return setNewHttpSDConfigLike(0, buildHttpSDConfig(0));
  }
  
  public HttpSDConfigsNested<A> editLastHttpSDConfig() {
    int index = httpSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last httpSDConfigs. The list is empty.");
    return setNewHttpSDConfigLike(index, buildHttpSDConfig(index));
  }
  
  public HttpSDConfigsNested<A> editMatchingHttpSDConfig(Predicate<HTTPSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<httpSDConfigs.size();i++) { 
    if (predicate.test(httpSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching httpSDConfigs. No match found.");
    return setNewHttpSDConfigLike(index, buildHttpSDConfig(index));
  }
  
  public A addToIonosSDConfigs(int index,IonosSDConfig item) {
    if (this.ionosSDConfigs == null) {this.ionosSDConfigs = new ArrayList<IonosSDConfigBuilder>();}
    IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);
    if (index < 0 || index >= ionosSDConfigs.size()) { _visitables.get("ionosSDConfigs").add(builder); ionosSDConfigs.add(builder); } else { _visitables.get("ionosSDConfigs").add(index, builder); ionosSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToIonosSDConfigs(int index,IonosSDConfig item) {
    if (this.ionosSDConfigs == null) {this.ionosSDConfigs = new ArrayList<IonosSDConfigBuilder>();}
    IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);
    if (index < 0 || index >= ionosSDConfigs.size()) { _visitables.get("ionosSDConfigs").add(builder); ionosSDConfigs.add(builder); } else { _visitables.get("ionosSDConfigs").set(index, builder); ionosSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToIonosSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.IonosSDConfig... items) {
    if (this.ionosSDConfigs == null) {this.ionosSDConfigs = new ArrayList<IonosSDConfigBuilder>();}
    for (IonosSDConfig item : items) {IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);_visitables.get("ionosSDConfigs").add(builder);this.ionosSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToIonosSDConfigs(Collection<IonosSDConfig> items) {
    if (this.ionosSDConfigs == null) {this.ionosSDConfigs = new ArrayList<IonosSDConfigBuilder>();}
    for (IonosSDConfig item : items) {IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);_visitables.get("ionosSDConfigs").add(builder);this.ionosSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromIonosSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.IonosSDConfig... items) {
    if (this.ionosSDConfigs == null) return (A)this;
    for (IonosSDConfig item : items) {IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);_visitables.get("ionosSDConfigs").remove(builder); this.ionosSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIonosSDConfigs(Collection<IonosSDConfig> items) {
    if (this.ionosSDConfigs == null) return (A)this;
    for (IonosSDConfig item : items) {IonosSDConfigBuilder builder = new IonosSDConfigBuilder(item);_visitables.get("ionosSDConfigs").remove(builder); this.ionosSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIonosSDConfigs(Predicate<IonosSDConfigBuilder> predicate) {
    if (ionosSDConfigs == null) return (A) this;
    final Iterator<IonosSDConfigBuilder> each = ionosSDConfigs.iterator();
    final List visitables = _visitables.get("ionosSDConfigs");
    while (each.hasNext()) {
      IonosSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IonosSDConfig> buildIonosSDConfigs() {
    return this.ionosSDConfigs != null ? build(ionosSDConfigs) : null;
  }
  
  public IonosSDConfig buildIonosSDConfig(int index) {
    return this.ionosSDConfigs.get(index).build();
  }
  
  public IonosSDConfig buildFirstIonosSDConfig() {
    return this.ionosSDConfigs.get(0).build();
  }
  
  public IonosSDConfig buildLastIonosSDConfig() {
    return this.ionosSDConfigs.get(ionosSDConfigs.size() - 1).build();
  }
  
  public IonosSDConfig buildMatchingIonosSDConfig(Predicate<IonosSDConfigBuilder> predicate) {
      for (IonosSDConfigBuilder item : ionosSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIonosSDConfig(Predicate<IonosSDConfigBuilder> predicate) {
      for (IonosSDConfigBuilder item : ionosSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIonosSDConfigs(List<IonosSDConfig> ionosSDConfigs) {
    if (this.ionosSDConfigs != null) {
      this._visitables.get("ionosSDConfigs").clear();
    }
    if (ionosSDConfigs != null) {
        this.ionosSDConfigs = new ArrayList();
        for (IonosSDConfig item : ionosSDConfigs) {
          this.addToIonosSDConfigs(item);
        }
    } else {
      this.ionosSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withIonosSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.IonosSDConfig... ionosSDConfigs) {
    if (this.ionosSDConfigs != null) {
        this.ionosSDConfigs.clear();
        _visitables.remove("ionosSDConfigs");
    }
    if (ionosSDConfigs != null) {
      for (IonosSDConfig item : ionosSDConfigs) {
        this.addToIonosSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIonosSDConfigs() {
    return this.ionosSDConfigs != null && !this.ionosSDConfigs.isEmpty();
  }
  
  public IonosSDConfigsNested<A> addNewIonosSDConfig() {
    return new IonosSDConfigsNested(-1, null);
  }
  
  public IonosSDConfigsNested<A> addNewIonosSDConfigLike(IonosSDConfig item) {
    return new IonosSDConfigsNested(-1, item);
  }
  
  public IonosSDConfigsNested<A> setNewIonosSDConfigLike(int index,IonosSDConfig item) {
    return new IonosSDConfigsNested(index, item);
  }
  
  public IonosSDConfigsNested<A> editIonosSDConfig(int index) {
    if (ionosSDConfigs.size() <= index) throw new RuntimeException("Can't edit ionosSDConfigs. Index exceeds size.");
    return setNewIonosSDConfigLike(index, buildIonosSDConfig(index));
  }
  
  public IonosSDConfigsNested<A> editFirstIonosSDConfig() {
    if (ionosSDConfigs.size() == 0) throw new RuntimeException("Can't edit first ionosSDConfigs. The list is empty.");
    return setNewIonosSDConfigLike(0, buildIonosSDConfig(0));
  }
  
  public IonosSDConfigsNested<A> editLastIonosSDConfig() {
    int index = ionosSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ionosSDConfigs. The list is empty.");
    return setNewIonosSDConfigLike(index, buildIonosSDConfig(index));
  }
  
  public IonosSDConfigsNested<A> editMatchingIonosSDConfig(Predicate<IonosSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ionosSDConfigs.size();i++) { 
    if (predicate.test(ionosSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ionosSDConfigs. No match found.");
    return setNewIonosSDConfigLike(index, buildIonosSDConfig(index));
  }
  
  public String getJobName() {
    return this.jobName;
  }
  
  public A withJobName(String jobName) {
    this.jobName = jobName;
    return (A) this;
  }
  
  public boolean hasJobName() {
    return this.jobName != null;
  }
  
  public Long getKeepDroppedTargets() {
    return this.keepDroppedTargets;
  }
  
  public A withKeepDroppedTargets(Long keepDroppedTargets) {
    this.keepDroppedTargets = keepDroppedTargets;
    return (A) this;
  }
  
  public boolean hasKeepDroppedTargets() {
    return this.keepDroppedTargets != null;
  }
  
  public A addToKubernetesSDConfigs(int index,KubernetesSDConfig item) {
    if (this.kubernetesSDConfigs == null) {this.kubernetesSDConfigs = new ArrayList<KubernetesSDConfigBuilder>();}
    KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);
    if (index < 0 || index >= kubernetesSDConfigs.size()) { _visitables.get("kubernetesSDConfigs").add(builder); kubernetesSDConfigs.add(builder); } else { _visitables.get("kubernetesSDConfigs").add(index, builder); kubernetesSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToKubernetesSDConfigs(int index,KubernetesSDConfig item) {
    if (this.kubernetesSDConfigs == null) {this.kubernetesSDConfigs = new ArrayList<KubernetesSDConfigBuilder>();}
    KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);
    if (index < 0 || index >= kubernetesSDConfigs.size()) { _visitables.get("kubernetesSDConfigs").add(builder); kubernetesSDConfigs.add(builder); } else { _visitables.get("kubernetesSDConfigs").set(index, builder); kubernetesSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToKubernetesSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KubernetesSDConfig... items) {
    if (this.kubernetesSDConfigs == null) {this.kubernetesSDConfigs = new ArrayList<KubernetesSDConfigBuilder>();}
    for (KubernetesSDConfig item : items) {KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);_visitables.get("kubernetesSDConfigs").add(builder);this.kubernetesSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToKubernetesSDConfigs(Collection<KubernetesSDConfig> items) {
    if (this.kubernetesSDConfigs == null) {this.kubernetesSDConfigs = new ArrayList<KubernetesSDConfigBuilder>();}
    for (KubernetesSDConfig item : items) {KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);_visitables.get("kubernetesSDConfigs").add(builder);this.kubernetesSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromKubernetesSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KubernetesSDConfig... items) {
    if (this.kubernetesSDConfigs == null) return (A)this;
    for (KubernetesSDConfig item : items) {KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);_visitables.get("kubernetesSDConfigs").remove(builder); this.kubernetesSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromKubernetesSDConfigs(Collection<KubernetesSDConfig> items) {
    if (this.kubernetesSDConfigs == null) return (A)this;
    for (KubernetesSDConfig item : items) {KubernetesSDConfigBuilder builder = new KubernetesSDConfigBuilder(item);_visitables.get("kubernetesSDConfigs").remove(builder); this.kubernetesSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromKubernetesSDConfigs(Predicate<KubernetesSDConfigBuilder> predicate) {
    if (kubernetesSDConfigs == null) return (A) this;
    final Iterator<KubernetesSDConfigBuilder> each = kubernetesSDConfigs.iterator();
    final List visitables = _visitables.get("kubernetesSDConfigs");
    while (each.hasNext()) {
      KubernetesSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KubernetesSDConfig> buildKubernetesSDConfigs() {
    return this.kubernetesSDConfigs != null ? build(kubernetesSDConfigs) : null;
  }
  
  public KubernetesSDConfig buildKubernetesSDConfig(int index) {
    return this.kubernetesSDConfigs.get(index).build();
  }
  
  public KubernetesSDConfig buildFirstKubernetesSDConfig() {
    return this.kubernetesSDConfigs.get(0).build();
  }
  
  public KubernetesSDConfig buildLastKubernetesSDConfig() {
    return this.kubernetesSDConfigs.get(kubernetesSDConfigs.size() - 1).build();
  }
  
  public KubernetesSDConfig buildMatchingKubernetesSDConfig(Predicate<KubernetesSDConfigBuilder> predicate) {
      for (KubernetesSDConfigBuilder item : kubernetesSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingKubernetesSDConfig(Predicate<KubernetesSDConfigBuilder> predicate) {
      for (KubernetesSDConfigBuilder item : kubernetesSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withKubernetesSDConfigs(List<KubernetesSDConfig> kubernetesSDConfigs) {
    if (this.kubernetesSDConfigs != null) {
      this._visitables.get("kubernetesSDConfigs").clear();
    }
    if (kubernetesSDConfigs != null) {
        this.kubernetesSDConfigs = new ArrayList();
        for (KubernetesSDConfig item : kubernetesSDConfigs) {
          this.addToKubernetesSDConfigs(item);
        }
    } else {
      this.kubernetesSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withKubernetesSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KubernetesSDConfig... kubernetesSDConfigs) {
    if (this.kubernetesSDConfigs != null) {
        this.kubernetesSDConfigs.clear();
        _visitables.remove("kubernetesSDConfigs");
    }
    if (kubernetesSDConfigs != null) {
      for (KubernetesSDConfig item : kubernetesSDConfigs) {
        this.addToKubernetesSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasKubernetesSDConfigs() {
    return this.kubernetesSDConfigs != null && !this.kubernetesSDConfigs.isEmpty();
  }
  
  public KubernetesSDConfigsNested<A> addNewKubernetesSDConfig() {
    return new KubernetesSDConfigsNested(-1, null);
  }
  
  public KubernetesSDConfigsNested<A> addNewKubernetesSDConfigLike(KubernetesSDConfig item) {
    return new KubernetesSDConfigsNested(-1, item);
  }
  
  public KubernetesSDConfigsNested<A> setNewKubernetesSDConfigLike(int index,KubernetesSDConfig item) {
    return new KubernetesSDConfigsNested(index, item);
  }
  
  public KubernetesSDConfigsNested<A> editKubernetesSDConfig(int index) {
    if (kubernetesSDConfigs.size() <= index) throw new RuntimeException("Can't edit kubernetesSDConfigs. Index exceeds size.");
    return setNewKubernetesSDConfigLike(index, buildKubernetesSDConfig(index));
  }
  
  public KubernetesSDConfigsNested<A> editFirstKubernetesSDConfig() {
    if (kubernetesSDConfigs.size() == 0) throw new RuntimeException("Can't edit first kubernetesSDConfigs. The list is empty.");
    return setNewKubernetesSDConfigLike(0, buildKubernetesSDConfig(0));
  }
  
  public KubernetesSDConfigsNested<A> editLastKubernetesSDConfig() {
    int index = kubernetesSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kubernetesSDConfigs. The list is empty.");
    return setNewKubernetesSDConfigLike(index, buildKubernetesSDConfig(index));
  }
  
  public KubernetesSDConfigsNested<A> editMatchingKubernetesSDConfig(Predicate<KubernetesSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kubernetesSDConfigs.size();i++) { 
    if (predicate.test(kubernetesSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kubernetesSDConfigs. No match found.");
    return setNewKubernetesSDConfigLike(index, buildKubernetesSDConfig(index));
  }
  
  public A addToKumaSDConfigs(int index,KumaSDConfig item) {
    if (this.kumaSDConfigs == null) {this.kumaSDConfigs = new ArrayList<KumaSDConfigBuilder>();}
    KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);
    if (index < 0 || index >= kumaSDConfigs.size()) { _visitables.get("kumaSDConfigs").add(builder); kumaSDConfigs.add(builder); } else { _visitables.get("kumaSDConfigs").add(index, builder); kumaSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToKumaSDConfigs(int index,KumaSDConfig item) {
    if (this.kumaSDConfigs == null) {this.kumaSDConfigs = new ArrayList<KumaSDConfigBuilder>();}
    KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);
    if (index < 0 || index >= kumaSDConfigs.size()) { _visitables.get("kumaSDConfigs").add(builder); kumaSDConfigs.add(builder); } else { _visitables.get("kumaSDConfigs").set(index, builder); kumaSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToKumaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KumaSDConfig... items) {
    if (this.kumaSDConfigs == null) {this.kumaSDConfigs = new ArrayList<KumaSDConfigBuilder>();}
    for (KumaSDConfig item : items) {KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);_visitables.get("kumaSDConfigs").add(builder);this.kumaSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToKumaSDConfigs(Collection<KumaSDConfig> items) {
    if (this.kumaSDConfigs == null) {this.kumaSDConfigs = new ArrayList<KumaSDConfigBuilder>();}
    for (KumaSDConfig item : items) {KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);_visitables.get("kumaSDConfigs").add(builder);this.kumaSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromKumaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KumaSDConfig... items) {
    if (this.kumaSDConfigs == null) return (A)this;
    for (KumaSDConfig item : items) {KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);_visitables.get("kumaSDConfigs").remove(builder); this.kumaSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromKumaSDConfigs(Collection<KumaSDConfig> items) {
    if (this.kumaSDConfigs == null) return (A)this;
    for (KumaSDConfig item : items) {KumaSDConfigBuilder builder = new KumaSDConfigBuilder(item);_visitables.get("kumaSDConfigs").remove(builder); this.kumaSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromKumaSDConfigs(Predicate<KumaSDConfigBuilder> predicate) {
    if (kumaSDConfigs == null) return (A) this;
    final Iterator<KumaSDConfigBuilder> each = kumaSDConfigs.iterator();
    final List visitables = _visitables.get("kumaSDConfigs");
    while (each.hasNext()) {
      KumaSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KumaSDConfig> buildKumaSDConfigs() {
    return this.kumaSDConfigs != null ? build(kumaSDConfigs) : null;
  }
  
  public KumaSDConfig buildKumaSDConfig(int index) {
    return this.kumaSDConfigs.get(index).build();
  }
  
  public KumaSDConfig buildFirstKumaSDConfig() {
    return this.kumaSDConfigs.get(0).build();
  }
  
  public KumaSDConfig buildLastKumaSDConfig() {
    return this.kumaSDConfigs.get(kumaSDConfigs.size() - 1).build();
  }
  
  public KumaSDConfig buildMatchingKumaSDConfig(Predicate<KumaSDConfigBuilder> predicate) {
      for (KumaSDConfigBuilder item : kumaSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingKumaSDConfig(Predicate<KumaSDConfigBuilder> predicate) {
      for (KumaSDConfigBuilder item : kumaSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withKumaSDConfigs(List<KumaSDConfig> kumaSDConfigs) {
    if (this.kumaSDConfigs != null) {
      this._visitables.get("kumaSDConfigs").clear();
    }
    if (kumaSDConfigs != null) {
        this.kumaSDConfigs = new ArrayList();
        for (KumaSDConfig item : kumaSDConfigs) {
          this.addToKumaSDConfigs(item);
        }
    } else {
      this.kumaSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withKumaSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.KumaSDConfig... kumaSDConfigs) {
    if (this.kumaSDConfigs != null) {
        this.kumaSDConfigs.clear();
        _visitables.remove("kumaSDConfigs");
    }
    if (kumaSDConfigs != null) {
      for (KumaSDConfig item : kumaSDConfigs) {
        this.addToKumaSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasKumaSDConfigs() {
    return this.kumaSDConfigs != null && !this.kumaSDConfigs.isEmpty();
  }
  
  public KumaSDConfigsNested<A> addNewKumaSDConfig() {
    return new KumaSDConfigsNested(-1, null);
  }
  
  public KumaSDConfigsNested<A> addNewKumaSDConfigLike(KumaSDConfig item) {
    return new KumaSDConfigsNested(-1, item);
  }
  
  public KumaSDConfigsNested<A> setNewKumaSDConfigLike(int index,KumaSDConfig item) {
    return new KumaSDConfigsNested(index, item);
  }
  
  public KumaSDConfigsNested<A> editKumaSDConfig(int index) {
    if (kumaSDConfigs.size() <= index) throw new RuntimeException("Can't edit kumaSDConfigs. Index exceeds size.");
    return setNewKumaSDConfigLike(index, buildKumaSDConfig(index));
  }
  
  public KumaSDConfigsNested<A> editFirstKumaSDConfig() {
    if (kumaSDConfigs.size() == 0) throw new RuntimeException("Can't edit first kumaSDConfigs. The list is empty.");
    return setNewKumaSDConfigLike(0, buildKumaSDConfig(0));
  }
  
  public KumaSDConfigsNested<A> editLastKumaSDConfig() {
    int index = kumaSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kumaSDConfigs. The list is empty.");
    return setNewKumaSDConfigLike(index, buildKumaSDConfig(index));
  }
  
  public KumaSDConfigsNested<A> editMatchingKumaSDConfig(Predicate<KumaSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kumaSDConfigs.size();i++) { 
    if (predicate.test(kumaSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kumaSDConfigs. No match found.");
    return setNewKumaSDConfigLike(index, buildKumaSDConfig(index));
  }
  
  public Long getLabelLimit() {
    return this.labelLimit;
  }
  
  public A withLabelLimit(Long labelLimit) {
    this.labelLimit = labelLimit;
    return (A) this;
  }
  
  public boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  
  public Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  
  public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
    this.labelNameLengthLimit = labelNameLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  
  public Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  
  public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
    this.labelValueLengthLimit = labelValueLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  public A addToLightSailSDConfigs(int index,LightSailSDConfig item) {
    if (this.lightSailSDConfigs == null) {this.lightSailSDConfigs = new ArrayList<LightSailSDConfigBuilder>();}
    LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);
    if (index < 0 || index >= lightSailSDConfigs.size()) { _visitables.get("lightSailSDConfigs").add(builder); lightSailSDConfigs.add(builder); } else { _visitables.get("lightSailSDConfigs").add(index, builder); lightSailSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToLightSailSDConfigs(int index,LightSailSDConfig item) {
    if (this.lightSailSDConfigs == null) {this.lightSailSDConfigs = new ArrayList<LightSailSDConfigBuilder>();}
    LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);
    if (index < 0 || index >= lightSailSDConfigs.size()) { _visitables.get("lightSailSDConfigs").add(builder); lightSailSDConfigs.add(builder); } else { _visitables.get("lightSailSDConfigs").set(index, builder); lightSailSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToLightSailSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LightSailSDConfig... items) {
    if (this.lightSailSDConfigs == null) {this.lightSailSDConfigs = new ArrayList<LightSailSDConfigBuilder>();}
    for (LightSailSDConfig item : items) {LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);_visitables.get("lightSailSDConfigs").add(builder);this.lightSailSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToLightSailSDConfigs(Collection<LightSailSDConfig> items) {
    if (this.lightSailSDConfigs == null) {this.lightSailSDConfigs = new ArrayList<LightSailSDConfigBuilder>();}
    for (LightSailSDConfig item : items) {LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);_visitables.get("lightSailSDConfigs").add(builder);this.lightSailSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromLightSailSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LightSailSDConfig... items) {
    if (this.lightSailSDConfigs == null) return (A)this;
    for (LightSailSDConfig item : items) {LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);_visitables.get("lightSailSDConfigs").remove(builder); this.lightSailSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLightSailSDConfigs(Collection<LightSailSDConfig> items) {
    if (this.lightSailSDConfigs == null) return (A)this;
    for (LightSailSDConfig item : items) {LightSailSDConfigBuilder builder = new LightSailSDConfigBuilder(item);_visitables.get("lightSailSDConfigs").remove(builder); this.lightSailSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLightSailSDConfigs(Predicate<LightSailSDConfigBuilder> predicate) {
    if (lightSailSDConfigs == null) return (A) this;
    final Iterator<LightSailSDConfigBuilder> each = lightSailSDConfigs.iterator();
    final List visitables = _visitables.get("lightSailSDConfigs");
    while (each.hasNext()) {
      LightSailSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LightSailSDConfig> buildLightSailSDConfigs() {
    return this.lightSailSDConfigs != null ? build(lightSailSDConfigs) : null;
  }
  
  public LightSailSDConfig buildLightSailSDConfig(int index) {
    return this.lightSailSDConfigs.get(index).build();
  }
  
  public LightSailSDConfig buildFirstLightSailSDConfig() {
    return this.lightSailSDConfigs.get(0).build();
  }
  
  public LightSailSDConfig buildLastLightSailSDConfig() {
    return this.lightSailSDConfigs.get(lightSailSDConfigs.size() - 1).build();
  }
  
  public LightSailSDConfig buildMatchingLightSailSDConfig(Predicate<LightSailSDConfigBuilder> predicate) {
      for (LightSailSDConfigBuilder item : lightSailSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLightSailSDConfig(Predicate<LightSailSDConfigBuilder> predicate) {
      for (LightSailSDConfigBuilder item : lightSailSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLightSailSDConfigs(List<LightSailSDConfig> lightSailSDConfigs) {
    if (this.lightSailSDConfigs != null) {
      this._visitables.get("lightSailSDConfigs").clear();
    }
    if (lightSailSDConfigs != null) {
        this.lightSailSDConfigs = new ArrayList();
        for (LightSailSDConfig item : lightSailSDConfigs) {
          this.addToLightSailSDConfigs(item);
        }
    } else {
      this.lightSailSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withLightSailSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LightSailSDConfig... lightSailSDConfigs) {
    if (this.lightSailSDConfigs != null) {
        this.lightSailSDConfigs.clear();
        _visitables.remove("lightSailSDConfigs");
    }
    if (lightSailSDConfigs != null) {
      for (LightSailSDConfig item : lightSailSDConfigs) {
        this.addToLightSailSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLightSailSDConfigs() {
    return this.lightSailSDConfigs != null && !this.lightSailSDConfigs.isEmpty();
  }
  
  public LightSailSDConfigsNested<A> addNewLightSailSDConfig() {
    return new LightSailSDConfigsNested(-1, null);
  }
  
  public LightSailSDConfigsNested<A> addNewLightSailSDConfigLike(LightSailSDConfig item) {
    return new LightSailSDConfigsNested(-1, item);
  }
  
  public LightSailSDConfigsNested<A> setNewLightSailSDConfigLike(int index,LightSailSDConfig item) {
    return new LightSailSDConfigsNested(index, item);
  }
  
  public LightSailSDConfigsNested<A> editLightSailSDConfig(int index) {
    if (lightSailSDConfigs.size() <= index) throw new RuntimeException("Can't edit lightSailSDConfigs. Index exceeds size.");
    return setNewLightSailSDConfigLike(index, buildLightSailSDConfig(index));
  }
  
  public LightSailSDConfigsNested<A> editFirstLightSailSDConfig() {
    if (lightSailSDConfigs.size() == 0) throw new RuntimeException("Can't edit first lightSailSDConfigs. The list is empty.");
    return setNewLightSailSDConfigLike(0, buildLightSailSDConfig(0));
  }
  
  public LightSailSDConfigsNested<A> editLastLightSailSDConfig() {
    int index = lightSailSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last lightSailSDConfigs. The list is empty.");
    return setNewLightSailSDConfigLike(index, buildLightSailSDConfig(index));
  }
  
  public LightSailSDConfigsNested<A> editMatchingLightSailSDConfig(Predicate<LightSailSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<lightSailSDConfigs.size();i++) { 
    if (predicate.test(lightSailSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching lightSailSDConfigs. No match found.");
    return setNewLightSailSDConfigLike(index, buildLightSailSDConfig(index));
  }
  
  public A addToLinodeSDConfigs(int index,LinodeSDConfig item) {
    if (this.linodeSDConfigs == null) {this.linodeSDConfigs = new ArrayList<LinodeSDConfigBuilder>();}
    LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);
    if (index < 0 || index >= linodeSDConfigs.size()) { _visitables.get("linodeSDConfigs").add(builder); linodeSDConfigs.add(builder); } else { _visitables.get("linodeSDConfigs").add(index, builder); linodeSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToLinodeSDConfigs(int index,LinodeSDConfig item) {
    if (this.linodeSDConfigs == null) {this.linodeSDConfigs = new ArrayList<LinodeSDConfigBuilder>();}
    LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);
    if (index < 0 || index >= linodeSDConfigs.size()) { _visitables.get("linodeSDConfigs").add(builder); linodeSDConfigs.add(builder); } else { _visitables.get("linodeSDConfigs").set(index, builder); linodeSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToLinodeSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LinodeSDConfig... items) {
    if (this.linodeSDConfigs == null) {this.linodeSDConfigs = new ArrayList<LinodeSDConfigBuilder>();}
    for (LinodeSDConfig item : items) {LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);_visitables.get("linodeSDConfigs").add(builder);this.linodeSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToLinodeSDConfigs(Collection<LinodeSDConfig> items) {
    if (this.linodeSDConfigs == null) {this.linodeSDConfigs = new ArrayList<LinodeSDConfigBuilder>();}
    for (LinodeSDConfig item : items) {LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);_visitables.get("linodeSDConfigs").add(builder);this.linodeSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromLinodeSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LinodeSDConfig... items) {
    if (this.linodeSDConfigs == null) return (A)this;
    for (LinodeSDConfig item : items) {LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);_visitables.get("linodeSDConfigs").remove(builder); this.linodeSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLinodeSDConfigs(Collection<LinodeSDConfig> items) {
    if (this.linodeSDConfigs == null) return (A)this;
    for (LinodeSDConfig item : items) {LinodeSDConfigBuilder builder = new LinodeSDConfigBuilder(item);_visitables.get("linodeSDConfigs").remove(builder); this.linodeSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLinodeSDConfigs(Predicate<LinodeSDConfigBuilder> predicate) {
    if (linodeSDConfigs == null) return (A) this;
    final Iterator<LinodeSDConfigBuilder> each = linodeSDConfigs.iterator();
    final List visitables = _visitables.get("linodeSDConfigs");
    while (each.hasNext()) {
      LinodeSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LinodeSDConfig> buildLinodeSDConfigs() {
    return this.linodeSDConfigs != null ? build(linodeSDConfigs) : null;
  }
  
  public LinodeSDConfig buildLinodeSDConfig(int index) {
    return this.linodeSDConfigs.get(index).build();
  }
  
  public LinodeSDConfig buildFirstLinodeSDConfig() {
    return this.linodeSDConfigs.get(0).build();
  }
  
  public LinodeSDConfig buildLastLinodeSDConfig() {
    return this.linodeSDConfigs.get(linodeSDConfigs.size() - 1).build();
  }
  
  public LinodeSDConfig buildMatchingLinodeSDConfig(Predicate<LinodeSDConfigBuilder> predicate) {
      for (LinodeSDConfigBuilder item : linodeSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLinodeSDConfig(Predicate<LinodeSDConfigBuilder> predicate) {
      for (LinodeSDConfigBuilder item : linodeSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLinodeSDConfigs(List<LinodeSDConfig> linodeSDConfigs) {
    if (this.linodeSDConfigs != null) {
      this._visitables.get("linodeSDConfigs").clear();
    }
    if (linodeSDConfigs != null) {
        this.linodeSDConfigs = new ArrayList();
        for (LinodeSDConfig item : linodeSDConfigs) {
          this.addToLinodeSDConfigs(item);
        }
    } else {
      this.linodeSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withLinodeSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.LinodeSDConfig... linodeSDConfigs) {
    if (this.linodeSDConfigs != null) {
        this.linodeSDConfigs.clear();
        _visitables.remove("linodeSDConfigs");
    }
    if (linodeSDConfigs != null) {
      for (LinodeSDConfig item : linodeSDConfigs) {
        this.addToLinodeSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLinodeSDConfigs() {
    return this.linodeSDConfigs != null && !this.linodeSDConfigs.isEmpty();
  }
  
  public LinodeSDConfigsNested<A> addNewLinodeSDConfig() {
    return new LinodeSDConfigsNested(-1, null);
  }
  
  public LinodeSDConfigsNested<A> addNewLinodeSDConfigLike(LinodeSDConfig item) {
    return new LinodeSDConfigsNested(-1, item);
  }
  
  public LinodeSDConfigsNested<A> setNewLinodeSDConfigLike(int index,LinodeSDConfig item) {
    return new LinodeSDConfigsNested(index, item);
  }
  
  public LinodeSDConfigsNested<A> editLinodeSDConfig(int index) {
    if (linodeSDConfigs.size() <= index) throw new RuntimeException("Can't edit linodeSDConfigs. Index exceeds size.");
    return setNewLinodeSDConfigLike(index, buildLinodeSDConfig(index));
  }
  
  public LinodeSDConfigsNested<A> editFirstLinodeSDConfig() {
    if (linodeSDConfigs.size() == 0) throw new RuntimeException("Can't edit first linodeSDConfigs. The list is empty.");
    return setNewLinodeSDConfigLike(0, buildLinodeSDConfig(0));
  }
  
  public LinodeSDConfigsNested<A> editLastLinodeSDConfig() {
    int index = linodeSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last linodeSDConfigs. The list is empty.");
    return setNewLinodeSDConfigLike(index, buildLinodeSDConfig(index));
  }
  
  public LinodeSDConfigsNested<A> editMatchingLinodeSDConfig(Predicate<LinodeSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<linodeSDConfigs.size();i++) { 
    if (predicate.test(linodeSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching linodeSDConfigs. No match found.");
    return setNewLinodeSDConfigLike(index, buildLinodeSDConfig(index));
  }
  
  public A addToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").add(index, builder); metricRelabelings.add(index, builder);}
    return (A)this;
  }
  
  public A setToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").set(index, builder); metricRelabelings.set(index, builder);}
    return (A)this;
  }
  
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  
  public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildMetricRelabelings() {
    return this.metricRelabelings != null ? build(metricRelabelings) : null;
  }
  
  public RelabelConfig buildMetricRelabeling(int index) {
    return this.metricRelabelings.get(index).build();
  }
  
  public RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  
  public RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : metricRelabelings) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : metricRelabelings) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) {
      this._visitables.get("metricRelabelings").clear();
    }
    if (metricRelabelings != null) {
        this.metricRelabelings = new ArrayList();
        for (RelabelConfig item : metricRelabelings) {
          this.addToMetricRelabelings(item);
        }
    } else {
      this.metricRelabelings = null;
    }
    return (A) this;
  }
  
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {
        this.metricRelabelings.clear();
        _visitables.remove("metricRelabelings");
    }
    if (metricRelabelings != null) {
      for (RelabelConfig item : metricRelabelings) {
        this.addToMetricRelabelings(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMetricRelabelings() {
    return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
  }
  
  public MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new MetricRelabelingsNested(-1, null);
  }
  
  public MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
    return new MetricRelabelingsNested(-1, item);
  }
  
  public MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item) {
    return new MetricRelabelingsNested(index, item);
  }
  
  public MetricRelabelingsNested<A> editMetricRelabeling(int index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  
  public MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  public String getMetricsPath() {
    return this.metricsPath;
  }
  
  public A withMetricsPath(String metricsPath) {
    this.metricsPath = metricsPath;
    return (A) this;
  }
  
  public boolean hasMetricsPath() {
    return this.metricsPath != null;
  }
  
  public Long getNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit;
  }
  
  public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
    this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
    return (A) this;
  }
  
  public boolean hasNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit != null;
  }
  
  public Quantity getNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor;
  }
  
  public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
    this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
    return (A) this;
  }
  
  public boolean hasNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor != null;
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount,String format) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount, format));
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount));
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public A addToNomadSDConfigs(int index,NomadSDConfig item) {
    if (this.nomadSDConfigs == null) {this.nomadSDConfigs = new ArrayList<NomadSDConfigBuilder>();}
    NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);
    if (index < 0 || index >= nomadSDConfigs.size()) { _visitables.get("nomadSDConfigs").add(builder); nomadSDConfigs.add(builder); } else { _visitables.get("nomadSDConfigs").add(index, builder); nomadSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToNomadSDConfigs(int index,NomadSDConfig item) {
    if (this.nomadSDConfigs == null) {this.nomadSDConfigs = new ArrayList<NomadSDConfigBuilder>();}
    NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);
    if (index < 0 || index >= nomadSDConfigs.size()) { _visitables.get("nomadSDConfigs").add(builder); nomadSDConfigs.add(builder); } else { _visitables.get("nomadSDConfigs").set(index, builder); nomadSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToNomadSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.NomadSDConfig... items) {
    if (this.nomadSDConfigs == null) {this.nomadSDConfigs = new ArrayList<NomadSDConfigBuilder>();}
    for (NomadSDConfig item : items) {NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);_visitables.get("nomadSDConfigs").add(builder);this.nomadSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToNomadSDConfigs(Collection<NomadSDConfig> items) {
    if (this.nomadSDConfigs == null) {this.nomadSDConfigs = new ArrayList<NomadSDConfigBuilder>();}
    for (NomadSDConfig item : items) {NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);_visitables.get("nomadSDConfigs").add(builder);this.nomadSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromNomadSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.NomadSDConfig... items) {
    if (this.nomadSDConfigs == null) return (A)this;
    for (NomadSDConfig item : items) {NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);_visitables.get("nomadSDConfigs").remove(builder); this.nomadSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNomadSDConfigs(Collection<NomadSDConfig> items) {
    if (this.nomadSDConfigs == null) return (A)this;
    for (NomadSDConfig item : items) {NomadSDConfigBuilder builder = new NomadSDConfigBuilder(item);_visitables.get("nomadSDConfigs").remove(builder); this.nomadSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNomadSDConfigs(Predicate<NomadSDConfigBuilder> predicate) {
    if (nomadSDConfigs == null) return (A) this;
    final Iterator<NomadSDConfigBuilder> each = nomadSDConfigs.iterator();
    final List visitables = _visitables.get("nomadSDConfigs");
    while (each.hasNext()) {
      NomadSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NomadSDConfig> buildNomadSDConfigs() {
    return this.nomadSDConfigs != null ? build(nomadSDConfigs) : null;
  }
  
  public NomadSDConfig buildNomadSDConfig(int index) {
    return this.nomadSDConfigs.get(index).build();
  }
  
  public NomadSDConfig buildFirstNomadSDConfig() {
    return this.nomadSDConfigs.get(0).build();
  }
  
  public NomadSDConfig buildLastNomadSDConfig() {
    return this.nomadSDConfigs.get(nomadSDConfigs.size() - 1).build();
  }
  
  public NomadSDConfig buildMatchingNomadSDConfig(Predicate<NomadSDConfigBuilder> predicate) {
      for (NomadSDConfigBuilder item : nomadSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingNomadSDConfig(Predicate<NomadSDConfigBuilder> predicate) {
      for (NomadSDConfigBuilder item : nomadSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNomadSDConfigs(List<NomadSDConfig> nomadSDConfigs) {
    if (this.nomadSDConfigs != null) {
      this._visitables.get("nomadSDConfigs").clear();
    }
    if (nomadSDConfigs != null) {
        this.nomadSDConfigs = new ArrayList();
        for (NomadSDConfig item : nomadSDConfigs) {
          this.addToNomadSDConfigs(item);
        }
    } else {
      this.nomadSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withNomadSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.NomadSDConfig... nomadSDConfigs) {
    if (this.nomadSDConfigs != null) {
        this.nomadSDConfigs.clear();
        _visitables.remove("nomadSDConfigs");
    }
    if (nomadSDConfigs != null) {
      for (NomadSDConfig item : nomadSDConfigs) {
        this.addToNomadSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNomadSDConfigs() {
    return this.nomadSDConfigs != null && !this.nomadSDConfigs.isEmpty();
  }
  
  public NomadSDConfigsNested<A> addNewNomadSDConfig() {
    return new NomadSDConfigsNested(-1, null);
  }
  
  public NomadSDConfigsNested<A> addNewNomadSDConfigLike(NomadSDConfig item) {
    return new NomadSDConfigsNested(-1, item);
  }
  
  public NomadSDConfigsNested<A> setNewNomadSDConfigLike(int index,NomadSDConfig item) {
    return new NomadSDConfigsNested(index, item);
  }
  
  public NomadSDConfigsNested<A> editNomadSDConfig(int index) {
    if (nomadSDConfigs.size() <= index) throw new RuntimeException("Can't edit nomadSDConfigs. Index exceeds size.");
    return setNewNomadSDConfigLike(index, buildNomadSDConfig(index));
  }
  
  public NomadSDConfigsNested<A> editFirstNomadSDConfig() {
    if (nomadSDConfigs.size() == 0) throw new RuntimeException("Can't edit first nomadSDConfigs. The list is empty.");
    return setNewNomadSDConfigLike(0, buildNomadSDConfig(0));
  }
  
  public NomadSDConfigsNested<A> editLastNomadSDConfig() {
    int index = nomadSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nomadSDConfigs. The list is empty.");
    return setNewNomadSDConfigLike(index, buildNomadSDConfig(index));
  }
  
  public NomadSDConfigsNested<A> editMatchingNomadSDConfig(Predicate<NomadSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nomadSDConfigs.size();i++) { 
    if (predicate.test(nomadSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nomadSDConfigs. No match found.");
    return setNewNomadSDConfigLike(index, buildNomadSDConfig(index));
  }
  
  public OAuth2 buildOauth2() {
    return this.oauth2 != null ? this.oauth2.build() : null;
  }
  
  public A withOauth2(OAuth2 oauth2) {
    this._visitables.remove("oauth2");
    if (oauth2 != null) {
        this.oauth2 = new OAuth2Builder(oauth2);
        this._visitables.get("oauth2").add(this.oauth2);
    } else {
        this.oauth2 = null;
        this._visitables.get("oauth2").remove(this.oauth2);
    }
    return (A) this;
  }
  
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  
  public A addToOpenstackSDConfigs(int index,OpenStackSDConfig item) {
    if (this.openstackSDConfigs == null) {this.openstackSDConfigs = new ArrayList<OpenStackSDConfigBuilder>();}
    OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);
    if (index < 0 || index >= openstackSDConfigs.size()) { _visitables.get("openstackSDConfigs").add(builder); openstackSDConfigs.add(builder); } else { _visitables.get("openstackSDConfigs").add(index, builder); openstackSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToOpenstackSDConfigs(int index,OpenStackSDConfig item) {
    if (this.openstackSDConfigs == null) {this.openstackSDConfigs = new ArrayList<OpenStackSDConfigBuilder>();}
    OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);
    if (index < 0 || index >= openstackSDConfigs.size()) { _visitables.get("openstackSDConfigs").add(builder); openstackSDConfigs.add(builder); } else { _visitables.get("openstackSDConfigs").set(index, builder); openstackSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToOpenstackSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpenStackSDConfig... items) {
    if (this.openstackSDConfigs == null) {this.openstackSDConfigs = new ArrayList<OpenStackSDConfigBuilder>();}
    for (OpenStackSDConfig item : items) {OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);_visitables.get("openstackSDConfigs").add(builder);this.openstackSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToOpenstackSDConfigs(Collection<OpenStackSDConfig> items) {
    if (this.openstackSDConfigs == null) {this.openstackSDConfigs = new ArrayList<OpenStackSDConfigBuilder>();}
    for (OpenStackSDConfig item : items) {OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);_visitables.get("openstackSDConfigs").add(builder);this.openstackSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromOpenstackSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpenStackSDConfig... items) {
    if (this.openstackSDConfigs == null) return (A)this;
    for (OpenStackSDConfig item : items) {OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);_visitables.get("openstackSDConfigs").remove(builder); this.openstackSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOpenstackSDConfigs(Collection<OpenStackSDConfig> items) {
    if (this.openstackSDConfigs == null) return (A)this;
    for (OpenStackSDConfig item : items) {OpenStackSDConfigBuilder builder = new OpenStackSDConfigBuilder(item);_visitables.get("openstackSDConfigs").remove(builder); this.openstackSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOpenstackSDConfigs(Predicate<OpenStackSDConfigBuilder> predicate) {
    if (openstackSDConfigs == null) return (A) this;
    final Iterator<OpenStackSDConfigBuilder> each = openstackSDConfigs.iterator();
    final List visitables = _visitables.get("openstackSDConfigs");
    while (each.hasNext()) {
      OpenStackSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OpenStackSDConfig> buildOpenstackSDConfigs() {
    return this.openstackSDConfigs != null ? build(openstackSDConfigs) : null;
  }
  
  public OpenStackSDConfig buildOpenstackSDConfig(int index) {
    return this.openstackSDConfigs.get(index).build();
  }
  
  public OpenStackSDConfig buildFirstOpenstackSDConfig() {
    return this.openstackSDConfigs.get(0).build();
  }
  
  public OpenStackSDConfig buildLastOpenstackSDConfig() {
    return this.openstackSDConfigs.get(openstackSDConfigs.size() - 1).build();
  }
  
  public OpenStackSDConfig buildMatchingOpenstackSDConfig(Predicate<OpenStackSDConfigBuilder> predicate) {
      for (OpenStackSDConfigBuilder item : openstackSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOpenstackSDConfig(Predicate<OpenStackSDConfigBuilder> predicate) {
      for (OpenStackSDConfigBuilder item : openstackSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOpenstackSDConfigs(List<OpenStackSDConfig> openstackSDConfigs) {
    if (this.openstackSDConfigs != null) {
      this._visitables.get("openstackSDConfigs").clear();
    }
    if (openstackSDConfigs != null) {
        this.openstackSDConfigs = new ArrayList();
        for (OpenStackSDConfig item : openstackSDConfigs) {
          this.addToOpenstackSDConfigs(item);
        }
    } else {
      this.openstackSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withOpenstackSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpenStackSDConfig... openstackSDConfigs) {
    if (this.openstackSDConfigs != null) {
        this.openstackSDConfigs.clear();
        _visitables.remove("openstackSDConfigs");
    }
    if (openstackSDConfigs != null) {
      for (OpenStackSDConfig item : openstackSDConfigs) {
        this.addToOpenstackSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOpenstackSDConfigs() {
    return this.openstackSDConfigs != null && !this.openstackSDConfigs.isEmpty();
  }
  
  public OpenstackSDConfigsNested<A> addNewOpenstackSDConfig() {
    return new OpenstackSDConfigsNested(-1, null);
  }
  
  public OpenstackSDConfigsNested<A> addNewOpenstackSDConfigLike(OpenStackSDConfig item) {
    return new OpenstackSDConfigsNested(-1, item);
  }
  
  public OpenstackSDConfigsNested<A> setNewOpenstackSDConfigLike(int index,OpenStackSDConfig item) {
    return new OpenstackSDConfigsNested(index, item);
  }
  
  public OpenstackSDConfigsNested<A> editOpenstackSDConfig(int index) {
    if (openstackSDConfigs.size() <= index) throw new RuntimeException("Can't edit openstackSDConfigs. Index exceeds size.");
    return setNewOpenstackSDConfigLike(index, buildOpenstackSDConfig(index));
  }
  
  public OpenstackSDConfigsNested<A> editFirstOpenstackSDConfig() {
    if (openstackSDConfigs.size() == 0) throw new RuntimeException("Can't edit first openstackSDConfigs. The list is empty.");
    return setNewOpenstackSDConfigLike(0, buildOpenstackSDConfig(0));
  }
  
  public OpenstackSDConfigsNested<A> editLastOpenstackSDConfig() {
    int index = openstackSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last openstackSDConfigs. The list is empty.");
    return setNewOpenstackSDConfigLike(index, buildOpenstackSDConfig(index));
  }
  
  public OpenstackSDConfigsNested<A> editMatchingOpenstackSDConfig(Predicate<OpenStackSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<openstackSDConfigs.size();i++) { 
    if (predicate.test(openstackSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching openstackSDConfigs. No match found.");
    return setNewOpenstackSDConfigLike(index, buildOpenstackSDConfig(index));
  }
  
  public A addToOvhcloudSDConfigs(int index,OVHCloudSDConfig item) {
    if (this.ovhcloudSDConfigs == null) {this.ovhcloudSDConfigs = new ArrayList<OVHCloudSDConfigBuilder>();}
    OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);
    if (index < 0 || index >= ovhcloudSDConfigs.size()) { _visitables.get("ovhcloudSDConfigs").add(builder); ovhcloudSDConfigs.add(builder); } else { _visitables.get("ovhcloudSDConfigs").add(index, builder); ovhcloudSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToOvhcloudSDConfigs(int index,OVHCloudSDConfig item) {
    if (this.ovhcloudSDConfigs == null) {this.ovhcloudSDConfigs = new ArrayList<OVHCloudSDConfigBuilder>();}
    OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);
    if (index < 0 || index >= ovhcloudSDConfigs.size()) { _visitables.get("ovhcloudSDConfigs").add(builder); ovhcloudSDConfigs.add(builder); } else { _visitables.get("ovhcloudSDConfigs").set(index, builder); ovhcloudSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToOvhcloudSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OVHCloudSDConfig... items) {
    if (this.ovhcloudSDConfigs == null) {this.ovhcloudSDConfigs = new ArrayList<OVHCloudSDConfigBuilder>();}
    for (OVHCloudSDConfig item : items) {OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);_visitables.get("ovhcloudSDConfigs").add(builder);this.ovhcloudSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToOvhcloudSDConfigs(Collection<OVHCloudSDConfig> items) {
    if (this.ovhcloudSDConfigs == null) {this.ovhcloudSDConfigs = new ArrayList<OVHCloudSDConfigBuilder>();}
    for (OVHCloudSDConfig item : items) {OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);_visitables.get("ovhcloudSDConfigs").add(builder);this.ovhcloudSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromOvhcloudSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OVHCloudSDConfig... items) {
    if (this.ovhcloudSDConfigs == null) return (A)this;
    for (OVHCloudSDConfig item : items) {OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);_visitables.get("ovhcloudSDConfigs").remove(builder); this.ovhcloudSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOvhcloudSDConfigs(Collection<OVHCloudSDConfig> items) {
    if (this.ovhcloudSDConfigs == null) return (A)this;
    for (OVHCloudSDConfig item : items) {OVHCloudSDConfigBuilder builder = new OVHCloudSDConfigBuilder(item);_visitables.get("ovhcloudSDConfigs").remove(builder); this.ovhcloudSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOvhcloudSDConfigs(Predicate<OVHCloudSDConfigBuilder> predicate) {
    if (ovhcloudSDConfigs == null) return (A) this;
    final Iterator<OVHCloudSDConfigBuilder> each = ovhcloudSDConfigs.iterator();
    final List visitables = _visitables.get("ovhcloudSDConfigs");
    while (each.hasNext()) {
      OVHCloudSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OVHCloudSDConfig> buildOvhcloudSDConfigs() {
    return this.ovhcloudSDConfigs != null ? build(ovhcloudSDConfigs) : null;
  }
  
  public OVHCloudSDConfig buildOvhcloudSDConfig(int index) {
    return this.ovhcloudSDConfigs.get(index).build();
  }
  
  public OVHCloudSDConfig buildFirstOvhcloudSDConfig() {
    return this.ovhcloudSDConfigs.get(0).build();
  }
  
  public OVHCloudSDConfig buildLastOvhcloudSDConfig() {
    return this.ovhcloudSDConfigs.get(ovhcloudSDConfigs.size() - 1).build();
  }
  
  public OVHCloudSDConfig buildMatchingOvhcloudSDConfig(Predicate<OVHCloudSDConfigBuilder> predicate) {
      for (OVHCloudSDConfigBuilder item : ovhcloudSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOvhcloudSDConfig(Predicate<OVHCloudSDConfigBuilder> predicate) {
      for (OVHCloudSDConfigBuilder item : ovhcloudSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOvhcloudSDConfigs(List<OVHCloudSDConfig> ovhcloudSDConfigs) {
    if (this.ovhcloudSDConfigs != null) {
      this._visitables.get("ovhcloudSDConfigs").clear();
    }
    if (ovhcloudSDConfigs != null) {
        this.ovhcloudSDConfigs = new ArrayList();
        for (OVHCloudSDConfig item : ovhcloudSDConfigs) {
          this.addToOvhcloudSDConfigs(item);
        }
    } else {
      this.ovhcloudSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withOvhcloudSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.OVHCloudSDConfig... ovhcloudSDConfigs) {
    if (this.ovhcloudSDConfigs != null) {
        this.ovhcloudSDConfigs.clear();
        _visitables.remove("ovhcloudSDConfigs");
    }
    if (ovhcloudSDConfigs != null) {
      for (OVHCloudSDConfig item : ovhcloudSDConfigs) {
        this.addToOvhcloudSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOvhcloudSDConfigs() {
    return this.ovhcloudSDConfigs != null && !this.ovhcloudSDConfigs.isEmpty();
  }
  
  public OvhcloudSDConfigsNested<A> addNewOvhcloudSDConfig() {
    return new OvhcloudSDConfigsNested(-1, null);
  }
  
  public OvhcloudSDConfigsNested<A> addNewOvhcloudSDConfigLike(OVHCloudSDConfig item) {
    return new OvhcloudSDConfigsNested(-1, item);
  }
  
  public OvhcloudSDConfigsNested<A> setNewOvhcloudSDConfigLike(int index,OVHCloudSDConfig item) {
    return new OvhcloudSDConfigsNested(index, item);
  }
  
  public OvhcloudSDConfigsNested<A> editOvhcloudSDConfig(int index) {
    if (ovhcloudSDConfigs.size() <= index) throw new RuntimeException("Can't edit ovhcloudSDConfigs. Index exceeds size.");
    return setNewOvhcloudSDConfigLike(index, buildOvhcloudSDConfig(index));
  }
  
  public OvhcloudSDConfigsNested<A> editFirstOvhcloudSDConfig() {
    if (ovhcloudSDConfigs.size() == 0) throw new RuntimeException("Can't edit first ovhcloudSDConfigs. The list is empty.");
    return setNewOvhcloudSDConfigLike(0, buildOvhcloudSDConfig(0));
  }
  
  public OvhcloudSDConfigsNested<A> editLastOvhcloudSDConfig() {
    int index = ovhcloudSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ovhcloudSDConfigs. The list is empty.");
    return setNewOvhcloudSDConfigLike(index, buildOvhcloudSDConfig(index));
  }
  
  public OvhcloudSDConfigsNested<A> editMatchingOvhcloudSDConfig(Predicate<OVHCloudSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ovhcloudSDConfigs.size();i++) { 
    if (predicate.test(ovhcloudSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ovhcloudSDConfigs. No match found.");
    return setNewOvhcloudSDConfigLike(index, buildOvhcloudSDConfig(index));
  }
  
  public A addToParams(String key,List<String> value) {
    if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap(); }
    if(key != null && value != null) {this.params.put(key, value);} return (A)this;
  }
  
  public A addToParams(Map<String,List<String>> map) {
    if(this.params == null && map != null) { this.params = new LinkedHashMap(); }
    if(map != null) { this.params.putAll(map);} return (A)this;
  }
  
  public A removeFromParams(String key) {
    if(this.params == null) { return (A) this; }
    if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
  }
  
  public A removeFromParams(Map<String,List<String>> map) {
    if(this.params == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<String>> getParams() {
    return this.params;
  }
  
  public <K,V>A withParams(Map<String,List<String>> params) {
    if (params == null) {
      this.params = null;
    } else {
      this.params = new LinkedHashMap(params);
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null;
  }
  
  public A addToProxyConnectHeader(String key,List<SecretKeySelector> value) {
    if(this.proxyConnectHeader == null && key != null && value != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyConnectHeader.put(key, value);} return (A)this;
  }
  
  public A addToProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null && map != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(map != null) { this.proxyConnectHeader.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(String key) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(key != null && this.proxyConnectHeader != null) {this.proxyConnectHeader.remove(key);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyConnectHeader != null){this.proxyConnectHeader.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<SecretKeySelector>> getProxyConnectHeader() {
    return this.proxyConnectHeader;
  }
  
  public <K,V>A withProxyConnectHeader(Map<String,List<SecretKeySelector>> proxyConnectHeader) {
    if (proxyConnectHeader == null) {
      this.proxyConnectHeader = null;
    } else {
      this.proxyConnectHeader = new LinkedHashMap(proxyConnectHeader);
    }
    return (A) this;
  }
  
  public boolean hasProxyConnectHeader() {
    return this.proxyConnectHeader != null;
  }
  
  public Boolean getProxyFromEnvironment() {
    return this.proxyFromEnvironment;
  }
  
  public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
    this.proxyFromEnvironment = proxyFromEnvironment;
    return (A) this;
  }
  
  public boolean hasProxyFromEnvironment() {
    return this.proxyFromEnvironment != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public A addToPuppetDBSDConfigs(int index,PuppetDBSDConfig item) {
    if (this.puppetDBSDConfigs == null) {this.puppetDBSDConfigs = new ArrayList<PuppetDBSDConfigBuilder>();}
    PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);
    if (index < 0 || index >= puppetDBSDConfigs.size()) { _visitables.get("puppetDBSDConfigs").add(builder); puppetDBSDConfigs.add(builder); } else { _visitables.get("puppetDBSDConfigs").add(index, builder); puppetDBSDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToPuppetDBSDConfigs(int index,PuppetDBSDConfig item) {
    if (this.puppetDBSDConfigs == null) {this.puppetDBSDConfigs = new ArrayList<PuppetDBSDConfigBuilder>();}
    PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);
    if (index < 0 || index >= puppetDBSDConfigs.size()) { _visitables.get("puppetDBSDConfigs").add(builder); puppetDBSDConfigs.add(builder); } else { _visitables.get("puppetDBSDConfigs").set(index, builder); puppetDBSDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToPuppetDBSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PuppetDBSDConfig... items) {
    if (this.puppetDBSDConfigs == null) {this.puppetDBSDConfigs = new ArrayList<PuppetDBSDConfigBuilder>();}
    for (PuppetDBSDConfig item : items) {PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);_visitables.get("puppetDBSDConfigs").add(builder);this.puppetDBSDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToPuppetDBSDConfigs(Collection<PuppetDBSDConfig> items) {
    if (this.puppetDBSDConfigs == null) {this.puppetDBSDConfigs = new ArrayList<PuppetDBSDConfigBuilder>();}
    for (PuppetDBSDConfig item : items) {PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);_visitables.get("puppetDBSDConfigs").add(builder);this.puppetDBSDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromPuppetDBSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PuppetDBSDConfig... items) {
    if (this.puppetDBSDConfigs == null) return (A)this;
    for (PuppetDBSDConfig item : items) {PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);_visitables.get("puppetDBSDConfigs").remove(builder); this.puppetDBSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPuppetDBSDConfigs(Collection<PuppetDBSDConfig> items) {
    if (this.puppetDBSDConfigs == null) return (A)this;
    for (PuppetDBSDConfig item : items) {PuppetDBSDConfigBuilder builder = new PuppetDBSDConfigBuilder(item);_visitables.get("puppetDBSDConfigs").remove(builder); this.puppetDBSDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPuppetDBSDConfigs(Predicate<PuppetDBSDConfigBuilder> predicate) {
    if (puppetDBSDConfigs == null) return (A) this;
    final Iterator<PuppetDBSDConfigBuilder> each = puppetDBSDConfigs.iterator();
    final List visitables = _visitables.get("puppetDBSDConfigs");
    while (each.hasNext()) {
      PuppetDBSDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PuppetDBSDConfig> buildPuppetDBSDConfigs() {
    return this.puppetDBSDConfigs != null ? build(puppetDBSDConfigs) : null;
  }
  
  public PuppetDBSDConfig buildPuppetDBSDConfig(int index) {
    return this.puppetDBSDConfigs.get(index).build();
  }
  
  public PuppetDBSDConfig buildFirstPuppetDBSDConfig() {
    return this.puppetDBSDConfigs.get(0).build();
  }
  
  public PuppetDBSDConfig buildLastPuppetDBSDConfig() {
    return this.puppetDBSDConfigs.get(puppetDBSDConfigs.size() - 1).build();
  }
  
  public PuppetDBSDConfig buildMatchingPuppetDBSDConfig(Predicate<PuppetDBSDConfigBuilder> predicate) {
      for (PuppetDBSDConfigBuilder item : puppetDBSDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPuppetDBSDConfig(Predicate<PuppetDBSDConfigBuilder> predicate) {
      for (PuppetDBSDConfigBuilder item : puppetDBSDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPuppetDBSDConfigs(List<PuppetDBSDConfig> puppetDBSDConfigs) {
    if (this.puppetDBSDConfigs != null) {
      this._visitables.get("puppetDBSDConfigs").clear();
    }
    if (puppetDBSDConfigs != null) {
        this.puppetDBSDConfigs = new ArrayList();
        for (PuppetDBSDConfig item : puppetDBSDConfigs) {
          this.addToPuppetDBSDConfigs(item);
        }
    } else {
      this.puppetDBSDConfigs = null;
    }
    return (A) this;
  }
  
  public A withPuppetDBSDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.PuppetDBSDConfig... puppetDBSDConfigs) {
    if (this.puppetDBSDConfigs != null) {
        this.puppetDBSDConfigs.clear();
        _visitables.remove("puppetDBSDConfigs");
    }
    if (puppetDBSDConfigs != null) {
      for (PuppetDBSDConfig item : puppetDBSDConfigs) {
        this.addToPuppetDBSDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPuppetDBSDConfigs() {
    return this.puppetDBSDConfigs != null && !this.puppetDBSDConfigs.isEmpty();
  }
  
  public PuppetDBSDConfigsNested<A> addNewPuppetDBSDConfig() {
    return new PuppetDBSDConfigsNested(-1, null);
  }
  
  public PuppetDBSDConfigsNested<A> addNewPuppetDBSDConfigLike(PuppetDBSDConfig item) {
    return new PuppetDBSDConfigsNested(-1, item);
  }
  
  public PuppetDBSDConfigsNested<A> setNewPuppetDBSDConfigLike(int index,PuppetDBSDConfig item) {
    return new PuppetDBSDConfigsNested(index, item);
  }
  
  public PuppetDBSDConfigsNested<A> editPuppetDBSDConfig(int index) {
    if (puppetDBSDConfigs.size() <= index) throw new RuntimeException("Can't edit puppetDBSDConfigs. Index exceeds size.");
    return setNewPuppetDBSDConfigLike(index, buildPuppetDBSDConfig(index));
  }
  
  public PuppetDBSDConfigsNested<A> editFirstPuppetDBSDConfig() {
    if (puppetDBSDConfigs.size() == 0) throw new RuntimeException("Can't edit first puppetDBSDConfigs. The list is empty.");
    return setNewPuppetDBSDConfigLike(0, buildPuppetDBSDConfig(0));
  }
  
  public PuppetDBSDConfigsNested<A> editLastPuppetDBSDConfig() {
    int index = puppetDBSDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last puppetDBSDConfigs. The list is empty.");
    return setNewPuppetDBSDConfigLike(index, buildPuppetDBSDConfig(index));
  }
  
  public PuppetDBSDConfigsNested<A> editMatchingPuppetDBSDConfig(Predicate<PuppetDBSDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<puppetDBSDConfigs.size();i++) { 
    if (predicate.test(puppetDBSDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching puppetDBSDConfigs. No match found.");
    return setNewPuppetDBSDConfigLike(index, buildPuppetDBSDConfig(index));
  }
  
  public A addToRelabelings(int index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelings.size()) { _visitables.get("relabelings").add(builder); relabelings.add(builder); } else { _visitables.get("relabelings").add(index, builder); relabelings.add(index, builder);}
    return (A)this;
  }
  
  public A setToRelabelings(int index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelings.size()) { _visitables.get("relabelings").add(builder); relabelings.add(builder); } else { _visitables.get("relabelings").set(index, builder); relabelings.set(index, builder);}
    return (A)this;
  }
  
  public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  
  public A addAllToRelabelings(Collection<RelabelConfig> items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  
  public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder); this.relabelings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
    if (this.relabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder); this.relabelings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelings.iterator();
    final List visitables = _visitables.get("relabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildRelabelings() {
    return this.relabelings != null ? build(relabelings) : null;
  }
  
  public RelabelConfig buildRelabeling(int index) {
    return this.relabelings.get(index).build();
  }
  
  public RelabelConfig buildFirstRelabeling() {
    return this.relabelings.get(0).build();
  }
  
  public RelabelConfig buildLastRelabeling() {
    return this.relabelings.get(relabelings.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : relabelings) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : relabelings) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRelabelings(List<RelabelConfig> relabelings) {
    if (this.relabelings != null) {
      this._visitables.get("relabelings").clear();
    }
    if (relabelings != null) {
        this.relabelings = new ArrayList();
        for (RelabelConfig item : relabelings) {
          this.addToRelabelings(item);
        }
    } else {
      this.relabelings = null;
    }
    return (A) this;
  }
  
  public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
    if (this.relabelings != null) {
        this.relabelings.clear();
        _visitables.remove("relabelings");
    }
    if (relabelings != null) {
      for (RelabelConfig item : relabelings) {
        this.addToRelabelings(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRelabelings() {
    return this.relabelings != null && !this.relabelings.isEmpty();
  }
  
  public RelabelingsNested<A> addNewRelabeling() {
    return new RelabelingsNested(-1, null);
  }
  
  public RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
    return new RelabelingsNested(-1, item);
  }
  
  public RelabelingsNested<A> setNewRelabelingLike(int index,RelabelConfig item) {
    return new RelabelingsNested(index, item);
  }
  
  public RelabelingsNested<A> editRelabeling(int index) {
    if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  
  public RelabelingsNested<A> editFirstRelabeling() {
    if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
    return setNewRelabelingLike(0, buildRelabeling(0));
  }
  
  public RelabelingsNested<A> editLastRelabeling() {
    int index = relabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  
  public RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelings.size();i++) { 
    if (predicate.test(relabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  
  public Long getSampleLimit() {
    return this.sampleLimit;
  }
  
  public A withSampleLimit(Long sampleLimit) {
    this.sampleLimit = sampleLimit;
    return (A) this;
  }
  
  public boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  public A addToScalewaySDConfigs(int index,ScalewaySDConfig item) {
    if (this.scalewaySDConfigs == null) {this.scalewaySDConfigs = new ArrayList<ScalewaySDConfigBuilder>();}
    ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);
    if (index < 0 || index >= scalewaySDConfigs.size()) { _visitables.get("scalewaySDConfigs").add(builder); scalewaySDConfigs.add(builder); } else { _visitables.get("scalewaySDConfigs").add(index, builder); scalewaySDConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToScalewaySDConfigs(int index,ScalewaySDConfig item) {
    if (this.scalewaySDConfigs == null) {this.scalewaySDConfigs = new ArrayList<ScalewaySDConfigBuilder>();}
    ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);
    if (index < 0 || index >= scalewaySDConfigs.size()) { _visitables.get("scalewaySDConfigs").add(builder); scalewaySDConfigs.add(builder); } else { _visitables.get("scalewaySDConfigs").set(index, builder); scalewaySDConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToScalewaySDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ScalewaySDConfig... items) {
    if (this.scalewaySDConfigs == null) {this.scalewaySDConfigs = new ArrayList<ScalewaySDConfigBuilder>();}
    for (ScalewaySDConfig item : items) {ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);_visitables.get("scalewaySDConfigs").add(builder);this.scalewaySDConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToScalewaySDConfigs(Collection<ScalewaySDConfig> items) {
    if (this.scalewaySDConfigs == null) {this.scalewaySDConfigs = new ArrayList<ScalewaySDConfigBuilder>();}
    for (ScalewaySDConfig item : items) {ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);_visitables.get("scalewaySDConfigs").add(builder);this.scalewaySDConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromScalewaySDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ScalewaySDConfig... items) {
    if (this.scalewaySDConfigs == null) return (A)this;
    for (ScalewaySDConfig item : items) {ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);_visitables.get("scalewaySDConfigs").remove(builder); this.scalewaySDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromScalewaySDConfigs(Collection<ScalewaySDConfig> items) {
    if (this.scalewaySDConfigs == null) return (A)this;
    for (ScalewaySDConfig item : items) {ScalewaySDConfigBuilder builder = new ScalewaySDConfigBuilder(item);_visitables.get("scalewaySDConfigs").remove(builder); this.scalewaySDConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromScalewaySDConfigs(Predicate<ScalewaySDConfigBuilder> predicate) {
    if (scalewaySDConfigs == null) return (A) this;
    final Iterator<ScalewaySDConfigBuilder> each = scalewaySDConfigs.iterator();
    final List visitables = _visitables.get("scalewaySDConfigs");
    while (each.hasNext()) {
      ScalewaySDConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ScalewaySDConfig> buildScalewaySDConfigs() {
    return this.scalewaySDConfigs != null ? build(scalewaySDConfigs) : null;
  }
  
  public ScalewaySDConfig buildScalewaySDConfig(int index) {
    return this.scalewaySDConfigs.get(index).build();
  }
  
  public ScalewaySDConfig buildFirstScalewaySDConfig() {
    return this.scalewaySDConfigs.get(0).build();
  }
  
  public ScalewaySDConfig buildLastScalewaySDConfig() {
    return this.scalewaySDConfigs.get(scalewaySDConfigs.size() - 1).build();
  }
  
  public ScalewaySDConfig buildMatchingScalewaySDConfig(Predicate<ScalewaySDConfigBuilder> predicate) {
      for (ScalewaySDConfigBuilder item : scalewaySDConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingScalewaySDConfig(Predicate<ScalewaySDConfigBuilder> predicate) {
      for (ScalewaySDConfigBuilder item : scalewaySDConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScalewaySDConfigs(List<ScalewaySDConfig> scalewaySDConfigs) {
    if (this.scalewaySDConfigs != null) {
      this._visitables.get("scalewaySDConfigs").clear();
    }
    if (scalewaySDConfigs != null) {
        this.scalewaySDConfigs = new ArrayList();
        for (ScalewaySDConfig item : scalewaySDConfigs) {
          this.addToScalewaySDConfigs(item);
        }
    } else {
      this.scalewaySDConfigs = null;
    }
    return (A) this;
  }
  
  public A withScalewaySDConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.ScalewaySDConfig... scalewaySDConfigs) {
    if (this.scalewaySDConfigs != null) {
        this.scalewaySDConfigs.clear();
        _visitables.remove("scalewaySDConfigs");
    }
    if (scalewaySDConfigs != null) {
      for (ScalewaySDConfig item : scalewaySDConfigs) {
        this.addToScalewaySDConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScalewaySDConfigs() {
    return this.scalewaySDConfigs != null && !this.scalewaySDConfigs.isEmpty();
  }
  
  public ScalewaySDConfigsNested<A> addNewScalewaySDConfig() {
    return new ScalewaySDConfigsNested(-1, null);
  }
  
  public ScalewaySDConfigsNested<A> addNewScalewaySDConfigLike(ScalewaySDConfig item) {
    return new ScalewaySDConfigsNested(-1, item);
  }
  
  public ScalewaySDConfigsNested<A> setNewScalewaySDConfigLike(int index,ScalewaySDConfig item) {
    return new ScalewaySDConfigsNested(index, item);
  }
  
  public ScalewaySDConfigsNested<A> editScalewaySDConfig(int index) {
    if (scalewaySDConfigs.size() <= index) throw new RuntimeException("Can't edit scalewaySDConfigs. Index exceeds size.");
    return setNewScalewaySDConfigLike(index, buildScalewaySDConfig(index));
  }
  
  public ScalewaySDConfigsNested<A> editFirstScalewaySDConfig() {
    if (scalewaySDConfigs.size() == 0) throw new RuntimeException("Can't edit first scalewaySDConfigs. The list is empty.");
    return setNewScalewaySDConfigLike(0, buildScalewaySDConfig(0));
  }
  
  public ScalewaySDConfigsNested<A> editLastScalewaySDConfig() {
    int index = scalewaySDConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last scalewaySDConfigs. The list is empty.");
    return setNewScalewaySDConfigLike(index, buildScalewaySDConfig(index));
  }
  
  public ScalewaySDConfigsNested<A> editMatchingScalewaySDConfig(Predicate<ScalewaySDConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<scalewaySDConfigs.size();i++) { 
    if (predicate.test(scalewaySDConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching scalewaySDConfigs. No match found.");
    return setNewScalewaySDConfigLike(index, buildScalewaySDConfig(index));
  }
  
  public String getScheme() {
    return this.scheme;
  }
  
  public A withScheme(String scheme) {
    this.scheme = scheme;
    return (A) this;
  }
  
  public boolean hasScheme() {
    return this.scheme != null;
  }
  
  public String getScrapeClass() {
    return this.scrapeClass;
  }
  
  public A withScrapeClass(String scrapeClass) {
    this.scrapeClass = scrapeClass;
    return (A) this;
  }
  
  public boolean hasScrapeClass() {
    return this.scrapeClass != null;
  }
  
  public Boolean getScrapeClassicHistograms() {
    return this.scrapeClassicHistograms;
  }
  
  public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
    this.scrapeClassicHistograms = scrapeClassicHistograms;
    return (A) this;
  }
  
  public boolean hasScrapeClassicHistograms() {
    return this.scrapeClassicHistograms != null;
  }
  
  public String getScrapeInterval() {
    return this.scrapeInterval;
  }
  
  public A withScrapeInterval(String scrapeInterval) {
    this.scrapeInterval = scrapeInterval;
    return (A) this;
  }
  
  public boolean hasScrapeInterval() {
    return this.scrapeInterval != null;
  }
  
  public A addToScrapeProtocols(int index,String item) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    this.scrapeProtocols.add(index, item);
    return (A)this;
  }
  
  public A setToScrapeProtocols(int index,String item) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    this.scrapeProtocols.set(index, item); return (A)this;
  }
  
  public A addToScrapeProtocols(java.lang.String... items) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    for (String item : items) {this.scrapeProtocols.add(item);} return (A)this;
  }
  
  public A addAllToScrapeProtocols(Collection<String> items) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    for (String item : items) {this.scrapeProtocols.add(item);} return (A)this;
  }
  
  public A removeFromScrapeProtocols(java.lang.String... items) {
    if (this.scrapeProtocols == null) return (A)this;
    for (String item : items) { this.scrapeProtocols.remove(item);} return (A)this;
  }
  
  public A removeAllFromScrapeProtocols(Collection<String> items) {
    if (this.scrapeProtocols == null) return (A)this;
    for (String item : items) { this.scrapeProtocols.remove(item);} return (A)this;
  }
  
  public List<String> getScrapeProtocols() {
    return this.scrapeProtocols;
  }
  
  public String getScrapeProtocol(int index) {
    return this.scrapeProtocols.get(index);
  }
  
  public String getFirstScrapeProtocol() {
    return this.scrapeProtocols.get(0);
  }
  
  public String getLastScrapeProtocol() {
    return this.scrapeProtocols.get(scrapeProtocols.size() - 1);
  }
  
  public String getMatchingScrapeProtocol(Predicate<String> predicate) {
      for (String item : scrapeProtocols) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingScrapeProtocol(Predicate<String> predicate) {
      for (String item : scrapeProtocols) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScrapeProtocols(List<String> scrapeProtocols) {
    if (scrapeProtocols != null) {
        this.scrapeProtocols = new ArrayList();
        for (String item : scrapeProtocols) {
          this.addToScrapeProtocols(item);
        }
    } else {
      this.scrapeProtocols = null;
    }
    return (A) this;
  }
  
  public A withScrapeProtocols(java.lang.String... scrapeProtocols) {
    if (this.scrapeProtocols != null) {
        this.scrapeProtocols.clear();
        _visitables.remove("scrapeProtocols");
    }
    if (scrapeProtocols != null) {
      for (String item : scrapeProtocols) {
        this.addToScrapeProtocols(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScrapeProtocols() {
    return this.scrapeProtocols != null && !this.scrapeProtocols.isEmpty();
  }
  
  public String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  
  public A withScrapeTimeout(String scrapeTimeout) {
    this.scrapeTimeout = scrapeTimeout;
    return (A) this;
  }
  
  public boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  
  public A addToStaticConfigs(int index,StaticConfig item) {
    if (this.staticConfigs == null) {this.staticConfigs = new ArrayList<StaticConfigBuilder>();}
    StaticConfigBuilder builder = new StaticConfigBuilder(item);
    if (index < 0 || index >= staticConfigs.size()) { _visitables.get("staticConfigs").add(builder); staticConfigs.add(builder); } else { _visitables.get("staticConfigs").add(index, builder); staticConfigs.add(index, builder);}
    return (A)this;
  }
  
  public A setToStaticConfigs(int index,StaticConfig item) {
    if (this.staticConfigs == null) {this.staticConfigs = new ArrayList<StaticConfigBuilder>();}
    StaticConfigBuilder builder = new StaticConfigBuilder(item);
    if (index < 0 || index >= staticConfigs.size()) { _visitables.get("staticConfigs").add(builder); staticConfigs.add(builder); } else { _visitables.get("staticConfigs").set(index, builder); staticConfigs.set(index, builder);}
    return (A)this;
  }
  
  public A addToStaticConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.StaticConfig... items) {
    if (this.staticConfigs == null) {this.staticConfigs = new ArrayList<StaticConfigBuilder>();}
    for (StaticConfig item : items) {StaticConfigBuilder builder = new StaticConfigBuilder(item);_visitables.get("staticConfigs").add(builder);this.staticConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToStaticConfigs(Collection<StaticConfig> items) {
    if (this.staticConfigs == null) {this.staticConfigs = new ArrayList<StaticConfigBuilder>();}
    for (StaticConfig item : items) {StaticConfigBuilder builder = new StaticConfigBuilder(item);_visitables.get("staticConfigs").add(builder);this.staticConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromStaticConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.StaticConfig... items) {
    if (this.staticConfigs == null) return (A)this;
    for (StaticConfig item : items) {StaticConfigBuilder builder = new StaticConfigBuilder(item);_visitables.get("staticConfigs").remove(builder); this.staticConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromStaticConfigs(Collection<StaticConfig> items) {
    if (this.staticConfigs == null) return (A)this;
    for (StaticConfig item : items) {StaticConfigBuilder builder = new StaticConfigBuilder(item);_visitables.get("staticConfigs").remove(builder); this.staticConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromStaticConfigs(Predicate<StaticConfigBuilder> predicate) {
    if (staticConfigs == null) return (A) this;
    final Iterator<StaticConfigBuilder> each = staticConfigs.iterator();
    final List visitables = _visitables.get("staticConfigs");
    while (each.hasNext()) {
      StaticConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<StaticConfig> buildStaticConfigs() {
    return this.staticConfigs != null ? build(staticConfigs) : null;
  }
  
  public StaticConfig buildStaticConfig(int index) {
    return this.staticConfigs.get(index).build();
  }
  
  public StaticConfig buildFirstStaticConfig() {
    return this.staticConfigs.get(0).build();
  }
  
  public StaticConfig buildLastStaticConfig() {
    return this.staticConfigs.get(staticConfigs.size() - 1).build();
  }
  
  public StaticConfig buildMatchingStaticConfig(Predicate<StaticConfigBuilder> predicate) {
      for (StaticConfigBuilder item : staticConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingStaticConfig(Predicate<StaticConfigBuilder> predicate) {
      for (StaticConfigBuilder item : staticConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withStaticConfigs(List<StaticConfig> staticConfigs) {
    if (this.staticConfigs != null) {
      this._visitables.get("staticConfigs").clear();
    }
    if (staticConfigs != null) {
        this.staticConfigs = new ArrayList();
        for (StaticConfig item : staticConfigs) {
          this.addToStaticConfigs(item);
        }
    } else {
      this.staticConfigs = null;
    }
    return (A) this;
  }
  
  public A withStaticConfigs(io.fabric8.openshift.api.model.monitoring.v1alpha1.StaticConfig... staticConfigs) {
    if (this.staticConfigs != null) {
        this.staticConfigs.clear();
        _visitables.remove("staticConfigs");
    }
    if (staticConfigs != null) {
      for (StaticConfig item : staticConfigs) {
        this.addToStaticConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasStaticConfigs() {
    return this.staticConfigs != null && !this.staticConfigs.isEmpty();
  }
  
  public StaticConfigsNested<A> addNewStaticConfig() {
    return new StaticConfigsNested(-1, null);
  }
  
  public StaticConfigsNested<A> addNewStaticConfigLike(StaticConfig item) {
    return new StaticConfigsNested(-1, item);
  }
  
  public StaticConfigsNested<A> setNewStaticConfigLike(int index,StaticConfig item) {
    return new StaticConfigsNested(index, item);
  }
  
  public StaticConfigsNested<A> editStaticConfig(int index) {
    if (staticConfigs.size() <= index) throw new RuntimeException("Can't edit staticConfigs. Index exceeds size.");
    return setNewStaticConfigLike(index, buildStaticConfig(index));
  }
  
  public StaticConfigsNested<A> editFirstStaticConfig() {
    if (staticConfigs.size() == 0) throw new RuntimeException("Can't edit first staticConfigs. The list is empty.");
    return setNewStaticConfigLike(0, buildStaticConfig(0));
  }
  
  public StaticConfigsNested<A> editLastStaticConfig() {
    int index = staticConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last staticConfigs. The list is empty.");
    return setNewStaticConfigLike(index, buildStaticConfig(index));
  }
  
  public StaticConfigsNested<A> editMatchingStaticConfig(Predicate<StaticConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<staticConfigs.size();i++) { 
    if (predicate.test(staticConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching staticConfigs. No match found.");
    return setNewStaticConfigLike(index, buildStaticConfig(index));
  }
  
  public Long getTargetLimit() {
    return this.targetLimit;
  }
  
  public A withTargetLimit(Long targetLimit) {
    this.targetLimit = targetLimit;
    return (A) this;
  }
  
  public boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public Boolean getTrackTimestampsStaleness() {
    return this.trackTimestampsStaleness;
  }
  
  public A withTrackTimestampsStaleness(Boolean trackTimestampsStaleness) {
    this.trackTimestampsStaleness = trackTimestampsStaleness;
    return (A) this;
  }
  
  public boolean hasTrackTimestampsStaleness() {
    return this.trackTimestampsStaleness != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScrapeConfigSpecFluent that = (ScrapeConfigSpecFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(azureSDConfigs, that.azureSDConfigs)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(consulSDConfigs, that.consulSDConfigs)) return false;
    if (!java.util.Objects.equals(digitalOceanSDConfigs, that.digitalOceanSDConfigs)) return false;
    if (!java.util.Objects.equals(dnsSDConfigs, that.dnsSDConfigs)) return false;
    if (!java.util.Objects.equals(dockerSDConfigs, that.dockerSDConfigs)) return false;
    if (!java.util.Objects.equals(dockerSwarmSDConfigs, that.dockerSwarmSDConfigs)) return false;
    if (!java.util.Objects.equals(ec2SDConfigs, that.ec2SDConfigs)) return false;
    if (!java.util.Objects.equals(enableCompression, that.enableCompression)) return false;
    if (!java.util.Objects.equals(enableHTTP2, that.enableHTTP2)) return false;
    if (!java.util.Objects.equals(eurekaSDConfigs, that.eurekaSDConfigs)) return false;
    if (!java.util.Objects.equals(fallbackScrapeProtocol, that.fallbackScrapeProtocol)) return false;
    if (!java.util.Objects.equals(fileSDConfigs, that.fileSDConfigs)) return false;
    if (!java.util.Objects.equals(gceSDConfigs, that.gceSDConfigs)) return false;
    if (!java.util.Objects.equals(hetznerSDConfigs, that.hetznerSDConfigs)) return false;
    if (!java.util.Objects.equals(honorLabels, that.honorLabels)) return false;
    if (!java.util.Objects.equals(honorTimestamps, that.honorTimestamps)) return false;
    if (!java.util.Objects.equals(httpSDConfigs, that.httpSDConfigs)) return false;
    if (!java.util.Objects.equals(ionosSDConfigs, that.ionosSDConfigs)) return false;
    if (!java.util.Objects.equals(jobName, that.jobName)) return false;
    if (!java.util.Objects.equals(keepDroppedTargets, that.keepDroppedTargets)) return false;
    if (!java.util.Objects.equals(kubernetesSDConfigs, that.kubernetesSDConfigs)) return false;
    if (!java.util.Objects.equals(kumaSDConfigs, that.kumaSDConfigs)) return false;
    if (!java.util.Objects.equals(labelLimit, that.labelLimit)) return false;
    if (!java.util.Objects.equals(labelNameLengthLimit, that.labelNameLengthLimit)) return false;
    if (!java.util.Objects.equals(labelValueLengthLimit, that.labelValueLengthLimit)) return false;
    if (!java.util.Objects.equals(lightSailSDConfigs, that.lightSailSDConfigs)) return false;
    if (!java.util.Objects.equals(linodeSDConfigs, that.linodeSDConfigs)) return false;
    if (!java.util.Objects.equals(metricRelabelings, that.metricRelabelings)) return false;
    if (!java.util.Objects.equals(metricsPath, that.metricsPath)) return false;
    if (!java.util.Objects.equals(nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) return false;
    if (!java.util.Objects.equals(nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(nomadSDConfigs, that.nomadSDConfigs)) return false;
    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;
    if (!java.util.Objects.equals(openstackSDConfigs, that.openstackSDConfigs)) return false;
    if (!java.util.Objects.equals(ovhcloudSDConfigs, that.ovhcloudSDConfigs)) return false;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(proxyConnectHeader, that.proxyConnectHeader)) return false;
    if (!java.util.Objects.equals(proxyFromEnvironment, that.proxyFromEnvironment)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(puppetDBSDConfigs, that.puppetDBSDConfigs)) return false;
    if (!java.util.Objects.equals(relabelings, that.relabelings)) return false;
    if (!java.util.Objects.equals(sampleLimit, that.sampleLimit)) return false;
    if (!java.util.Objects.equals(scalewaySDConfigs, that.scalewaySDConfigs)) return false;
    if (!java.util.Objects.equals(scheme, that.scheme)) return false;
    if (!java.util.Objects.equals(scrapeClass, that.scrapeClass)) return false;
    if (!java.util.Objects.equals(scrapeClassicHistograms, that.scrapeClassicHistograms)) return false;
    if (!java.util.Objects.equals(scrapeInterval, that.scrapeInterval)) return false;
    if (!java.util.Objects.equals(scrapeProtocols, that.scrapeProtocols)) return false;
    if (!java.util.Objects.equals(scrapeTimeout, that.scrapeTimeout)) return false;
    if (!java.util.Objects.equals(staticConfigs, that.staticConfigs)) return false;
    if (!java.util.Objects.equals(targetLimit, that.targetLimit)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(trackTimestampsStaleness, that.trackTimestampsStaleness)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  azureSDConfigs,  basicAuth,  consulSDConfigs,  digitalOceanSDConfigs,  dnsSDConfigs,  dockerSDConfigs,  dockerSwarmSDConfigs,  ec2SDConfigs,  enableCompression,  enableHTTP2,  eurekaSDConfigs,  fallbackScrapeProtocol,  fileSDConfigs,  gceSDConfigs,  hetznerSDConfigs,  honorLabels,  honorTimestamps,  httpSDConfigs,  ionosSDConfigs,  jobName,  keepDroppedTargets,  kubernetesSDConfigs,  kumaSDConfigs,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  lightSailSDConfigs,  linodeSDConfigs,  metricRelabelings,  metricsPath,  nativeHistogramBucketLimit,  nativeHistogramMinBucketFactor,  noProxy,  nomadSDConfigs,  oauth2,  openstackSDConfigs,  ovhcloudSDConfigs,  params,  proxyConnectHeader,  proxyFromEnvironment,  proxyUrl,  puppetDBSDConfigs,  relabelings,  sampleLimit,  scalewaySDConfigs,  scheme,  scrapeClass,  scrapeClassicHistograms,  scrapeInterval,  scrapeProtocols,  scrapeTimeout,  staticConfigs,  targetLimit,  tlsConfig,  trackTimestampsStaleness,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (azureSDConfigs != null && !azureSDConfigs.isEmpty()) { sb.append("azureSDConfigs:"); sb.append(azureSDConfigs + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (consulSDConfigs != null && !consulSDConfigs.isEmpty()) { sb.append("consulSDConfigs:"); sb.append(consulSDConfigs + ","); }
    if (digitalOceanSDConfigs != null && !digitalOceanSDConfigs.isEmpty()) { sb.append("digitalOceanSDConfigs:"); sb.append(digitalOceanSDConfigs + ","); }
    if (dnsSDConfigs != null && !dnsSDConfigs.isEmpty()) { sb.append("dnsSDConfigs:"); sb.append(dnsSDConfigs + ","); }
    if (dockerSDConfigs != null && !dockerSDConfigs.isEmpty()) { sb.append("dockerSDConfigs:"); sb.append(dockerSDConfigs + ","); }
    if (dockerSwarmSDConfigs != null && !dockerSwarmSDConfigs.isEmpty()) { sb.append("dockerSwarmSDConfigs:"); sb.append(dockerSwarmSDConfigs + ","); }
    if (ec2SDConfigs != null && !ec2SDConfigs.isEmpty()) { sb.append("ec2SDConfigs:"); sb.append(ec2SDConfigs + ","); }
    if (enableCompression != null) { sb.append("enableCompression:"); sb.append(enableCompression + ","); }
    if (enableHTTP2 != null) { sb.append("enableHTTP2:"); sb.append(enableHTTP2 + ","); }
    if (eurekaSDConfigs != null && !eurekaSDConfigs.isEmpty()) { sb.append("eurekaSDConfigs:"); sb.append(eurekaSDConfigs + ","); }
    if (fallbackScrapeProtocol != null) { sb.append("fallbackScrapeProtocol:"); sb.append(fallbackScrapeProtocol + ","); }
    if (fileSDConfigs != null && !fileSDConfigs.isEmpty()) { sb.append("fileSDConfigs:"); sb.append(fileSDConfigs + ","); }
    if (gceSDConfigs != null && !gceSDConfigs.isEmpty()) { sb.append("gceSDConfigs:"); sb.append(gceSDConfigs + ","); }
    if (hetznerSDConfigs != null && !hetznerSDConfigs.isEmpty()) { sb.append("hetznerSDConfigs:"); sb.append(hetznerSDConfigs + ","); }
    if (honorLabels != null) { sb.append("honorLabels:"); sb.append(honorLabels + ","); }
    if (honorTimestamps != null) { sb.append("honorTimestamps:"); sb.append(honorTimestamps + ","); }
    if (httpSDConfigs != null && !httpSDConfigs.isEmpty()) { sb.append("httpSDConfigs:"); sb.append(httpSDConfigs + ","); }
    if (ionosSDConfigs != null && !ionosSDConfigs.isEmpty()) { sb.append("ionosSDConfigs:"); sb.append(ionosSDConfigs + ","); }
    if (jobName != null) { sb.append("jobName:"); sb.append(jobName + ","); }
    if (keepDroppedTargets != null) { sb.append("keepDroppedTargets:"); sb.append(keepDroppedTargets + ","); }
    if (kubernetesSDConfigs != null && !kubernetesSDConfigs.isEmpty()) { sb.append("kubernetesSDConfigs:"); sb.append(kubernetesSDConfigs + ","); }
    if (kumaSDConfigs != null && !kumaSDConfigs.isEmpty()) { sb.append("kumaSDConfigs:"); sb.append(kumaSDConfigs + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (lightSailSDConfigs != null && !lightSailSDConfigs.isEmpty()) { sb.append("lightSailSDConfigs:"); sb.append(lightSailSDConfigs + ","); }
    if (linodeSDConfigs != null && !linodeSDConfigs.isEmpty()) { sb.append("linodeSDConfigs:"); sb.append(linodeSDConfigs + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (metricsPath != null) { sb.append("metricsPath:"); sb.append(metricsPath + ","); }
    if (nativeHistogramBucketLimit != null) { sb.append("nativeHistogramBucketLimit:"); sb.append(nativeHistogramBucketLimit + ","); }
    if (nativeHistogramMinBucketFactor != null) { sb.append("nativeHistogramMinBucketFactor:"); sb.append(nativeHistogramMinBucketFactor + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (nomadSDConfigs != null && !nomadSDConfigs.isEmpty()) { sb.append("nomadSDConfigs:"); sb.append(nomadSDConfigs + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (openstackSDConfigs != null && !openstackSDConfigs.isEmpty()) { sb.append("openstackSDConfigs:"); sb.append(openstackSDConfigs + ","); }
    if (ovhcloudSDConfigs != null && !ovhcloudSDConfigs.isEmpty()) { sb.append("ovhcloudSDConfigs:"); sb.append(ovhcloudSDConfigs + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (proxyConnectHeader != null && !proxyConnectHeader.isEmpty()) { sb.append("proxyConnectHeader:"); sb.append(proxyConnectHeader + ","); }
    if (proxyFromEnvironment != null) { sb.append("proxyFromEnvironment:"); sb.append(proxyFromEnvironment + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (puppetDBSDConfigs != null && !puppetDBSDConfigs.isEmpty()) { sb.append("puppetDBSDConfigs:"); sb.append(puppetDBSDConfigs + ","); }
    if (relabelings != null && !relabelings.isEmpty()) { sb.append("relabelings:"); sb.append(relabelings + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (scalewaySDConfigs != null && !scalewaySDConfigs.isEmpty()) { sb.append("scalewaySDConfigs:"); sb.append(scalewaySDConfigs + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (scrapeClass != null) { sb.append("scrapeClass:"); sb.append(scrapeClass + ","); }
    if (scrapeClassicHistograms != null) { sb.append("scrapeClassicHistograms:"); sb.append(scrapeClassicHistograms + ","); }
    if (scrapeInterval != null) { sb.append("scrapeInterval:"); sb.append(scrapeInterval + ","); }
    if (scrapeProtocols != null && !scrapeProtocols.isEmpty()) { sb.append("scrapeProtocols:"); sb.append(scrapeProtocols + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (staticConfigs != null && !staticConfigs.isEmpty()) { sb.append("staticConfigs:"); sb.append(staticConfigs + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (trackTimestampsStaleness != null) { sb.append("trackTimestampsStaleness:"); sb.append(trackTimestampsStaleness + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnableCompression() {
    return withEnableCompression(true);
  }
  
  public A withEnableHTTP2() {
    return withEnableHTTP2(true);
  }
  
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  
  public A withHonorTimestamps() {
    return withHonorTimestamps(true);
  }
  
  public A withProxyFromEnvironment() {
    return withProxyFromEnvironment(true);
  }
  
  public A withScrapeClassicHistograms() {
    return withScrapeClassicHistograms(true);
  }
  
  public A withTrackTimestampsStaleness() {
    return withTrackTimestampsStaleness(true);
  }
  public class AuthorizationNested<N> extends SafeAuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    SafeAuthorizationBuilder builder;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class AzureSDConfigsNested<N> extends AzureSDConfigFluent<AzureSDConfigsNested<N>> implements Nested<N>{
    AzureSDConfigsNested(int index,AzureSDConfig item) {
      this.index = index;
      this.builder = new AzureSDConfigBuilder(this, item);
    }
    AzureSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToAzureSDConfigs(index,builder.build());
    }
    
    public N endAzureSDConfig() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class ConsulSDConfigsNested<N> extends ConsulSDConfigFluent<ConsulSDConfigsNested<N>> implements Nested<N>{
    ConsulSDConfigsNested(int index,ConsulSDConfig item) {
      this.index = index;
      this.builder = new ConsulSDConfigBuilder(this, item);
    }
    ConsulSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToConsulSDConfigs(index,builder.build());
    }
    
    public N endConsulSDConfig() {
      return and();
    }
    
  
  }
  public class DigitalOceanSDConfigsNested<N> extends DigitalOceanSDConfigFluent<DigitalOceanSDConfigsNested<N>> implements Nested<N>{
    DigitalOceanSDConfigsNested(int index,DigitalOceanSDConfig item) {
      this.index = index;
      this.builder = new DigitalOceanSDConfigBuilder(this, item);
    }
    DigitalOceanSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToDigitalOceanSDConfigs(index,builder.build());
    }
    
    public N endDigitalOceanSDConfig() {
      return and();
    }
    
  
  }
  public class DnsSDConfigsNested<N> extends DNSSDConfigFluent<DnsSDConfigsNested<N>> implements Nested<N>{
    DnsSDConfigsNested(int index,DNSSDConfig item) {
      this.index = index;
      this.builder = new DNSSDConfigBuilder(this, item);
    }
    DNSSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToDnsSDConfigs(index,builder.build());
    }
    
    public N endDnsSDConfig() {
      return and();
    }
    
  
  }
  public class DockerSDConfigsNested<N> extends DockerSDConfigFluent<DockerSDConfigsNested<N>> implements Nested<N>{
    DockerSDConfigsNested(int index,DockerSDConfig item) {
      this.index = index;
      this.builder = new DockerSDConfigBuilder(this, item);
    }
    DockerSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToDockerSDConfigs(index,builder.build());
    }
    
    public N endDockerSDConfig() {
      return and();
    }
    
  
  }
  public class DockerSwarmSDConfigsNested<N> extends DockerSwarmSDConfigFluent<DockerSwarmSDConfigsNested<N>> implements Nested<N>{
    DockerSwarmSDConfigsNested(int index,DockerSwarmSDConfig item) {
      this.index = index;
      this.builder = new DockerSwarmSDConfigBuilder(this, item);
    }
    DockerSwarmSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToDockerSwarmSDConfigs(index,builder.build());
    }
    
    public N endDockerSwarmSDConfig() {
      return and();
    }
    
  
  }
  public class Ec2SDConfigsNested<N> extends EC2SDConfigFluent<Ec2SDConfigsNested<N>> implements Nested<N>{
    Ec2SDConfigsNested(int index,EC2SDConfig item) {
      this.index = index;
      this.builder = new EC2SDConfigBuilder(this, item);
    }
    EC2SDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToEc2SDConfigs(index,builder.build());
    }
    
    public N endEc2SDConfig() {
      return and();
    }
    
  
  }
  public class EurekaSDConfigsNested<N> extends EurekaSDConfigFluent<EurekaSDConfigsNested<N>> implements Nested<N>{
    EurekaSDConfigsNested(int index,EurekaSDConfig item) {
      this.index = index;
      this.builder = new EurekaSDConfigBuilder(this, item);
    }
    EurekaSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToEurekaSDConfigs(index,builder.build());
    }
    
    public N endEurekaSDConfig() {
      return and();
    }
    
  
  }
  public class FileSDConfigsNested<N> extends FileSDConfigFluent<FileSDConfigsNested<N>> implements Nested<N>{
    FileSDConfigsNested(int index,FileSDConfig item) {
      this.index = index;
      this.builder = new FileSDConfigBuilder(this, item);
    }
    FileSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToFileSDConfigs(index,builder.build());
    }
    
    public N endFileSDConfig() {
      return and();
    }
    
  
  }
  public class GceSDConfigsNested<N> extends GCESDConfigFluent<GceSDConfigsNested<N>> implements Nested<N>{
    GceSDConfigsNested(int index,GCESDConfig item) {
      this.index = index;
      this.builder = new GCESDConfigBuilder(this, item);
    }
    GCESDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToGceSDConfigs(index,builder.build());
    }
    
    public N endGceSDConfig() {
      return and();
    }
    
  
  }
  public class HetznerSDConfigsNested<N> extends HetznerSDConfigFluent<HetznerSDConfigsNested<N>> implements Nested<N>{
    HetznerSDConfigsNested(int index,HetznerSDConfig item) {
      this.index = index;
      this.builder = new HetznerSDConfigBuilder(this, item);
    }
    HetznerSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToHetznerSDConfigs(index,builder.build());
    }
    
    public N endHetznerSDConfig() {
      return and();
    }
    
  
  }
  public class HttpSDConfigsNested<N> extends HTTPSDConfigFluent<HttpSDConfigsNested<N>> implements Nested<N>{
    HttpSDConfigsNested(int index,HTTPSDConfig item) {
      this.index = index;
      this.builder = new HTTPSDConfigBuilder(this, item);
    }
    HTTPSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToHttpSDConfigs(index,builder.build());
    }
    
    public N endHttpSDConfig() {
      return and();
    }
    
  
  }
  public class IonosSDConfigsNested<N> extends IonosSDConfigFluent<IonosSDConfigsNested<N>> implements Nested<N>{
    IonosSDConfigsNested(int index,IonosSDConfig item) {
      this.index = index;
      this.builder = new IonosSDConfigBuilder(this, item);
    }
    IonosSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToIonosSDConfigs(index,builder.build());
    }
    
    public N endIonosSDConfig() {
      return and();
    }
    
  
  }
  public class KubernetesSDConfigsNested<N> extends KubernetesSDConfigFluent<KubernetesSDConfigsNested<N>> implements Nested<N>{
    KubernetesSDConfigsNested(int index,KubernetesSDConfig item) {
      this.index = index;
      this.builder = new KubernetesSDConfigBuilder(this, item);
    }
    KubernetesSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToKubernetesSDConfigs(index,builder.build());
    }
    
    public N endKubernetesSDConfig() {
      return and();
    }
    
  
  }
  public class KumaSDConfigsNested<N> extends KumaSDConfigFluent<KumaSDConfigsNested<N>> implements Nested<N>{
    KumaSDConfigsNested(int index,KumaSDConfig item) {
      this.index = index;
      this.builder = new KumaSDConfigBuilder(this, item);
    }
    KumaSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToKumaSDConfigs(index,builder.build());
    }
    
    public N endKumaSDConfig() {
      return and();
    }
    
  
  }
  public class LightSailSDConfigsNested<N> extends LightSailSDConfigFluent<LightSailSDConfigsNested<N>> implements Nested<N>{
    LightSailSDConfigsNested(int index,LightSailSDConfig item) {
      this.index = index;
      this.builder = new LightSailSDConfigBuilder(this, item);
    }
    LightSailSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToLightSailSDConfigs(index,builder.build());
    }
    
    public N endLightSailSDConfig() {
      return and();
    }
    
  
  }
  public class LinodeSDConfigsNested<N> extends LinodeSDConfigFluent<LinodeSDConfigsNested<N>> implements Nested<N>{
    LinodeSDConfigsNested(int index,LinodeSDConfig item) {
      this.index = index;
      this.builder = new LinodeSDConfigBuilder(this, item);
    }
    LinodeSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToLinodeSDConfigs(index,builder.build());
    }
    
    public N endLinodeSDConfig() {
      return and();
    }
    
  
  }
  public class MetricRelabelingsNested<N> extends RelabelConfigFluent<MetricRelabelingsNested<N>> implements Nested<N>{
    MetricRelabelingsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToMetricRelabelings(index,builder.build());
    }
    
    public N endMetricRelabeling() {
      return and();
    }
    
  
  }
  public class NomadSDConfigsNested<N> extends NomadSDConfigFluent<NomadSDConfigsNested<N>> implements Nested<N>{
    NomadSDConfigsNested(int index,NomadSDConfig item) {
      this.index = index;
      this.builder = new NomadSDConfigBuilder(this, item);
    }
    NomadSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToNomadSDConfigs(index,builder.build());
    }
    
    public N endNomadSDConfig() {
      return and();
    }
    
  
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.withOauth2(builder.build());
    }
    
    public N endOauth2() {
      return and();
    }
    
  
  }
  public class OpenstackSDConfigsNested<N> extends OpenStackSDConfigFluent<OpenstackSDConfigsNested<N>> implements Nested<N>{
    OpenstackSDConfigsNested(int index,OpenStackSDConfig item) {
      this.index = index;
      this.builder = new OpenStackSDConfigBuilder(this, item);
    }
    OpenStackSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToOpenstackSDConfigs(index,builder.build());
    }
    
    public N endOpenstackSDConfig() {
      return and();
    }
    
  
  }
  public class OvhcloudSDConfigsNested<N> extends OVHCloudSDConfigFluent<OvhcloudSDConfigsNested<N>> implements Nested<N>{
    OvhcloudSDConfigsNested(int index,OVHCloudSDConfig item) {
      this.index = index;
      this.builder = new OVHCloudSDConfigBuilder(this, item);
    }
    OVHCloudSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToOvhcloudSDConfigs(index,builder.build());
    }
    
    public N endOvhcloudSDConfig() {
      return and();
    }
    
  
  }
  public class PuppetDBSDConfigsNested<N> extends PuppetDBSDConfigFluent<PuppetDBSDConfigsNested<N>> implements Nested<N>{
    PuppetDBSDConfigsNested(int index,PuppetDBSDConfig item) {
      this.index = index;
      this.builder = new PuppetDBSDConfigBuilder(this, item);
    }
    PuppetDBSDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToPuppetDBSDConfigs(index,builder.build());
    }
    
    public N endPuppetDBSDConfig() {
      return and();
    }
    
  
  }
  public class RelabelingsNested<N> extends RelabelConfigFluent<RelabelingsNested<N>> implements Nested<N>{
    RelabelingsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToRelabelings(index,builder.build());
    }
    
    public N endRelabeling() {
      return and();
    }
    
  
  }
  public class ScalewaySDConfigsNested<N> extends ScalewaySDConfigFluent<ScalewaySDConfigsNested<N>> implements Nested<N>{
    ScalewaySDConfigsNested(int index,ScalewaySDConfig item) {
      this.index = index;
      this.builder = new ScalewaySDConfigBuilder(this, item);
    }
    ScalewaySDConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToScalewaySDConfigs(index,builder.build());
    }
    
    public N endScalewaySDConfig() {
      return and();
    }
    
  
  }
  public class StaticConfigsNested<N> extends StaticConfigFluent<StaticConfigsNested<N>> implements Nested<N>{
    StaticConfigsNested(int index,StaticConfig item) {
      this.index = index;
      this.builder = new StaticConfigBuilder(this, item);
    }
    StaticConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.setToStaticConfigs(index,builder.build());
    }
    
    public N endStaticConfig() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) ScrapeConfigSpecFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}