package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FileSDConfigFluent<A extends FileSDConfigFluent<A>> extends BaseFluent<A>{
  public FileSDConfigFluent() {
  }
  
  public FileSDConfigFluent(FileSDConfig instance) {
    this.copyInstance(instance);
  }
  private List<String> files = new ArrayList<String>();
  private String refreshInterval;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FileSDConfig instance) {
    instance = (instance != null ? instance : new FileSDConfig());
    if (instance != null) {
          this.withFiles(instance.getFiles());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFiles(int index,String item) {
    if (this.files == null) {this.files = new ArrayList<String>();}
    this.files.add(index, item);
    return (A)this;
  }
  
  public A setToFiles(int index,String item) {
    if (this.files == null) {this.files = new ArrayList<String>();}
    this.files.set(index, item); return (A)this;
  }
  
  public A addToFiles(java.lang.String... items) {
    if (this.files == null) {this.files = new ArrayList<String>();}
    for (String item : items) {this.files.add(item);} return (A)this;
  }
  
  public A addAllToFiles(Collection<String> items) {
    if (this.files == null) {this.files = new ArrayList<String>();}
    for (String item : items) {this.files.add(item);} return (A)this;
  }
  
  public A removeFromFiles(java.lang.String... items) {
    if (this.files == null) return (A)this;
    for (String item : items) { this.files.remove(item);} return (A)this;
  }
  
  public A removeAllFromFiles(Collection<String> items) {
    if (this.files == null) return (A)this;
    for (String item : items) { this.files.remove(item);} return (A)this;
  }
  
  public List<String> getFiles() {
    return this.files;
  }
  
  public String getFile(int index) {
    return this.files.get(index);
  }
  
  public String getFirstFile() {
    return this.files.get(0);
  }
  
  public String getLastFile() {
    return this.files.get(files.size() - 1);
  }
  
  public String getMatchingFile(Predicate<String> predicate) {
      for (String item : files) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFile(Predicate<String> predicate) {
      for (String item : files) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFiles(List<String> files) {
    if (files != null) {
        this.files = new ArrayList();
        for (String item : files) {
          this.addToFiles(item);
        }
    } else {
      this.files = null;
    }
    return (A) this;
  }
  
  public A withFiles(java.lang.String... files) {
    if (this.files != null) {
        this.files.clear();
        _visitables.remove("files");
    }
    if (files != null) {
      for (String item : files) {
        this.addToFiles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFiles() {
    return this.files != null && !this.files.isEmpty();
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FileSDConfigFluent that = (FileSDConfigFluent) o;
    if (!java.util.Objects.equals(files, that.files)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(files,  refreshInterval,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (files != null && !files.isEmpty()) { sb.append("files:"); sb.append(files + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}