package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NativeHistogramConfigFluent<A extends NativeHistogramConfigFluent<A>> extends BaseFluent<A>{
  public NativeHistogramConfigFluent() {
  }
  
  public NativeHistogramConfigFluent(NativeHistogramConfig instance) {
    this.copyInstance(instance);
  }
  private Long nativeHistogramBucketLimit;
  private Quantity nativeHistogramMinBucketFactor;
  private Boolean scrapeClassicHistograms;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NativeHistogramConfig instance) {
    instance = (instance != null ? instance : new NativeHistogramConfig());
    if (instance != null) {
          this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
          this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
          this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit;
  }
  
  public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
    this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
    return (A) this;
  }
  
  public boolean hasNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit != null;
  }
  
  public Quantity getNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor;
  }
  
  public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
    this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
    return (A) this;
  }
  
  public boolean hasNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor != null;
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount,String format) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount, format));
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount));
  }
  
  public Boolean getScrapeClassicHistograms() {
    return this.scrapeClassicHistograms;
  }
  
  public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
    this.scrapeClassicHistograms = scrapeClassicHistograms;
    return (A) this;
  }
  
  public boolean hasScrapeClassicHistograms() {
    return this.scrapeClassicHistograms != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NativeHistogramConfigFluent that = (NativeHistogramConfigFluent) o;
    if (!java.util.Objects.equals(nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) return false;
    if (!java.util.Objects.equals(nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) return false;
    if (!java.util.Objects.equals(scrapeClassicHistograms, that.scrapeClassicHistograms)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nativeHistogramBucketLimit,  nativeHistogramMinBucketFactor,  scrapeClassicHistograms,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nativeHistogramBucketLimit != null) { sb.append("nativeHistogramBucketLimit:"); sb.append(nativeHistogramBucketLimit + ","); }
    if (nativeHistogramMinBucketFactor != null) { sb.append("nativeHistogramMinBucketFactor:"); sb.append(nativeHistogramMinBucketFactor + ","); }
    if (scrapeClassicHistograms != null) { sb.append("scrapeClassicHistograms:"); sb.append(scrapeClassicHistograms + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withScrapeClassicHistograms() {
    return withScrapeClassicHistograms(true);
  }
  

}