package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BasicAuthBuilder extends BasicAuthFluent<BasicAuthBuilder> implements VisitableBuilder<BasicAuth,BasicAuthBuilder>{
  public BasicAuthBuilder() {
    this(new BasicAuth());
  }
  
  public BasicAuthBuilder(BasicAuthFluent<?> fluent) {
    this(fluent, new BasicAuth());
  }
  
  public BasicAuthBuilder(BasicAuthFluent<?> fluent,BasicAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BasicAuthBuilder(BasicAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BasicAuthFluent<?> fluent;
  
  public BasicAuth build() {
    BasicAuth buildable = new BasicAuth(fluent.getPassword(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}