package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureOAuthBuilder extends AzureOAuthFluent<AzureOAuthBuilder> implements VisitableBuilder<AzureOAuth,AzureOAuthBuilder>{
  public AzureOAuthBuilder() {
    this(new AzureOAuth());
  }
  
  public AzureOAuthBuilder(AzureOAuthFluent<?> fluent) {
    this(fluent, new AzureOAuth());
  }
  
  public AzureOAuthBuilder(AzureOAuthFluent<?> fluent,AzureOAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureOAuthBuilder(AzureOAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureOAuthFluent<?> fluent;
  
  public AzureOAuth build() {
    AzureOAuth buildable = new AzureOAuth(fluent.getClientId(),fluent.getClientSecret(),fluent.getTenantId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}