package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureADFluent<A extends AzureADFluent<A>> extends BaseFluent<A>{
  public AzureADFluent() {
  }
  
  public AzureADFluent(AzureAD instance) {
    this.copyInstance(instance);
  }
  private String cloud;
  private ManagedIdentityBuilder managedIdentity;
  private AzureOAuthBuilder oauth;
  private AzureSDKBuilder sdk;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureAD instance) {
    instance = (instance != null ? instance : new AzureAD());
    if (instance != null) {
          this.withCloud(instance.getCloud());
          this.withManagedIdentity(instance.getManagedIdentity());
          this.withOauth(instance.getOauth());
          this.withSdk(instance.getSdk());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCloud() {
    return this.cloud;
  }
  
  public A withCloud(String cloud) {
    this.cloud = cloud;
    return (A) this;
  }
  
  public boolean hasCloud() {
    return this.cloud != null;
  }
  
  public ManagedIdentity buildManagedIdentity() {
    return this.managedIdentity != null ? this.managedIdentity.build() : null;
  }
  
  public A withManagedIdentity(ManagedIdentity managedIdentity) {
    this._visitables.remove("managedIdentity");
    if (managedIdentity != null) {
        this.managedIdentity = new ManagedIdentityBuilder(managedIdentity);
        this._visitables.get("managedIdentity").add(this.managedIdentity);
    } else {
        this.managedIdentity = null;
        this._visitables.get("managedIdentity").remove(this.managedIdentity);
    }
    return (A) this;
  }
  
  public boolean hasManagedIdentity() {
    return this.managedIdentity != null;
  }
  
  public A withNewManagedIdentity(String clientId) {
    return (A)withManagedIdentity(new ManagedIdentity(clientId));
  }
  
  public ManagedIdentityNested<A> withNewManagedIdentity() {
    return new ManagedIdentityNested(null);
  }
  
  public ManagedIdentityNested<A> withNewManagedIdentityLike(ManagedIdentity item) {
    return new ManagedIdentityNested(item);
  }
  
  public ManagedIdentityNested<A> editManagedIdentity() {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(null));
  }
  
  public ManagedIdentityNested<A> editOrNewManagedIdentity() {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(new ManagedIdentityBuilder().build()));
  }
  
  public ManagedIdentityNested<A> editOrNewManagedIdentityLike(ManagedIdentity item) {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(item));
  }
  
  public AzureOAuth buildOauth() {
    return this.oauth != null ? this.oauth.build() : null;
  }
  
  public A withOauth(AzureOAuth oauth) {
    this._visitables.remove("oauth");
    if (oauth != null) {
        this.oauth = new AzureOAuthBuilder(oauth);
        this._visitables.get("oauth").add(this.oauth);
    } else {
        this.oauth = null;
        this._visitables.get("oauth").remove(this.oauth);
    }
    return (A) this;
  }
  
  public boolean hasOauth() {
    return this.oauth != null;
  }
  
  public OauthNested<A> withNewOauth() {
    return new OauthNested(null);
  }
  
  public OauthNested<A> withNewOauthLike(AzureOAuth item) {
    return new OauthNested(item);
  }
  
  public OauthNested<A> editOauth() {
    return withNewOauthLike(java.util.Optional.ofNullable(buildOauth()).orElse(null));
  }
  
  public OauthNested<A> editOrNewOauth() {
    return withNewOauthLike(java.util.Optional.ofNullable(buildOauth()).orElse(new AzureOAuthBuilder().build()));
  }
  
  public OauthNested<A> editOrNewOauthLike(AzureOAuth item) {
    return withNewOauthLike(java.util.Optional.ofNullable(buildOauth()).orElse(item));
  }
  
  public AzureSDK buildSdk() {
    return this.sdk != null ? this.sdk.build() : null;
  }
  
  public A withSdk(AzureSDK sdk) {
    this._visitables.remove("sdk");
    if (sdk != null) {
        this.sdk = new AzureSDKBuilder(sdk);
        this._visitables.get("sdk").add(this.sdk);
    } else {
        this.sdk = null;
        this._visitables.get("sdk").remove(this.sdk);
    }
    return (A) this;
  }
  
  public boolean hasSdk() {
    return this.sdk != null;
  }
  
  public A withNewSdk(String tenantId) {
    return (A)withSdk(new AzureSDK(tenantId));
  }
  
  public SdkNested<A> withNewSdk() {
    return new SdkNested(null);
  }
  
  public SdkNested<A> withNewSdkLike(AzureSDK item) {
    return new SdkNested(item);
  }
  
  public SdkNested<A> editSdk() {
    return withNewSdkLike(java.util.Optional.ofNullable(buildSdk()).orElse(null));
  }
  
  public SdkNested<A> editOrNewSdk() {
    return withNewSdkLike(java.util.Optional.ofNullable(buildSdk()).orElse(new AzureSDKBuilder().build()));
  }
  
  public SdkNested<A> editOrNewSdkLike(AzureSDK item) {
    return withNewSdkLike(java.util.Optional.ofNullable(buildSdk()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureADFluent that = (AzureADFluent) o;
    if (!java.util.Objects.equals(cloud, that.cloud)) return false;
    if (!java.util.Objects.equals(managedIdentity, that.managedIdentity)) return false;
    if (!java.util.Objects.equals(oauth, that.oauth)) return false;
    if (!java.util.Objects.equals(sdk, that.sdk)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloud,  managedIdentity,  oauth,  sdk,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloud != null) { sb.append("cloud:"); sb.append(cloud + ","); }
    if (managedIdentity != null) { sb.append("managedIdentity:"); sb.append(managedIdentity + ","); }
    if (oauth != null) { sb.append("oauth:"); sb.append(oauth + ","); }
    if (sdk != null) { sb.append("sdk:"); sb.append(sdk + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ManagedIdentityNested<N> extends ManagedIdentityFluent<ManagedIdentityNested<N>> implements Nested<N>{
    ManagedIdentityNested(ManagedIdentity item) {
      this.builder = new ManagedIdentityBuilder(this, item);
    }
    ManagedIdentityBuilder builder;
    
    public N and() {
      return (N) AzureADFluent.this.withManagedIdentity(builder.build());
    }
    
    public N endManagedIdentity() {
      return and();
    }
    
  
  }
  public class OauthNested<N> extends AzureOAuthFluent<OauthNested<N>> implements Nested<N>{
    OauthNested(AzureOAuth item) {
      this.builder = new AzureOAuthBuilder(this, item);
    }
    AzureOAuthBuilder builder;
    
    public N and() {
      return (N) AzureADFluent.this.withOauth(builder.build());
    }
    
    public N endOauth() {
      return and();
    }
    
  
  }
  public class SdkNested<N> extends AzureSDKFluent<SdkNested<N>> implements Nested<N>{
    SdkNested(AzureSDK item) {
      this.builder = new AzureSDKBuilder(this, item);
    }
    AzureSDKBuilder builder;
    
    public N and() {
      return (N) AzureADFluent.this.withSdk(builder.build());
    }
    
    public N endSdk() {
      return and();
    }
    
  
  }

}