package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageFluent<A extends ImageFluent<A>> extends BaseFluent<A>{
  public ImageFluent() {
  }
  
  public ImageFluent(Image instance) {
    this.copyInstance(instance);
  }
  private String offer;
  private String publisher;
  private String resourceID;
  private String sku;
  private String type;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Image instance) {
    instance = (instance != null ? instance : new Image());
    if (instance != null) {
          this.withOffer(instance.getOffer());
          this.withPublisher(instance.getPublisher());
          this.withResourceID(instance.getResourceID());
          this.withSku(instance.getSku());
          this.withType(instance.getType());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getOffer() {
    return this.offer;
  }
  
  public A withOffer(String offer) {
    this.offer = offer;
    return (A) this;
  }
  
  public boolean hasOffer() {
    return this.offer != null;
  }
  
  public String getPublisher() {
    return this.publisher;
  }
  
  public A withPublisher(String publisher) {
    this.publisher = publisher;
    return (A) this;
  }
  
  public boolean hasPublisher() {
    return this.publisher != null;
  }
  
  public String getResourceID() {
    return this.resourceID;
  }
  
  public A withResourceID(String resourceID) {
    this.resourceID = resourceID;
    return (A) this;
  }
  
  public boolean hasResourceID() {
    return this.resourceID != null;
  }
  
  public String getSku() {
    return this.sku;
  }
  
  public A withSku(String sku) {
    this.sku = sku;
    return (A) this;
  }
  
  public boolean hasSku() {
    return this.sku != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageFluent that = (ImageFluent) o;
    if (!java.util.Objects.equals(offer, that.offer)) return false;
    if (!java.util.Objects.equals(publisher, that.publisher)) return false;
    if (!java.util.Objects.equals(resourceID, that.resourceID)) return false;
    if (!java.util.Objects.equals(sku, that.sku)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(offer,  publisher,  resourceID,  sku,  type,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (offer != null) { sb.append("offer:"); sb.append(offer + ","); }
    if (publisher != null) { sb.append("publisher:"); sb.append(publisher + ","); }
    if (resourceID != null) { sb.append("resourceID:"); sb.append(resourceID + ","); }
    if (sku != null) { sb.append("sku:"); sb.append(sku + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}