package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureBootDiagnosticsFluent<A extends AzureBootDiagnosticsFluent<A>> extends BaseFluent<A>{
  public AzureBootDiagnosticsFluent() {
  }
  
  public AzureBootDiagnosticsFluent(AzureBootDiagnostics instance) {
    this.copyInstance(instance);
  }
  private AzureCustomerManagedBootDiagnosticsBuilder customerManaged;
  private String storageAccountType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureBootDiagnostics instance) {
    instance = (instance != null ? instance : new AzureBootDiagnostics());
    if (instance != null) {
          this.withCustomerManaged(instance.getCustomerManaged());
          this.withStorageAccountType(instance.getStorageAccountType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AzureCustomerManagedBootDiagnostics buildCustomerManaged() {
    return this.customerManaged != null ? this.customerManaged.build() : null;
  }
  
  public A withCustomerManaged(AzureCustomerManagedBootDiagnostics customerManaged) {
    this._visitables.remove("customerManaged");
    if (customerManaged != null) {
        this.customerManaged = new AzureCustomerManagedBootDiagnosticsBuilder(customerManaged);
        this._visitables.get("customerManaged").add(this.customerManaged);
    } else {
        this.customerManaged = null;
        this._visitables.get("customerManaged").remove(this.customerManaged);
    }
    return (A) this;
  }
  
  public boolean hasCustomerManaged() {
    return this.customerManaged != null;
  }
  
  public A withNewCustomerManaged(String storageAccountURI) {
    return (A)withCustomerManaged(new AzureCustomerManagedBootDiagnostics(storageAccountURI));
  }
  
  public CustomerManagedNested<A> withNewCustomerManaged() {
    return new CustomerManagedNested(null);
  }
  
  public CustomerManagedNested<A> withNewCustomerManagedLike(AzureCustomerManagedBootDiagnostics item) {
    return new CustomerManagedNested(item);
  }
  
  public CustomerManagedNested<A> editCustomerManaged() {
    return withNewCustomerManagedLike(java.util.Optional.ofNullable(buildCustomerManaged()).orElse(null));
  }
  
  public CustomerManagedNested<A> editOrNewCustomerManaged() {
    return withNewCustomerManagedLike(java.util.Optional.ofNullable(buildCustomerManaged()).orElse(new AzureCustomerManagedBootDiagnosticsBuilder().build()));
  }
  
  public CustomerManagedNested<A> editOrNewCustomerManagedLike(AzureCustomerManagedBootDiagnostics item) {
    return withNewCustomerManagedLike(java.util.Optional.ofNullable(buildCustomerManaged()).orElse(item));
  }
  
  public String getStorageAccountType() {
    return this.storageAccountType;
  }
  
  public A withStorageAccountType(String storageAccountType) {
    this.storageAccountType = storageAccountType;
    return (A) this;
  }
  
  public boolean hasStorageAccountType() {
    return this.storageAccountType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureBootDiagnosticsFluent that = (AzureBootDiagnosticsFluent) o;
    if (!java.util.Objects.equals(customerManaged, that.customerManaged)) return false;
    if (!java.util.Objects.equals(storageAccountType, that.storageAccountType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(customerManaged,  storageAccountType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customerManaged != null) { sb.append("customerManaged:"); sb.append(customerManaged + ","); }
    if (storageAccountType != null) { sb.append("storageAccountType:"); sb.append(storageAccountType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomerManagedNested<N> extends AzureCustomerManagedBootDiagnosticsFluent<CustomerManagedNested<N>> implements Nested<N>{
    CustomerManagedNested(AzureCustomerManagedBootDiagnostics item) {
      this.builder = new AzureCustomerManagedBootDiagnosticsBuilder(this, item);
    }
    AzureCustomerManagedBootDiagnosticsBuilder builder;
    
    public N and() {
      return (N) AzureBootDiagnosticsFluent.this.withCustomerManaged(builder.build());
    }
    
    public N endCustomerManaged() {
      return and();
    }
    
  
  }

}