package io.fabric8.openshift.api.model.machine.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BlockDeviceStorageFluent<A extends BlockDeviceStorageFluent<A>> extends BaseFluent<A>{
  public BlockDeviceStorageFluent() {
  }
  
  public BlockDeviceStorageFluent(BlockDeviceStorage instance) {
    this.copyInstance(instance);
  }
  private String type;
  private BlockDeviceVolumeBuilder volume;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BlockDeviceStorage instance) {
    instance = (instance != null ? instance : new BlockDeviceStorage());
    if (instance != null) {
          this.withType(instance.getType());
          this.withVolume(instance.getVolume());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public BlockDeviceVolume buildVolume() {
    return this.volume != null ? this.volume.build() : null;
  }
  
  public A withVolume(BlockDeviceVolume volume) {
    this._visitables.remove("volume");
    if (volume != null) {
        this.volume = new BlockDeviceVolumeBuilder(volume);
        this._visitables.get("volume").add(this.volume);
    } else {
        this.volume = null;
        this._visitables.get("volume").remove(this.volume);
    }
    return (A) this;
  }
  
  public boolean hasVolume() {
    return this.volume != null;
  }
  
  public A withNewVolume(String availabilityZone,String type) {
    return (A)withVolume(new BlockDeviceVolume(availabilityZone, type));
  }
  
  public VolumeNested<A> withNewVolume() {
    return new VolumeNested(null);
  }
  
  public VolumeNested<A> withNewVolumeLike(BlockDeviceVolume item) {
    return new VolumeNested(item);
  }
  
  public VolumeNested<A> editVolume() {
    return withNewVolumeLike(java.util.Optional.ofNullable(buildVolume()).orElse(null));
  }
  
  public VolumeNested<A> editOrNewVolume() {
    return withNewVolumeLike(java.util.Optional.ofNullable(buildVolume()).orElse(new BlockDeviceVolumeBuilder().build()));
  }
  
  public VolumeNested<A> editOrNewVolumeLike(BlockDeviceVolume item) {
    return withNewVolumeLike(java.util.Optional.ofNullable(buildVolume()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BlockDeviceStorageFluent that = (BlockDeviceStorageFluent) o;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(volume, that.volume)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(type,  volume,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (volume != null) { sb.append("volume:"); sb.append(volume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class VolumeNested<N> extends BlockDeviceVolumeFluent<VolumeNested<N>> implements Nested<N>{
    VolumeNested(BlockDeviceVolume item) {
      this.builder = new BlockDeviceVolumeBuilder(this, item);
    }
    BlockDeviceVolumeBuilder builder;
    
    public N and() {
      return (N) BlockDeviceStorageFluent.this.withVolume(builder.build());
    }
    
    public N endVolume() {
      return and();
    }
    
  
  }

}