package io.fabric8.openshift.api.model.machine.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NutanixVMStorageConfigFluent<A extends NutanixVMStorageConfigFluent<A>> extends BaseFluent<A>{
  public NutanixVMStorageConfigFluent() {
  }
  
  public NutanixVMStorageConfigFluent(NutanixVMStorageConfig instance) {
    this.copyInstance(instance);
  }
  private String diskMode;
  private NutanixStorageResourceIdentifierBuilder storageContainer;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NutanixVMStorageConfig instance) {
    instance = (instance != null ? instance : new NutanixVMStorageConfig());
    if (instance != null) {
          this.withDiskMode(instance.getDiskMode());
          this.withStorageContainer(instance.getStorageContainer());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDiskMode() {
    return this.diskMode;
  }
  
  public A withDiskMode(String diskMode) {
    this.diskMode = diskMode;
    return (A) this;
  }
  
  public boolean hasDiskMode() {
    return this.diskMode != null;
  }
  
  public NutanixStorageResourceIdentifier buildStorageContainer() {
    return this.storageContainer != null ? this.storageContainer.build() : null;
  }
  
  public A withStorageContainer(NutanixStorageResourceIdentifier storageContainer) {
    this._visitables.remove("storageContainer");
    if (storageContainer != null) {
        this.storageContainer = new NutanixStorageResourceIdentifierBuilder(storageContainer);
        this._visitables.get("storageContainer").add(this.storageContainer);
    } else {
        this.storageContainer = null;
        this._visitables.get("storageContainer").remove(this.storageContainer);
    }
    return (A) this;
  }
  
  public boolean hasStorageContainer() {
    return this.storageContainer != null;
  }
  
  public A withNewStorageContainer(String type,String uuid) {
    return (A)withStorageContainer(new NutanixStorageResourceIdentifier(type, uuid));
  }
  
  public StorageContainerNested<A> withNewStorageContainer() {
    return new StorageContainerNested(null);
  }
  
  public StorageContainerNested<A> withNewStorageContainerLike(NutanixStorageResourceIdentifier item) {
    return new StorageContainerNested(item);
  }
  
  public StorageContainerNested<A> editStorageContainer() {
    return withNewStorageContainerLike(java.util.Optional.ofNullable(buildStorageContainer()).orElse(null));
  }
  
  public StorageContainerNested<A> editOrNewStorageContainer() {
    return withNewStorageContainerLike(java.util.Optional.ofNullable(buildStorageContainer()).orElse(new NutanixStorageResourceIdentifierBuilder().build()));
  }
  
  public StorageContainerNested<A> editOrNewStorageContainerLike(NutanixStorageResourceIdentifier item) {
    return withNewStorageContainerLike(java.util.Optional.ofNullable(buildStorageContainer()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NutanixVMStorageConfigFluent that = (NutanixVMStorageConfigFluent) o;
    if (!java.util.Objects.equals(diskMode, that.diskMode)) return false;
    if (!java.util.Objects.equals(storageContainer, that.storageContainer)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(diskMode,  storageContainer,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (diskMode != null) { sb.append("diskMode:"); sb.append(diskMode + ","); }
    if (storageContainer != null) { sb.append("storageContainer:"); sb.append(storageContainer + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class StorageContainerNested<N> extends NutanixStorageResourceIdentifierFluent<StorageContainerNested<N>> implements Nested<N>{
    StorageContainerNested(NutanixStorageResourceIdentifier item) {
      this.builder = new NutanixStorageResourceIdentifierBuilder(this, item);
    }
    NutanixStorageResourceIdentifierBuilder builder;
    
    public N and() {
      return (N) NutanixVMStorageConfigFluent.this.withStorageContainer(builder.build());
    }
    
    public N endStorageContainer() {
      return and();
    }
    
  
  }

}