package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineSetStatusBuilder extends MachineSetStatusFluentImpl<MachineSetStatusBuilder> implements VisitableBuilder<MachineSetStatus,MachineSetStatusBuilder>{
  public MachineSetStatusBuilder() {
    this(false);
  }
  public MachineSetStatusBuilder(Boolean validationEnabled) {
    this(new MachineSetStatus(), validationEnabled);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineSetStatus(), validationEnabled);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,MachineSetStatus instance) {
    this(fluent, instance, false);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,MachineSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withErrorMessage(instance.getErrorMessage());
      fluent.withErrorReason(instance.getErrorReason());
      fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineSetStatusBuilder(MachineSetStatus instance) {
    this(instance,false);
  }
  public MachineSetStatusBuilder(MachineSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withErrorMessage(instance.getErrorMessage());
      this.withErrorReason(instance.getErrorReason());
      this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineSetStatus build() {
    MachineSetStatus buildable = new MachineSetStatus(fluent.getAvailableReplicas(),fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}