package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterClaimBuilder extends ClusterClaimFluent<ClusterClaimBuilder> implements VisitableBuilder<ClusterClaim,ClusterClaimBuilder>{
  public ClusterClaimBuilder() {
    this(new ClusterClaim());
  }
  
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent) {
    this(fluent, new ClusterClaim());
  }
  
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent,ClusterClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterClaimBuilder(ClusterClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterClaimFluent<?> fluent;
  
  public ClusterClaim build() {
    ClusterClaim buildable = new ClusterClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}