/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KlusterletSpecFluent<A extends KlusterletSpecFluent<A>>
extends BaseFluent<A> {
    private String clusterName;
    private ArrayList<ServerURLBuilder> externalServerURLs = new ArrayList();
    private String namespace;
    private NodePlacementBuilder nodePlacement;
    private String registrationImagePullSpec;
    private String workImagePullSpec;

    public KlusterletSpecFluent() {
    }

    public KlusterletSpecFluent(KlusterletSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KlusterletSpec instance) {
        KlusterletSpec klusterletSpec = instance = instance != null ? instance : new KlusterletSpec();
        if (instance != null) {
            this.withClusterName(instance.getClusterName());
            this.withExternalServerURLs(instance.getExternalServerURLs());
            this.withNamespace(instance.getNamespace());
            this.withNodePlacement(instance.getNodePlacement());
            this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
            this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
            this.withClusterName(instance.getClusterName());
            this.withExternalServerURLs(instance.getExternalServerURLs());
            this.withNamespace(instance.getNamespace());
            this.withNodePlacement(instance.getNodePlacement());
            this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
            this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public A addToExternalServerURLs(int index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        if (index < 0 || index >= this.externalServerURLs.size()) {
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        } else {
            this._visitables.get((Object)"externalServerURLs").add(index, builder);
            this.externalServerURLs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExternalServerURLs(int index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        if (index < 0 || index >= this.externalServerURLs.size()) {
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        } else {
            this._visitables.get((Object)"externalServerURLs").set(index, builder);
            this.externalServerURLs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExternalServerURLs(ServerURL ... items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExternalServerURLs(Collection<ServerURL> items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalServerURLs(ServerURL ... items) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove((Object)builder);
            this.externalServerURLs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExternalServerURLs(Collection<ServerURL> items) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove((Object)builder);
            this.externalServerURLs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExternalServerURLs(Predicate<ServerURLBuilder> predicate) {
        if (this.externalServerURLs == null) {
            return (A)((Object)this);
        }
        Iterator<ServerURLBuilder> each = this.externalServerURLs.iterator();
        List visitables = this._visitables.get((Object)"externalServerURLs");
        while (each.hasNext()) {
            ServerURLBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServerURL> buildExternalServerURLs() {
        return this.externalServerURLs != null ? KlusterletSpecFluent.build(this.externalServerURLs) : null;
    }

    public ServerURL buildExternalServerURL(int index) {
        return this.externalServerURLs.get(index).build();
    }

    public ServerURL buildFirstExternalServerURL() {
        return this.externalServerURLs.get(0).build();
    }

    public ServerURL buildLastExternalServerURL() {
        return this.externalServerURLs.get(this.externalServerURLs.size() - 1).build();
    }

    public ServerURL buildMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalServerURLs(List<ServerURL> externalServerURLs) {
        if (this.externalServerURLs != null) {
            this._visitables.get((Object)"externalServerURLs").clear();
        }
        if (externalServerURLs != null) {
            this.externalServerURLs = new ArrayList();
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        } else {
            this.externalServerURLs = null;
        }
        return (A)((Object)this);
    }

    public A withExternalServerURLs(ServerURL ... externalServerURLs) {
        if (this.externalServerURLs != null) {
            this.externalServerURLs.clear();
            this._visitables.remove((Object)"externalServerURLs");
        }
        if (externalServerURLs != null) {
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExternalServerURLs() {
        return this.externalServerURLs != null && !this.externalServerURLs.isEmpty();
    }

    public A addNewExternalServerURL(String caBundle, String url) {
        return this.addToExternalServerURLs(new ServerURL(caBundle, url));
    }

    public ExternalServerURLsNested<A> addNewExternalServerURL() {
        return new ExternalServerURLsNested(-1, null);
    }

    public ExternalServerURLsNested<A> addNewExternalServerURLLike(ServerURL item) {
        return new ExternalServerURLsNested(-1, item);
    }

    public ExternalServerURLsNested<A> setNewExternalServerURLLike(int index, ServerURL item) {
        return new ExternalServerURLsNested(index, item);
    }

    public ExternalServerURLsNested<A> editExternalServerURL(int index) {
        if (this.externalServerURLs.size() <= index) {
            throw new RuntimeException("Can't edit externalServerURLs. Index exceeds size.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public ExternalServerURLsNested<A> editFirstExternalServerURL() {
        if (this.externalServerURLs.size() == 0) {
            throw new RuntimeException("Can't edit first externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(0, this.buildExternalServerURL(0));
    }

    public ExternalServerURLsNested<A> editLastExternalServerURL() {
        int index = this.externalServerURLs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public ExternalServerURLsNested<A> editMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.externalServerURLs.size(); ++i) {
            if (!predicate.test(this.externalServerURLs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching externalServerURLs. No match found.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public NodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    public A withNodePlacement(NodePlacement nodePlacement) {
        this._visitables.get((Object)"nodePlacement").remove((Object)this.nodePlacement);
        if (nodePlacement != null) {
            this.nodePlacement = new NodePlacementBuilder(nodePlacement);
            this._visitables.get((Object)"nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get((Object)"nodePlacement").remove((Object)this.nodePlacement);
        }
        return (A)((Object)this);
    }

    public boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNested(null);
    }

    public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
        return new NodePlacementNested(item);
    }

    public NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(null));
    }

    public NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
    }

    public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(item));
    }

    public String getRegistrationImagePullSpec() {
        return this.registrationImagePullSpec;
    }

    public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
        this.registrationImagePullSpec = registrationImagePullSpec;
        return (A)((Object)this);
    }

    public boolean hasRegistrationImagePullSpec() {
        return this.registrationImagePullSpec != null;
    }

    public String getWorkImagePullSpec() {
        return this.workImagePullSpec;
    }

    public A withWorkImagePullSpec(String workImagePullSpec) {
        this.workImagePullSpec = workImagePullSpec;
        return (A)((Object)this);
    }

    public boolean hasWorkImagePullSpec() {
        return this.workImagePullSpec != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KlusterletSpecFluent that = (KlusterletSpecFluent)((Object)o);
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.externalServerURLs, that.externalServerURLs)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodePlacement, (Object)that.nodePlacement)) {
            return false;
        }
        if (!Objects.equals(this.registrationImagePullSpec, that.registrationImagePullSpec)) {
            return false;
        }
        return Objects.equals(this.workImagePullSpec, that.workImagePullSpec);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterName, this.externalServerURLs, this.namespace, this.nodePlacement, this.registrationImagePullSpec, this.workImagePullSpec, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.externalServerURLs != null && !this.externalServerURLs.isEmpty()) {
            sb.append("externalServerURLs:");
            sb.append(this.externalServerURLs + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append((Object)((Object)this.nodePlacement) + ",");
        }
        if (this.registrationImagePullSpec != null) {
            sb.append("registrationImagePullSpec:");
            sb.append(this.registrationImagePullSpec + ",");
        }
        if (this.workImagePullSpec != null) {
            sb.append("workImagePullSpec:");
            sb.append(this.workImagePullSpec);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodePlacementNested<N>
    extends NodePlacementFluent<NodePlacementNested<N>>
    implements Nested<N> {
        NodePlacementBuilder builder;

        NodePlacementNested(NodePlacement item) {
            this.builder = new NodePlacementBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.withNodePlacement(this.builder.build());
        }

        public N endNodePlacement() {
            return this.and();
        }
    }

    public class ExternalServerURLsNested<N>
    extends ServerURLFluent<ExternalServerURLsNested<N>>
    implements Nested<N> {
        ServerURLBuilder builder;
        int index;

        ExternalServerURLsNested(int index, ServerURL item) {
            this.index = index;
            this.builder = new ServerURLBuilder(this, item);
        }

        public N and() {
            return (N)KlusterletSpecFluent.this.setToExternalServerURLs(this.index, this.builder.build());
        }

        public N endExternalServerURL() {
            return this.and();
        }
    }
}

