/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfigBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfigFluent;
import java.util.Objects;
import java.util.Optional;

public class BackupConfigFluent<A extends BackupConfigFluent<A>>
extends BaseFluent<A> {
    private Integer minBackupPeriodSeconds;
    private VeleroBackupConfigBuilder velero;

    public BackupConfigFluent() {
    }

    public BackupConfigFluent(BackupConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackupConfig instance) {
        BackupConfig backupConfig = instance = instance != null ? instance : new BackupConfig();
        if (instance != null) {
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
        }
    }

    public Integer getMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds;
    }

    public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
        this.minBackupPeriodSeconds = minBackupPeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds != null;
    }

    public VeleroBackupConfig buildVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    public A withVelero(VeleroBackupConfig velero) {
        this._visitables.get((Object)"velero").remove((Object)this.velero);
        if (velero != null) {
            this.velero = new VeleroBackupConfigBuilder(velero);
            this._visitables.get((Object)"velero").add(this.velero);
        } else {
            this.velero = null;
            this._visitables.get((Object)"velero").remove((Object)this.velero);
        }
        return (A)((Object)this);
    }

    public boolean hasVelero() {
        return this.velero != null;
    }

    public A withNewVelero(Boolean enabled) {
        return this.withVelero(new VeleroBackupConfig(enabled));
    }

    public VeleroNested<A> withNewVelero() {
        return new VeleroNested(null);
    }

    public VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
        return new VeleroNested(item);
    }

    public VeleroNested<A> editVelero() {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(null));
    }

    public VeleroNested<A> editOrNewVelero() {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(new VeleroBackupConfigBuilder().build()));
    }

    public VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupConfigFluent that = (BackupConfigFluent)((Object)o);
        if (!Objects.equals(this.minBackupPeriodSeconds, that.minBackupPeriodSeconds)) {
            return false;
        }
        return Objects.equals((Object)this.velero, (Object)that.velero);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minBackupPeriodSeconds, this.velero, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minBackupPeriodSeconds != null) {
            sb.append("minBackupPeriodSeconds:");
            sb.append(this.minBackupPeriodSeconds + ",");
        }
        if (this.velero != null) {
            sb.append("velero:");
            sb.append((Object)this.velero);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VeleroNested<N>
    extends VeleroBackupConfigFluent<VeleroNested<N>>
    implements Nested<N> {
        VeleroBackupConfigBuilder builder;

        VeleroNested(VeleroBackupConfig item) {
            this.builder = new VeleroBackupConfigBuilder(this, item);
        }

        public N and() {
            return (N)BackupConfigFluent.this.withVelero(this.builder.build());
        }

        public N endVelero() {
            return this.and();
        }
    }
}

