/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.NodeStatus;
import io.fabric8.openshift.api.model.operator.v1.NodeStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>>
extends BaseFluent<A>
implements NodeStatusFluent<A> {
    private Integer currentRevision;
    private Integer lastFailedCount;
    private String lastFailedReason;
    private Integer lastFailedRevision;
    private List<String> lastFailedRevisionErrors = new ArrayList<String>();
    private String lastFailedTime;
    private Integer lastFallbackCount;
    private String nodeName;
    private Integer targetRevision;
    private Map<String, Object> additionalProperties;

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(NodeStatus instance) {
        if (instance != null) {
            this.withCurrentRevision(instance.getCurrentRevision());
            this.withLastFailedCount(instance.getLastFailedCount());
            this.withLastFailedReason(instance.getLastFailedReason());
            this.withLastFailedRevision(instance.getLastFailedRevision());
            this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
            this.withLastFailedTime(instance.getLastFailedTime());
            this.withLastFallbackCount(instance.getLastFallbackCount());
            this.withNodeName(instance.getNodeName());
            this.withTargetRevision(instance.getTargetRevision());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public A withCurrentRevision(Integer currentRevision) {
        this.currentRevision = currentRevision;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    @Override
    public Integer getLastFailedCount() {
        return this.lastFailedCount;
    }

    @Override
    public A withLastFailedCount(Integer lastFailedCount) {
        this.lastFailedCount = lastFailedCount;
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedCount() {
        return this.lastFailedCount != null;
    }

    @Override
    public String getLastFailedReason() {
        return this.lastFailedReason;
    }

    @Override
    public A withLastFailedReason(String lastFailedReason) {
        this.lastFailedReason = lastFailedReason;
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedReason() {
        return this.lastFailedReason != null;
    }

    @Override
    public Integer getLastFailedRevision() {
        return this.lastFailedRevision;
    }

    @Override
    public A withLastFailedRevision(Integer lastFailedRevision) {
        this.lastFailedRevision = lastFailedRevision;
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedRevision() {
        return this.lastFailedRevision != null;
    }

    @Override
    public A addToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLastFailedRevisionErrors(String ... items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLastFailedRevisionErrors(Collection<String> items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLastFailedRevisionErrors(String ... items) {
        for (String item : items) {
            if (this.lastFailedRevisionErrors == null) continue;
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLastFailedRevisionErrors(Collection<String> items) {
        for (String item : items) {
            if (this.lastFailedRevisionErrors == null) continue;
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors;
    }

    @Override
    public String getLastFailedRevisionError(int index) {
        return this.lastFailedRevisionErrors.get(index);
    }

    @Override
    public String getFirstLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(0);
    }

    @Override
    public String getLastLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(this.lastFailedRevisionErrors.size() - 1);
    }

    @Override
    public String getMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors) {
        if (lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        } else {
            this.lastFailedRevisionErrors = null;
        }
        return (A)this;
    }

    @Override
    public A withLastFailedRevisionErrors(String ... lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors.clear();
            this._visitables.remove("lastFailedRevisionErrors");
        }
        if (lastFailedRevisionErrors != null) {
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors != null && !this.lastFailedRevisionErrors.isEmpty();
    }

    @Override
    public String getLastFailedTime() {
        return this.lastFailedTime;
    }

    @Override
    public A withLastFailedTime(String lastFailedTime) {
        this.lastFailedTime = lastFailedTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedTime() {
        return this.lastFailedTime != null;
    }

    @Override
    public Integer getLastFallbackCount() {
        return this.lastFallbackCount;
    }

    @Override
    public A withLastFallbackCount(Integer lastFallbackCount) {
        this.lastFallbackCount = lastFallbackCount;
        return (A)this;
    }

    @Override
    public Boolean hasLastFallbackCount() {
        return this.lastFallbackCount != null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public Integer getTargetRevision() {
        return this.targetRevision;
    }

    @Override
    public A withTargetRevision(Integer targetRevision) {
        this.targetRevision = targetRevision;
        return (A)this;
    }

    @Override
    public Boolean hasTargetRevision() {
        return this.targetRevision != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluentImpl that = (NodeStatusFluentImpl)o;
        if (!Objects.equals(this.currentRevision, that.currentRevision)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedCount, that.lastFailedCount)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedReason, that.lastFailedReason)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedRevision, that.lastFailedRevision)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedRevisionErrors, that.lastFailedRevisionErrors)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedTime, that.lastFailedTime)) {
            return false;
        }
        if (!Objects.equals(this.lastFallbackCount, that.lastFallbackCount)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.targetRevision, that.targetRevision)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentRevision, this.lastFailedCount, this.lastFailedReason, this.lastFailedRevision, this.lastFailedRevisionErrors, this.lastFailedTime, this.lastFallbackCount, this.nodeName, this.targetRevision, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentRevision != null) {
            sb.append("currentRevision:");
            sb.append(this.currentRevision + ",");
        }
        if (this.lastFailedCount != null) {
            sb.append("lastFailedCount:");
            sb.append(this.lastFailedCount + ",");
        }
        if (this.lastFailedReason != null) {
            sb.append("lastFailedReason:");
            sb.append(this.lastFailedReason + ",");
        }
        if (this.lastFailedRevision != null) {
            sb.append("lastFailedRevision:");
            sb.append(this.lastFailedRevision + ",");
        }
        if (this.lastFailedRevisionErrors != null && !this.lastFailedRevisionErrors.isEmpty()) {
            sb.append("lastFailedRevisionErrors:");
            sb.append(this.lastFailedRevisionErrors + ",");
        }
        if (this.lastFailedTime != null) {
            sb.append("lastFailedTime:");
            sb.append(this.lastFailedTime + ",");
        }
        if (this.lastFallbackCount != null) {
            sb.append("lastFallbackCount:");
            sb.append(this.lastFallbackCount + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRevision != null) {
            sb.append("targetRevision:");
            sb.append(this.targetRevision + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

