/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHints;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RootDeviceHintsFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SoftwareRAIDVolumeFluentImpl<A extends SoftwareRAIDVolumeFluent<A>>
extends BaseFluent<A>
implements SoftwareRAIDVolumeFluent<A> {
    private String level;
    private ArrayList<RootDeviceHintsBuilder> physicalDisks = new ArrayList();
    private Integer sizeGibibytes;
    private Map<String, Object> additionalProperties;

    public SoftwareRAIDVolumeFluentImpl() {
    }

    public SoftwareRAIDVolumeFluentImpl(SoftwareRAIDVolume instance) {
        if (instance != null) {
            this.withLevel(instance.getLevel());
            this.withPhysicalDisks(instance.getPhysicalDisks());
            this.withSizeGibibytes(instance.getSizeGibibytes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public A withLevel(String level) {
        this.level = level;
        return (A)this;
    }

    @Override
    public Boolean hasLevel() {
        return this.level != null;
    }

    @Override
    public A addToPhysicalDisks(int index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        if (index < 0 || index >= this.physicalDisks.size()) {
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        } else {
            this._visitables.get("physicalDisks").add(index, builder);
            this.physicalDisks.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPhysicalDisks(int index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        if (index < 0 || index >= this.physicalDisks.size()) {
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        } else {
            this._visitables.get("physicalDisks").set(index, builder);
            this.physicalDisks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPhysicalDisks(RootDeviceHints ... items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPhysicalDisks(Collection<RootDeviceHints> items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPhysicalDisks(RootDeviceHints ... items) {
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").remove(builder);
            if (this.physicalDisks == null) continue;
            this.physicalDisks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPhysicalDisks(Collection<RootDeviceHints> items) {
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").remove(builder);
            if (this.physicalDisks == null) continue;
            this.physicalDisks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPhysicalDisks(Predicate<RootDeviceHintsBuilder> predicate) {
        if (this.physicalDisks == null) {
            return (A)this;
        }
        Iterator<RootDeviceHintsBuilder> each = this.physicalDisks.iterator();
        Object visitables = this._visitables.get("physicalDisks");
        while (each.hasNext()) {
            RootDeviceHintsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RootDeviceHints> getPhysicalDisks() {
        return this.physicalDisks != null ? SoftwareRAIDVolumeFluentImpl.build(this.physicalDisks) : null;
    }

    @Override
    public List<RootDeviceHints> buildPhysicalDisks() {
        return this.physicalDisks != null ? SoftwareRAIDVolumeFluentImpl.build(this.physicalDisks) : null;
    }

    @Override
    public RootDeviceHints buildPhysicalDisk(int index) {
        return this.physicalDisks.get(index).build();
    }

    @Override
    public RootDeviceHints buildFirstPhysicalDisk() {
        return this.physicalDisks.get(0).build();
    }

    @Override
    public RootDeviceHints buildLastPhysicalDisk() {
        return this.physicalDisks.get(this.physicalDisks.size() - 1).build();
    }

    @Override
    public RootDeviceHints buildMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPhysicalDisks(List<RootDeviceHints> physicalDisks) {
        if (this.physicalDisks != null) {
            this._visitables.get("physicalDisks").clear();
        }
        if (physicalDisks != null) {
            this.physicalDisks = new ArrayList();
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        } else {
            this.physicalDisks = null;
        }
        return (A)this;
    }

    @Override
    public A withPhysicalDisks(RootDeviceHints ... physicalDisks) {
        if (this.physicalDisks != null) {
            this.physicalDisks.clear();
            this._visitables.remove("physicalDisks");
        }
        if (physicalDisks != null) {
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPhysicalDisks() {
        return this.physicalDisks != null && !this.physicalDisks.isEmpty();
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> addNewPhysicalDisk() {
        return new PhysicalDisksNestedImpl();
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> addNewPhysicalDiskLike(RootDeviceHints item) {
        return new PhysicalDisksNestedImpl(-1, item);
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> setNewPhysicalDiskLike(int index, RootDeviceHints item) {
        return new PhysicalDisksNestedImpl(index, item);
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editPhysicalDisk(int index) {
        if (this.physicalDisks.size() <= index) {
            throw new RuntimeException("Can't edit physicalDisks. Index exceeds size.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editFirstPhysicalDisk() {
        if (this.physicalDisks.size() == 0) {
            throw new RuntimeException("Can't edit first physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(0, this.buildPhysicalDisk(0));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editLastPhysicalDisk() {
        int index = this.physicalDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.physicalDisks.size(); ++i) {
            if (!predicate.test(this.physicalDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching physicalDisks. No match found.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public Integer getSizeGibibytes() {
        return this.sizeGibibytes;
    }

    @Override
    public A withSizeGibibytes(Integer sizeGibibytes) {
        this.sizeGibibytes = sizeGibibytes;
        return (A)this;
    }

    @Override
    public Boolean hasSizeGibibytes() {
        return this.sizeGibibytes != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoftwareRAIDVolumeFluentImpl that = (SoftwareRAIDVolumeFluentImpl)o;
        if (!Objects.equals(this.level, that.level)) {
            return false;
        }
        if (!Objects.equals(this.physicalDisks, that.physicalDisks)) {
            return false;
        }
        if (!Objects.equals(this.sizeGibibytes, that.sizeGibibytes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.level, this.physicalDisks, this.sizeGibibytes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.level != null) {
            sb.append("level:");
            sb.append(this.level + ",");
        }
        if (this.physicalDisks != null) {
            sb.append("physicalDisks:");
            sb.append(this.physicalDisks + ",");
        }
        if (this.sizeGibibytes != null) {
            sb.append("sizeGibibytes:");
            sb.append(this.sizeGibibytes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PhysicalDisksNestedImpl<N>
    extends RootDeviceHintsFluentImpl<SoftwareRAIDVolumeFluent.PhysicalDisksNested<N>>
    implements SoftwareRAIDVolumeFluent.PhysicalDisksNested<N>,
    Nested<N> {
        RootDeviceHintsBuilder builder;
        int index;

        PhysicalDisksNestedImpl(int index, RootDeviceHints item) {
            this.index = index;
            this.builder = new RootDeviceHintsBuilder(this, item);
        }

        PhysicalDisksNestedImpl() {
            this.index = -1;
            this.builder = new RootDeviceHintsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SoftwareRAIDVolumeFluentImpl.this.setToPhysicalDisks(this.index, this.builder.build());
        }

        @Override
        public N endPhysicalDisk() {
            return this.and();
        }
    }
}

