/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPU;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUFluent;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUFluentImpl;

public class CPUBuilder
extends CPUFluentImpl<CPUBuilder>
implements VisitableBuilder<CPU, CPUBuilder> {
    CPUFluent<?> fluent;
    Boolean validationEnabled;

    public CPUBuilder() {
        this(false);
    }

    public CPUBuilder(Boolean validationEnabled) {
        this(new CPU(), validationEnabled);
    }

    public CPUBuilder(CPUFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CPUBuilder(CPUFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CPU(), validationEnabled);
    }

    public CPUBuilder(CPUFluent<?> fluent, CPU instance) {
        this(fluent, instance, false);
    }

    public CPUBuilder(CPUFluent<?> fluent, CPU instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withCores(instance.getCores());
            fluent.withSockets(instance.getSockets());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public CPUBuilder(CPU instance) {
        this(instance, (Boolean)false);
    }

    public CPUBuilder(CPU instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withCores(instance.getCores());
            this.withSockets(instance.getSockets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CPU build() {
        CPU buildable = new CPU(this.fluent.getCores(), this.fluent.getSockets());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

