/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfigFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfigFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ManageDNSConfigFluentImpl<A extends ManageDNSConfigFluent<A>>
extends BaseFluent<A>
implements ManageDNSConfigFluent<A> {
    private ManageDNSAWSConfigBuilder aws;
    private ManageDNSAzureConfigBuilder azure;
    private List<String> domains = new ArrayList<String>();
    private ManageDNSGCPConfigBuilder gcp;
    private Map<String, Object> additionalProperties;

    public ManageDNSConfigFluentImpl() {
    }

    public ManageDNSConfigFluentImpl(ManageDNSConfig instance) {
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withDomains(instance.getDomains());
            this.withGcp(instance.getGcp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public ManageDNSAWSConfig getAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    @Override
    public ManageDNSAWSConfig buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    @Override
    public A withAws(ManageDNSAWSConfig aws) {
        this._visitables.get("aws").remove(this.aws);
        if (aws != null) {
            this.aws = new ManageDNSAWSConfigBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get("aws").remove(this.aws);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAws() {
        return this.aws != null;
    }

    @Override
    public ManageDNSConfigFluent.AwsNested<A> withNewAws() {
        return new AwsNestedImpl();
    }

    @Override
    public ManageDNSConfigFluent.AwsNested<A> withNewAwsLike(ManageDNSAWSConfig item) {
        return new AwsNestedImpl(item);
    }

    @Override
    public ManageDNSConfigFluent.AwsNested<A> editAws() {
        return this.withNewAwsLike(this.getAws());
    }

    @Override
    public ManageDNSConfigFluent.AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(this.getAws() != null ? this.getAws() : new ManageDNSAWSConfigBuilder().build());
    }

    @Override
    public ManageDNSConfigFluent.AwsNested<A> editOrNewAwsLike(ManageDNSAWSConfig item) {
        return this.withNewAwsLike(this.getAws() != null ? this.getAws() : item);
    }

    @Override
    @Deprecated
    public ManageDNSAzureConfig getAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    @Override
    public ManageDNSAzureConfig buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    @Override
    public A withAzure(ManageDNSAzureConfig azure) {
        this._visitables.get("azure").remove(this.azure);
        if (azure != null) {
            this.azure = new ManageDNSAzureConfigBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get("azure").remove(this.azure);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzure() {
        return this.azure != null;
    }

    @Override
    public ManageDNSConfigFluent.AzureNested<A> withNewAzure() {
        return new AzureNestedImpl();
    }

    @Override
    public ManageDNSConfigFluent.AzureNested<A> withNewAzureLike(ManageDNSAzureConfig item) {
        return new AzureNestedImpl(item);
    }

    @Override
    public ManageDNSConfigFluent.AzureNested<A> editAzure() {
        return this.withNewAzureLike(this.getAzure());
    }

    @Override
    public ManageDNSConfigFluent.AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(this.getAzure() != null ? this.getAzure() : new ManageDNSAzureConfigBuilder().build());
    }

    @Override
    public ManageDNSConfigFluent.AzureNested<A> editOrNewAzureLike(ManageDNSAzureConfig item) {
        return this.withNewAzureLike(this.getAzure() != null ? this.getAzure() : item);
    }

    @Override
    public A addToDomains(int index, String item) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDomains(int index, String item) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDomains(String ... items) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        for (String item : items) {
            this.domains.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDomains(Collection<String> items) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        for (String item : items) {
            this.domains.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDomains(String ... items) {
        for (String item : items) {
            if (this.domains == null) continue;
            this.domains.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDomains(Collection<String> items) {
        for (String item : items) {
            if (this.domains == null) continue;
            this.domains.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    public String getDomain(int index) {
        return this.domains.get(index);
    }

    @Override
    public String getFirstDomain() {
        return this.domains.get(0);
    }

    @Override
    public String getLastDomain() {
        return this.domains.get(this.domains.size() - 1);
    }

    @Override
    public String getMatchingDomain(Predicate<String> predicate) {
        for (String item : this.domains) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDomain(Predicate<String> predicate) {
        for (String item : this.domains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDomains(List<String> domains) {
        if (domains != null) {
            this.domains = new ArrayList<String>();
            for (String item : domains) {
                this.addToDomains(item);
            }
        } else {
            this.domains = null;
        }
        return (A)this;
    }

    @Override
    public A withDomains(String ... domains) {
        if (this.domains != null) {
            this.domains.clear();
            this._visitables.remove("domains");
        }
        if (domains != null) {
            for (String item : domains) {
                this.addToDomains(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDomains() {
        return this.domains != null && !this.domains.isEmpty();
    }

    @Override
    @Deprecated
    public ManageDNSGCPConfig getGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    @Override
    public ManageDNSGCPConfig buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    @Override
    public A withGcp(ManageDNSGCPConfig gcp) {
        this._visitables.get("gcp").remove(this.gcp);
        if (gcp != null) {
            this.gcp = new ManageDNSGCPConfigBuilder(gcp);
            this._visitables.get("gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get("gcp").remove(this.gcp);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGcp() {
        return this.gcp != null;
    }

    @Override
    public ManageDNSConfigFluent.GcpNested<A> withNewGcp() {
        return new GcpNestedImpl();
    }

    @Override
    public ManageDNSConfigFluent.GcpNested<A> withNewGcpLike(ManageDNSGCPConfig item) {
        return new GcpNestedImpl(item);
    }

    @Override
    public ManageDNSConfigFluent.GcpNested<A> editGcp() {
        return this.withNewGcpLike(this.getGcp());
    }

    @Override
    public ManageDNSConfigFluent.GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(this.getGcp() != null ? this.getGcp() : new ManageDNSGCPConfigBuilder().build());
    }

    @Override
    public ManageDNSConfigFluent.GcpNested<A> editOrNewGcpLike(ManageDNSGCPConfig item) {
        return this.withNewGcpLike(this.getGcp() != null ? this.getGcp() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManageDNSConfigFluentImpl that = (ManageDNSConfigFluentImpl)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        if (!Objects.equals(this.domains, that.domains)) {
            return false;
        }
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.domains, this.gcp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.domains != null && !this.domains.isEmpty()) {
            sb.append("domains:");
            sb.append(this.domains + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class GcpNestedImpl<N>
    extends ManageDNSGCPConfigFluentImpl<ManageDNSConfigFluent.GcpNested<N>>
    implements ManageDNSConfigFluent.GcpNested<N>,
    Nested<N> {
        ManageDNSGCPConfigBuilder builder;

        GcpNestedImpl(ManageDNSGCPConfig item) {
            this.builder = new ManageDNSGCPConfigBuilder(this, item);
        }

        GcpNestedImpl() {
            this.builder = new ManageDNSGCPConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluentImpl.this.withGcp(this.builder.build());
        }

        @Override
        public N endGcp() {
            return this.and();
        }
    }

    class AzureNestedImpl<N>
    extends ManageDNSAzureConfigFluentImpl<ManageDNSConfigFluent.AzureNested<N>>
    implements ManageDNSConfigFluent.AzureNested<N>,
    Nested<N> {
        ManageDNSAzureConfigBuilder builder;

        AzureNestedImpl(ManageDNSAzureConfig item) {
            this.builder = new ManageDNSAzureConfigBuilder(this, item);
        }

        AzureNestedImpl() {
            this.builder = new ManageDNSAzureConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluentImpl.this.withAzure(this.builder.build());
        }

        @Override
        public N endAzure() {
            return this.and();
        }
    }

    class AwsNestedImpl<N>
    extends ManageDNSAWSConfigFluentImpl<ManageDNSConfigFluent.AwsNested<N>>
    implements ManageDNSConfigFluent.AwsNested<N>,
    Nested<N> {
        ManageDNSAWSConfigBuilder builder;

        AwsNestedImpl(ManageDNSAWSConfig item) {
            this.builder = new ManageDNSAWSConfigBuilder(this, item);
        }

        AwsNestedImpl() {
            this.builder = new ManageDNSAWSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluentImpl.this.withAws(this.builder.build());
        }

        @Override
        public N endAws() {
            return this.and();
        }
    }
}

