/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R>
implements RollableScalableResource<T>,
TimeoutImageEditReplacePatchable<T> {
    protected final PodOperationContext rollingOperationContext;

    protected RollableScalableResourceOperation(PodOperationContext context, OperationContext superContext, Class<T> type, Class<L> listType) {
        super(superContext, type, listType);
        this.rollingOperationContext = context;
    }

    protected abstract RollingUpdater<T, L> getRollingUpdater(long var1, TimeUnit var3);

    @Override
    public T edit(UnaryOperator<T> function) {
        RollingUpdater<HasMetadata, L> rollingUpdater = this.getRollingUpdater(this.context.getTimeout(), this.context.getTimeoutUnit());
        if (!this.rollingOperationContext.isRolling() || rollingUpdater == null) {
            return (T)super.edit((UnaryOperator)function);
        }
        Object oldObj = this.getItemOrRequireFromServer();
        HasMetadata newObj = (HasMetadata)function.apply(this.getKubernetesSerialization().clone(oldObj));
        return (T)rollingUpdater.rollUpdate((HasMetadata)oldObj, newObj);
    }

    public abstract RollableScalableResourceOperation<T, L, R> newInstance(PodOperationContext var1, OperationContext var2);

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    public Loggable withReadyWaitTimeout(Integer timeout) {
        return this.newInstance(this.rollingOperationContext.withReadyWaitTimeout(timeout), this.context);
    }

    public Loggable inContainer(String id) {
        return this.newInstance(this.rollingOperationContext.withContainerId(id), this.context);
    }

    public TimeoutImageEditReplacePatchable<T> rolling() {
        return this.newInstance(this.rollingOperationContext.toBuilder().rolling(true).build(), this.context);
    }

    public String getLog() {
        return this.getLog(this.rollingOperationContext.isPrettyOutput());
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public T updateImage(String image) {
        Object value = this.get();
        if (value == null) {
            throw new KubernetesClientException("Resource doesn't exist");
        }
        List<Container> containers = this.getContainers(value);
        if (containers.size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (containers.isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = containers.iterator().next();
        return (T)this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    protected abstract List<Container> getContainers(T var1);

    public T updateImage(Map<String, String> containerToImageMap) {
        Object value = this.get();
        if (value == null) {
            throw new KubernetesClientException("Resource doesn't exist");
        }
        HasMetadata base = (HasMetadata)this.getKubernetesSerialization().clone(value);
        List<Container> containers = this.getContainers(value);
        if (containers.isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        return (T)this.sendPatchedObject(base, value);
    }

    protected T sendPatchedObject(T oldObject, T updatedObject) {
        return this.patch(null, oldObject, updatedObject);
    }

    @Override
    public RollableScalableResourceOperation<T, L, R> withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance(this.rollingOperationContext, this.context.withTimeout(timeout, unit));
    }

    public RollableScalableResourceOperation<T, L, R> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public T pause() {
        throw new KubernetesClientException(this.context.getPlural() + " pausing is not supported");
    }

    public T resume() {
        throw new KubernetesClientException(this.context.getPlural() + " resuming is not supported");
    }

    public T restart() {
        throw new KubernetesClientException(this.context.getPlural() + " restarting is not supported");
    }

    public T undo() {
        throw new KubernetesClientException(this.context.getPlural() + " undo is not supported");
    }
}

