package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSINodeDriverBuilder extends CSINodeDriverFluentImpl<CSINodeDriverBuilder> implements VisitableBuilder<CSINodeDriver,CSINodeDriverBuilder>{

    CSINodeDriverFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeDriverBuilder(){
            this(true);
    }
    public CSINodeDriverBuilder(Boolean validationEnabled){
            this(new CSINodeDriver(), validationEnabled);
    }
    public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent){
            this(fluent, true);
    }
    public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CSINodeDriver(), validationEnabled);
    }
    public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,CSINodeDriver instance){
            this(fluent, instance, true);
    }
    public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,CSINodeDriver instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllocatable(instance.getAllocatable()); 
            fluent.withName(instance.getName()); 
            fluent.withNodeID(instance.getNodeID()); 
            fluent.withTopologyKeys(instance.getTopologyKeys()); 
            this.validationEnabled = validationEnabled; 
    }
    public CSINodeDriverBuilder(CSINodeDriver instance){
            this(instance,true);
    }
    public CSINodeDriverBuilder(CSINodeDriver instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllocatable(instance.getAllocatable()); 
            this.withName(instance.getName()); 
            this.withNodeID(instance.getNodeID()); 
            this.withTopologyKeys(instance.getTopologyKeys()); 
            this.validationEnabled = validationEnabled; 
    }

    public CSINodeDriver build(){
            CSINodeDriver buildable = new CSINodeDriver(fluent.getAllocatable(),fluent.getName(),fluent.getNodeID(),fluent.getTopologyKeys());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CSINodeDriverBuilder that = (CSINodeDriverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
