package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface LeaseListFluent<A extends LeaseListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Lease item);
    public A setToItems(int index,Lease item);
    public A addToItems(Lease... items);
    public A addAllToItems(Collection<Lease> items);
    public A removeFromItems(Lease... items);
    public A removeAllFromItems(Collection<Lease> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<LeaseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Lease> getItems();
    public List<Lease> buildItems();
    public Lease buildItem(int index);
    public Lease buildFirstItem();
    public Lease buildLastItem();
    public Lease buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<LeaseBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<LeaseBuilder> predicate);
    public A withItems(List<Lease> items);
    public A withItems(Lease... items);
    public Boolean hasItems();
    public LeaseListFluent.ItemsNested<A> addNewItem();
    public LeaseListFluent.ItemsNested<A> addNewItemLike(Lease item);
    public LeaseListFluent.ItemsNested<A> setNewItemLike(int index,Lease item);
    public LeaseListFluent.ItemsNested<A> editItem(int index);
    public LeaseListFluent.ItemsNested<A> editFirstItem();
    public LeaseListFluent.ItemsNested<A> editLastItem();
    public LeaseListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<LeaseBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public LeaseListFluent.MetadataNested<A> withNewMetadata();
    public LeaseListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public LeaseListFluent.MetadataNested<A> editMetadata();
    public LeaseListFluent.MetadataNested<A> editOrNewMetadata();
    public LeaseListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LeaseFluent<LeaseListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<LeaseListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
