package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NamespaceStatusFluent<A extends NamespaceStatusFluent<A>> extends Fluent<A>{


    public A addToConditions(int index,NamespaceCondition item);
    public A setToConditions(int index,NamespaceCondition item);
    public A addToConditions(NamespaceCondition... items);
    public A addAllToConditions(Collection<NamespaceCondition> items);
    public A removeFromConditions(NamespaceCondition... items);
    public A removeAllFromConditions(Collection<NamespaceCondition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<NamespaceConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<NamespaceCondition> getConditions();
    public List<NamespaceCondition> buildConditions();
    public NamespaceCondition buildCondition(int index);
    public NamespaceCondition buildFirstCondition();
    public NamespaceCondition buildLastCondition();
    public NamespaceCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<NamespaceConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<NamespaceConditionBuilder> predicate);
    public A withConditions(List<NamespaceCondition> conditions);
    public A withConditions(NamespaceCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public NamespaceStatusFluent.ConditionsNested<A> addNewCondition();
    public NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(NamespaceCondition item);
    public NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,NamespaceCondition item);
    public NamespaceStatusFluent.ConditionsNested<A> editCondition(int index);
    public NamespaceStatusFluent.ConditionsNested<A> editFirstCondition();
    public NamespaceStatusFluent.ConditionsNested<A> editLastCondition();
    public NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<NamespaceConditionBuilder> predicate);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceConditionFluent<NamespaceStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
