package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeSchemaBuilder extends KubeSchemaFluentImpl<KubeSchemaBuilder> implements VisitableBuilder<KubeSchema,KubeSchemaBuilder>{

    KubeSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchemaBuilder(){
            this(true);
    }
    public KubeSchemaBuilder(Boolean validationEnabled){
            this(new KubeSchema(), validationEnabled);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubeSchema(), validationEnabled);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance){
            this(fluent, instance, true);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAPIGroup(instance.getAPIGroup()); 
            fluent.withAPIGroupList(instance.getAPIGroupList()); 
            fluent.withAdmissionRequest(instance.getAdmissionRequest()); 
            fluent.withAdmissionResponse(instance.getAdmissionResponse()); 
            fluent.withAdmissionReview(instance.getAdmissionReview()); 
            fluent.withAggregationRule(instance.getAggregationRule()); 
            fluent.withBaseKubernetesList(instance.getBaseKubernetesList()); 
            fluent.withBinding(instance.getBinding()); 
            fluent.withBuildConfigList(instance.getBuildConfigList()); 
            fluent.withBuildList(instance.getBuildList()); 
            fluent.withBuildRequest(instance.getBuildRequest()); 
            fluent.withCSIDriver(instance.getCSIDriver()); 
            fluent.withCSIDriverList(instance.getCSIDriverList()); 
            fluent.withCSINode(instance.getCSINode()); 
            fluent.withCSINodeList(instance.getCSINodeList()); 
            fluent.withCertificateSigningRequest(instance.getCertificateSigningRequest()); 
            fluent.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition()); 
            fluent.withCertificateSigningRequestList(instance.getCertificateSigningRequestList()); 
            fluent.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec()); 
            fluent.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus()); 
            fluent.withClusterRole(instance.getClusterRole()); 
            fluent.withClusterRoleBinding(instance.getClusterRoleBinding()); 
            fluent.withClusterRoleBindingList(instance.getClusterRoleBindingList()); 
            fluent.withClusterRoleList(instance.getClusterRoleList()); 
            fluent.withComponentStatusList(instance.getComponentStatusList()); 
            fluent.withConfig(instance.getConfig()); 
            fluent.withConfigMap(instance.getConfigMap()); 
            fluent.withConfigMapList(instance.getConfigMapList()); 
            fluent.withContainerStatus(instance.getContainerStatus()); 
            fluent.withControllerRevision(instance.getControllerRevision()); 
            fluent.withControllerRevisionList(instance.getControllerRevisionList()); 
            fluent.withCreateOptions(instance.getCreateOptions()); 
            fluent.withCronJob(instance.getCronJob()); 
            fluent.withCronJobList(instance.getCronJobList()); 
            fluent.withCustomResourceDefinition(instance.getCustomResourceDefinition()); 
            fluent.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition()); 
            fluent.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList()); 
            fluent.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames()); 
            fluent.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec()); 
            fluent.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus()); 
            fluent.withDaemonSet(instance.getDaemonSet()); 
            fluent.withDaemonSetList(instance.getDaemonSetList()); 
            fluent.withDeleteOptions(instance.getDeleteOptions()); 
            fluent.withDeployment(instance.getDeployment()); 
            fluent.withDeploymentConfig(instance.getDeploymentConfig()); 
            fluent.withDeploymentConfigList(instance.getDeploymentConfigList()); 
            fluent.withDeploymentList(instance.getDeploymentList()); 
            fluent.withDeploymentRollback(instance.getDeploymentRollback()); 
            fluent.withDiscoveryEndpointPort(instance.getDiscoveryEndpointPort()); 
            fluent.withEndpointPort(instance.getEndpointPort()); 
            fluent.withEndpointSlice(instance.getEndpointSlice()); 
            fluent.withEndpointSliceList(instance.getEndpointSliceList()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withEndpointsList(instance.getEndpointsList()); 
            fluent.withEnvVar(instance.getEnvVar()); 
            fluent.withEvent(instance.getEvent()); 
            fluent.withEventList(instance.getEventList()); 
            fluent.withEventSeries(instance.getEventSeries()); 
            fluent.withEventSeriesState(instance.getEventSeriesState()); 
            fluent.withGetOptions(instance.getGetOptions()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withGroupList(instance.getGroupList()); 
            fluent.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler()); 
            fluent.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList()); 
            fluent.withHorizontalPodAutoscalerSpec(instance.getHorizontalPodAutoscalerSpec()); 
            fluent.withIdentity(instance.getIdentity()); 
            fluent.withIdentityList(instance.getIdentityList()); 
            fluent.withImageList(instance.getImageList()); 
            fluent.withImageStreamImport(instance.getImageStreamImport()); 
            fluent.withImageStreamList(instance.getImageStreamList()); 
            fluent.withImageStreamTagList(instance.getImageStreamTagList()); 
            fluent.withInfo(instance.getInfo()); 
            fluent.withIngress(instance.getIngress()); 
            fluent.withIngressList(instance.getIngressList()); 
            fluent.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray()); 
            fluent.withJob(instance.getJob()); 
            fluent.withJobList(instance.getJobList()); 
            fluent.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview()); 
            fluent.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview()); 
            fluent.withKubernetesRunAsUserStrategyOptions(instance.getKubernetesRunAsUserStrategyOptions()); 
            fluent.withLease(instance.getLease()); 
            fluent.withLeaseList(instance.getLeaseList()); 
            fluent.withLimitRangeList(instance.getLimitRangeList()); 
            fluent.withListOptions(instance.getListOptions()); 
            fluent.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview()); 
            fluent.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration()); 
            fluent.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withNamespaceList(instance.getNamespaceList()); 
            fluent.withNetNamespace(instance.getNetNamespace()); 
            fluent.withNetNamespaceList(instance.getNetNamespaceList()); 
            fluent.withNetworkPolicy(instance.getNetworkPolicy()); 
            fluent.withNetworkPolicyList(instance.getNetworkPolicyList()); 
            fluent.withNode(instance.getNode()); 
            fluent.withNodeList(instance.getNodeList()); 
            fluent.withNodeMetrics(instance.getNodeMetrics()); 
            fluent.withNodeMetricsList(instance.getNodeMetricsList()); 
            fluent.withOAuthAccessToken(instance.getOAuthAccessToken()); 
            fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); 
            fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); 
            fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); 
            fluent.withOAuthClient(instance.getOAuthClient()); 
            fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); 
            fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); 
            fluent.withOAuthClientList(instance.getOAuthClientList()); 
            fluent.withObjectMeta(instance.getObjectMeta()); 
            fluent.withOpenshiftClusterRole(instance.getOpenshiftClusterRole()); 
            fluent.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding()); 
            fluent.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList()); 
            fluent.withOpenshiftClusterRoleScopeRestriction(instance.getOpenshiftClusterRoleScopeRestriction()); 
            fluent.withOpenshiftRole(instance.getOpenshiftRole()); 
            fluent.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding()); 
            fluent.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList()); 
            fluent.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction()); 
            fluent.withOpenshiftRoleBindingRestrictionSpec(instance.getOpenshiftRoleBindingRestrictionSpec()); 
            fluent.withOpenshiftRoleList(instance.getOpenshiftRoleList()); 
            fluent.withOperation(instance.getOperation()); 
            fluent.withPatch(instance.getPatch()); 
            fluent.withPatchOptions(instance.getPatchOptions()); 
            fluent.withPatchType(instance.getPatchType()); 
            fluent.withPersistentVolume(instance.getPersistentVolume()); 
            fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
            fluent.withPersistentVolumeList(instance.getPersistentVolumeList()); 
            fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget()); 
            fluent.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList()); 
            fluent.withPodList(instance.getPodList()); 
            fluent.withPodMetrics(instance.getPodMetrics()); 
            fluent.withPodMetricsList(instance.getPodMetricsList()); 
            fluent.withPodPreset(instance.getPodPreset()); 
            fluent.withPodPresetList(instance.getPodPresetList()); 
            fluent.withPodPresetSpec(instance.getPodPresetSpec()); 
            fluent.withPodSecurityPolicy(instance.getPodSecurityPolicy()); 
            fluent.withPodSecurityPolicyList(instance.getPodSecurityPolicyList()); 
            fluent.withPodTemplateList(instance.getPodTemplateList()); 
            fluent.withPriorityClass(instance.getPriorityClass()); 
            fluent.withPriorityClassList(instance.getPriorityClassList()); 
            fluent.withProject(instance.getProject()); 
            fluent.withProjectList(instance.getProjectList()); 
            fluent.withProjectRequest(instance.getProjectRequest()); 
            fluent.withQuantity(instance.getQuantity()); 
            fluent.withReplicaSet(instance.getReplicaSet()); 
            fluent.withReplicaSetList(instance.getReplicaSetList()); 
            fluent.withReplicationControllerList(instance.getReplicationControllerList()); 
            fluent.withResourceQuota(instance.getResourceQuota()); 
            fluent.withResourceQuotaList(instance.getResourceQuotaList()); 
            fluent.withRole(instance.getRole()); 
            fluent.withRoleBinding(instance.getRoleBinding()); 
            fluent.withRoleBindingList(instance.getRoleBindingList()); 
            fluent.withRoleList(instance.getRoleList()); 
            fluent.withRootPaths(instance.getRootPaths()); 
            fluent.withRoute(instance.getRoute()); 
            fluent.withRouteList(instance.getRouteList()); 
            fluent.withRule(instance.getRule()); 
            fluent.withRuleWithOperations(instance.getRuleWithOperations()); 
            fluent.withScale(instance.getScale()); 
            fluent.withSecret(instance.getSecret()); 
            fluent.withSecretList(instance.getSecretList()); 
            fluent.withSecurityContextConstraints(instance.getSecurityContextConstraints()); 
            fluent.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); 
            fluent.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview()); 
            fluent.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withServiceAccountList(instance.getServiceAccountList()); 
            fluent.withServiceList(instance.getServiceList()); 
            fluent.withServiceReference(instance.getServiceReference()); 
            fluent.withStatefulSet(instance.getStatefulSet()); 
            fluent.withStatefulSetList(instance.getStatefulSetList()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withStorageClass(instance.getStorageClass()); 
            fluent.withStorageClassList(instance.getStorageClassList()); 
            fluent.withSubjectAccessReview(instance.getSubjectAccessReview()); 
            fluent.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse()); 
            fluent.withTagEvent(instance.getTagEvent()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withTemplateList(instance.getTemplateList()); 
            fluent.withTime(instance.getTime()); 
            fluent.withTokenReview(instance.getTokenReview()); 
            fluent.withToleration(instance.getToleration()); 
            fluent.withTypeMeta(instance.getTypeMeta()); 
            fluent.withUpdateOptions(instance.getUpdateOptions()); 
            fluent.withUser(instance.getUser()); 
            fluent.withUserList(instance.getUserList()); 
            fluent.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration()); 
            fluent.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList()); 
            fluent.withVolumeAttachment(instance.getVolumeAttachment()); 
            fluent.withVolumeAttachmentList(instance.getVolumeAttachmentList()); 
            fluent.withWatchEvent(instance.getWatchEvent()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubeSchemaBuilder(KubeSchema instance){
            this(instance,true);
    }
    public KubeSchemaBuilder(KubeSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAPIGroup(instance.getAPIGroup()); 
            this.withAPIGroupList(instance.getAPIGroupList()); 
            this.withAdmissionRequest(instance.getAdmissionRequest()); 
            this.withAdmissionResponse(instance.getAdmissionResponse()); 
            this.withAdmissionReview(instance.getAdmissionReview()); 
            this.withAggregationRule(instance.getAggregationRule()); 
            this.withBaseKubernetesList(instance.getBaseKubernetesList()); 
            this.withBinding(instance.getBinding()); 
            this.withBuildConfigList(instance.getBuildConfigList()); 
            this.withBuildList(instance.getBuildList()); 
            this.withBuildRequest(instance.getBuildRequest()); 
            this.withCSIDriver(instance.getCSIDriver()); 
            this.withCSIDriverList(instance.getCSIDriverList()); 
            this.withCSINode(instance.getCSINode()); 
            this.withCSINodeList(instance.getCSINodeList()); 
            this.withCertificateSigningRequest(instance.getCertificateSigningRequest()); 
            this.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition()); 
            this.withCertificateSigningRequestList(instance.getCertificateSigningRequestList()); 
            this.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec()); 
            this.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus()); 
            this.withClusterRole(instance.getClusterRole()); 
            this.withClusterRoleBinding(instance.getClusterRoleBinding()); 
            this.withClusterRoleBindingList(instance.getClusterRoleBindingList()); 
            this.withClusterRoleList(instance.getClusterRoleList()); 
            this.withComponentStatusList(instance.getComponentStatusList()); 
            this.withConfig(instance.getConfig()); 
            this.withConfigMap(instance.getConfigMap()); 
            this.withConfigMapList(instance.getConfigMapList()); 
            this.withContainerStatus(instance.getContainerStatus()); 
            this.withControllerRevision(instance.getControllerRevision()); 
            this.withControllerRevisionList(instance.getControllerRevisionList()); 
            this.withCreateOptions(instance.getCreateOptions()); 
            this.withCronJob(instance.getCronJob()); 
            this.withCronJobList(instance.getCronJobList()); 
            this.withCustomResourceDefinition(instance.getCustomResourceDefinition()); 
            this.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition()); 
            this.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList()); 
            this.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames()); 
            this.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec()); 
            this.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus()); 
            this.withDaemonSet(instance.getDaemonSet()); 
            this.withDaemonSetList(instance.getDaemonSetList()); 
            this.withDeleteOptions(instance.getDeleteOptions()); 
            this.withDeployment(instance.getDeployment()); 
            this.withDeploymentConfig(instance.getDeploymentConfig()); 
            this.withDeploymentConfigList(instance.getDeploymentConfigList()); 
            this.withDeploymentList(instance.getDeploymentList()); 
            this.withDeploymentRollback(instance.getDeploymentRollback()); 
            this.withDiscoveryEndpointPort(instance.getDiscoveryEndpointPort()); 
            this.withEndpointPort(instance.getEndpointPort()); 
            this.withEndpointSlice(instance.getEndpointSlice()); 
            this.withEndpointSliceList(instance.getEndpointSliceList()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withEndpointsList(instance.getEndpointsList()); 
            this.withEnvVar(instance.getEnvVar()); 
            this.withEvent(instance.getEvent()); 
            this.withEventList(instance.getEventList()); 
            this.withEventSeries(instance.getEventSeries()); 
            this.withEventSeriesState(instance.getEventSeriesState()); 
            this.withGetOptions(instance.getGetOptions()); 
            this.withGroup(instance.getGroup()); 
            this.withGroupList(instance.getGroupList()); 
            this.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler()); 
            this.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList()); 
            this.withHorizontalPodAutoscalerSpec(instance.getHorizontalPodAutoscalerSpec()); 
            this.withIdentity(instance.getIdentity()); 
            this.withIdentityList(instance.getIdentityList()); 
            this.withImageList(instance.getImageList()); 
            this.withImageStreamImport(instance.getImageStreamImport()); 
            this.withImageStreamList(instance.getImageStreamList()); 
            this.withImageStreamTagList(instance.getImageStreamTagList()); 
            this.withInfo(instance.getInfo()); 
            this.withIngress(instance.getIngress()); 
            this.withIngressList(instance.getIngressList()); 
            this.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray()); 
            this.withJob(instance.getJob()); 
            this.withJobList(instance.getJobList()); 
            this.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview()); 
            this.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview()); 
            this.withKubernetesRunAsUserStrategyOptions(instance.getKubernetesRunAsUserStrategyOptions()); 
            this.withLease(instance.getLease()); 
            this.withLeaseList(instance.getLeaseList()); 
            this.withLimitRangeList(instance.getLimitRangeList()); 
            this.withListOptions(instance.getListOptions()); 
            this.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview()); 
            this.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration()); 
            this.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList()); 
            this.withNamespace(instance.getNamespace()); 
            this.withNamespaceList(instance.getNamespaceList()); 
            this.withNetNamespace(instance.getNetNamespace()); 
            this.withNetNamespaceList(instance.getNetNamespaceList()); 
            this.withNetworkPolicy(instance.getNetworkPolicy()); 
            this.withNetworkPolicyList(instance.getNetworkPolicyList()); 
            this.withNode(instance.getNode()); 
            this.withNodeList(instance.getNodeList()); 
            this.withNodeMetrics(instance.getNodeMetrics()); 
            this.withNodeMetricsList(instance.getNodeMetricsList()); 
            this.withOAuthAccessToken(instance.getOAuthAccessToken()); 
            this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); 
            this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); 
            this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); 
            this.withOAuthClient(instance.getOAuthClient()); 
            this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); 
            this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); 
            this.withOAuthClientList(instance.getOAuthClientList()); 
            this.withObjectMeta(instance.getObjectMeta()); 
            this.withOpenshiftClusterRole(instance.getOpenshiftClusterRole()); 
            this.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding()); 
            this.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList()); 
            this.withOpenshiftClusterRoleScopeRestriction(instance.getOpenshiftClusterRoleScopeRestriction()); 
            this.withOpenshiftRole(instance.getOpenshiftRole()); 
            this.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding()); 
            this.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList()); 
            this.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction()); 
            this.withOpenshiftRoleBindingRestrictionSpec(instance.getOpenshiftRoleBindingRestrictionSpec()); 
            this.withOpenshiftRoleList(instance.getOpenshiftRoleList()); 
            this.withOperation(instance.getOperation()); 
            this.withPatch(instance.getPatch()); 
            this.withPatchOptions(instance.getPatchOptions()); 
            this.withPatchType(instance.getPatchType()); 
            this.withPersistentVolume(instance.getPersistentVolume()); 
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
            this.withPersistentVolumeList(instance.getPersistentVolumeList()); 
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget()); 
            this.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList()); 
            this.withPodList(instance.getPodList()); 
            this.withPodMetrics(instance.getPodMetrics()); 
            this.withPodMetricsList(instance.getPodMetricsList()); 
            this.withPodPreset(instance.getPodPreset()); 
            this.withPodPresetList(instance.getPodPresetList()); 
            this.withPodPresetSpec(instance.getPodPresetSpec()); 
            this.withPodSecurityPolicy(instance.getPodSecurityPolicy()); 
            this.withPodSecurityPolicyList(instance.getPodSecurityPolicyList()); 
            this.withPodTemplateList(instance.getPodTemplateList()); 
            this.withPriorityClass(instance.getPriorityClass()); 
            this.withPriorityClassList(instance.getPriorityClassList()); 
            this.withProject(instance.getProject()); 
            this.withProjectList(instance.getProjectList()); 
            this.withProjectRequest(instance.getProjectRequest()); 
            this.withQuantity(instance.getQuantity()); 
            this.withReplicaSet(instance.getReplicaSet()); 
            this.withReplicaSetList(instance.getReplicaSetList()); 
            this.withReplicationControllerList(instance.getReplicationControllerList()); 
            this.withResourceQuota(instance.getResourceQuota()); 
            this.withResourceQuotaList(instance.getResourceQuotaList()); 
            this.withRole(instance.getRole()); 
            this.withRoleBinding(instance.getRoleBinding()); 
            this.withRoleBindingList(instance.getRoleBindingList()); 
            this.withRoleList(instance.getRoleList()); 
            this.withRootPaths(instance.getRootPaths()); 
            this.withRoute(instance.getRoute()); 
            this.withRouteList(instance.getRouteList()); 
            this.withRule(instance.getRule()); 
            this.withRuleWithOperations(instance.getRuleWithOperations()); 
            this.withScale(instance.getScale()); 
            this.withSecret(instance.getSecret()); 
            this.withSecretList(instance.getSecretList()); 
            this.withSecurityContextConstraints(instance.getSecurityContextConstraints()); 
            this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); 
            this.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview()); 
            this.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccountList(instance.getServiceAccountList()); 
            this.withServiceList(instance.getServiceList()); 
            this.withServiceReference(instance.getServiceReference()); 
            this.withStatefulSet(instance.getStatefulSet()); 
            this.withStatefulSetList(instance.getStatefulSetList()); 
            this.withStatus(instance.getStatus()); 
            this.withStorageClass(instance.getStorageClass()); 
            this.withStorageClassList(instance.getStorageClassList()); 
            this.withSubjectAccessReview(instance.getSubjectAccessReview()); 
            this.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse()); 
            this.withTagEvent(instance.getTagEvent()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTemplateList(instance.getTemplateList()); 
            this.withTime(instance.getTime()); 
            this.withTokenReview(instance.getTokenReview()); 
            this.withToleration(instance.getToleration()); 
            this.withTypeMeta(instance.getTypeMeta()); 
            this.withUpdateOptions(instance.getUpdateOptions()); 
            this.withUser(instance.getUser()); 
            this.withUserList(instance.getUserList()); 
            this.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration()); 
            this.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList()); 
            this.withVolumeAttachment(instance.getVolumeAttachment()); 
            this.withVolumeAttachmentList(instance.getVolumeAttachmentList()); 
            this.withWatchEvent(instance.getWatchEvent()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubeSchema build(){
            KubeSchema buildable = new KubeSchema(fluent.getAPIGroup(),fluent.getAPIGroupList(),fluent.getAdmissionRequest(),fluent.getAdmissionResponse(),fluent.getAdmissionReview(),fluent.getAggregationRule(),fluent.getBaseKubernetesList(),fluent.getBinding(),fluent.getBuildConfigList(),fluent.getBuildList(),fluent.getBuildRequest(),fluent.getCSIDriver(),fluent.getCSIDriverList(),fluent.getCSINode(),fluent.getCSINodeList(),fluent.getCertificateSigningRequest(),fluent.getCertificateSigningRequestCondition(),fluent.getCertificateSigningRequestList(),fluent.getCertificateSigningRequestSpec(),fluent.getCertificateSigningRequestStatus(),fluent.getClusterRole(),fluent.getClusterRoleBinding(),fluent.getClusterRoleBindingList(),fluent.getClusterRoleList(),fluent.getComponentStatusList(),fluent.getConfig(),fluent.getConfigMap(),fluent.getConfigMapList(),fluent.getContainerStatus(),fluent.getControllerRevision(),fluent.getControllerRevisionList(),fluent.getCreateOptions(),fluent.getCronJob(),fluent.getCronJobList(),fluent.getCustomResourceDefinition(),fluent.getCustomResourceDefinitionCondition(),fluent.getCustomResourceDefinitionList(),fluent.getCustomResourceDefinitionNames(),fluent.getCustomResourceDefinitionSpec(),fluent.getCustomResourceDefinitionStatus(),fluent.getDaemonSet(),fluent.getDaemonSetList(),fluent.getDeleteOptions(),fluent.getDeployment(),fluent.getDeploymentConfig(),fluent.getDeploymentConfigList(),fluent.getDeploymentList(),fluent.getDeploymentRollback(),fluent.getDiscoveryEndpointPort(),fluent.getEndpointPort(),fluent.getEndpointSlice(),fluent.getEndpointSliceList(),fluent.getEndpoints(),fluent.getEndpointsList(),fluent.getEnvVar(),fluent.getEvent(),fluent.getEventList(),fluent.getEventSeries(),fluent.getEventSeriesState(),fluent.getGetOptions(),fluent.getGroup(),fluent.getGroupList(),fluent.getHorizontalPodAutoscaler(),fluent.getHorizontalPodAutoscalerList(),fluent.getHorizontalPodAutoscalerSpec(),fluent.getIdentity(),fluent.getIdentityList(),fluent.getImageList(),fluent.getImageStreamImport(),fluent.getImageStreamList(),fluent.getImageStreamTagList(),fluent.getInfo(),fluent.getIngress(),fluent.getIngressList(),fluent.getJSONSchemaPropsorStringArray(),fluent.getJob(),fluent.getJobList(),fluent.getK8sLocalSubjectAccessReview(),fluent.getK8sSubjectAccessReview(),fluent.getKubernetesRunAsUserStrategyOptions(),fluent.getLease(),fluent.getLeaseList(),fluent.getLimitRangeList(),fluent.getListOptions(),fluent.getLocalSubjectAccessReview(),fluent.getMutatingWebhookConfiguration(),fluent.getMutatingWebhookConfigurationList(),fluent.getNamespace(),fluent.getNamespaceList(),fluent.getNetNamespace(),fluent.getNetNamespaceList(),fluent.getNetworkPolicy(),fluent.getNetworkPolicyList(),fluent.getNode(),fluent.getNodeList(),fluent.getNodeMetrics(),fluent.getNodeMetricsList(),fluent.getOAuthAccessToken(),fluent.getOAuthAccessTokenList(),fluent.getOAuthAuthorizeToken(),fluent.getOAuthAuthorizeTokenList(),fluent.getOAuthClient(),fluent.getOAuthClientAuthorization(),fluent.getOAuthClientAuthorizationList(),fluent.getOAuthClientList(),fluent.getObjectMeta(),fluent.getOpenshiftClusterRole(),fluent.getOpenshiftClusterRoleBinding(),fluent.getOpenshiftClusterRoleBindingList(),fluent.getOpenshiftClusterRoleScopeRestriction(),fluent.getOpenshiftRole(),fluent.getOpenshiftRoleBinding(),fluent.getOpenshiftRoleBindingList(),fluent.getOpenshiftRoleBindingRestriction(),fluent.getOpenshiftRoleBindingRestrictionSpec(),fluent.getOpenshiftRoleList(),fluent.getOperation(),fluent.getPatch(),fluent.getPatchOptions(),fluent.getPatchType(),fluent.getPersistentVolume(),fluent.getPersistentVolumeClaim(),fluent.getPersistentVolumeClaimList(),fluent.getPersistentVolumeList(),fluent.getPodDisruptionBudget(),fluent.getPodDisruptionBudgetList(),fluent.getPodList(),fluent.getPodMetrics(),fluent.getPodMetricsList(),fluent.getPodPreset(),fluent.getPodPresetList(),fluent.getPodPresetSpec(),fluent.getPodSecurityPolicy(),fluent.getPodSecurityPolicyList(),fluent.getPodTemplateList(),fluent.getPriorityClass(),fluent.getPriorityClassList(),fluent.getProject(),fluent.getProjectList(),fluent.getProjectRequest(),fluent.getQuantity(),fluent.getReplicaSet(),fluent.getReplicaSetList(),fluent.getReplicationControllerList(),fluent.getResourceQuota(),fluent.getResourceQuotaList(),fluent.getRole(),fluent.getRoleBinding(),fluent.getRoleBindingList(),fluent.getRoleList(),fluent.getRootPaths(),fluent.getRoute(),fluent.getRouteList(),fluent.getRule(),fluent.getRuleWithOperations(),fluent.getScale(),fluent.getSecret(),fluent.getSecretList(),fluent.getSecurityContextConstraints(),fluent.getSecurityContextConstraintsList(),fluent.getSelfSubjectAccessReview(),fluent.getSelfSubjectRulesReview(),fluent.getServiceAccount(),fluent.getServiceAccountList(),fluent.getServiceList(),fluent.getServiceReference(),fluent.getStatefulSet(),fluent.getStatefulSetList(),fluent.getStatus(),fluent.getStorageClass(),fluent.getStorageClassList(),fluent.getSubjectAccessReview(),fluent.getSubjectAccessReviewResponse(),fluent.getTagEvent(),fluent.getTemplate(),fluent.getTemplateList(),fluent.getTime(),fluent.getTokenReview(),fluent.getToleration(),fluent.getTypeMeta(),fluent.getUpdateOptions(),fluent.getUser(),fluent.getUserList(),fluent.getValidatingWebhookConfiguration(),fluent.getValidatingWebhookConfigurationList(),fluent.getVolumeAttachment(),fluent.getVolumeAttachmentList(),fluent.getWatchEvent());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubeSchemaBuilder that = (KubeSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
