package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LeaseSpecBuilder extends LeaseSpecFluentImpl<LeaseSpecBuilder> implements VisitableBuilder<LeaseSpec,LeaseSpecBuilder>{

    LeaseSpecFluent<?> fluent;
    Boolean validationEnabled;

    public LeaseSpecBuilder(){
            this(true);
    }
    public LeaseSpecBuilder(Boolean validationEnabled){
            this(new LeaseSpec(), validationEnabled);
    }
    public LeaseSpecBuilder(LeaseSpecFluent<?> fluent){
            this(fluent, true);
    }
    public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LeaseSpec(), validationEnabled);
    }
    public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,LeaseSpec instance){
            this(fluent, instance, true);
    }
    public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,LeaseSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAcquireTime(instance.getAcquireTime()); 
            fluent.withHolderIdentity(instance.getHolderIdentity()); 
            fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
            fluent.withLeaseTransitions(instance.getLeaseTransitions()); 
            fluent.withRenewTime(instance.getRenewTime()); 
            fluent.withAdditionalProperties(instance.getAdditionalProperties());

            this.validationEnabled = validationEnabled; 
    }
    public LeaseSpecBuilder(LeaseSpec instance){
            this(instance,true);
    }
    public LeaseSpecBuilder(LeaseSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAcquireTime(instance.getAcquireTime()); 
            this.withHolderIdentity(instance.getHolderIdentity()); 
            this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
            this.withLeaseTransitions(instance.getLeaseTransitions()); 
            this.withRenewTime(instance.getRenewTime()); 
            this.withAdditionalProperties(instance.getAdditionalProperties());

            this.validationEnabled = validationEnabled; 
    }

    public LeaseSpec build(){
            LeaseSpec buildable = new LeaseSpec(fluent.getAcquireTime(),fluent.getHolderIdentity(),fluent.getLeaseDurationSeconds(),fluent.getLeaseTransitions(),fluent.getRenewTime());
            buildable.setAdditionalProperties(fluent.getAdditionalProperties());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LeaseSpecBuilder that = (LeaseSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
