package io.fabric8.kubernetes.api.model.node.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulingBuilder extends SchedulingFluentImpl<SchedulingBuilder> implements VisitableBuilder<Scheduling,SchedulingBuilder>{
  public SchedulingBuilder() {
    this(false);
  }
  public SchedulingBuilder(Boolean validationEnabled) {
    this(new Scheduling(), validationEnabled);
  }
  public SchedulingBuilder(SchedulingFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulingBuilder(SchedulingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Scheduling(), validationEnabled);
  }
  public SchedulingBuilder(SchedulingFluent<?> fluent,Scheduling instance) {
    this(fluent, instance, false);
  }
  public SchedulingBuilder(SchedulingFluent<?> fluent,Scheduling instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SchedulingBuilder(Scheduling instance) {
    this(instance,false);
  }
  public SchedulingBuilder(Scheduling instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SchedulingFluent<?> fluent;
  Boolean validationEnabled;
  public Scheduling build() {
    Scheduling buildable = new Scheduling(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}