package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class IngressSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder backend;
    private String ingressClassName;
    private List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> rules =  new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>();
    private List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> tls =  new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>();

    public IngressSpecFluentImpl() { 
    }


    public IngressSpecFluentImpl(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec instance) { 
        this.withBackend(instance.getBackend()); 
        this.withIngressClassName(instance.getIngressClassName()); 
        this.withRules(instance.getRules()); 
        this.withTls(instance.getTls()); 
    }


    
/**
 * This method has been deprecated, please use method buildBackend instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend getBackend() {
        return this.backend!=null?this.backend.build():null;
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend buildBackend() {
        return this.backend!=null?this.backend.build():null;
    }

    public A withBackend(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend backend) {
        _visitables.get("backend").remove(this.backend);
        if (backend!=null){ this.backend= new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} return (A) this;
    }

    public Boolean hasBackend() {
        return this.backend != null;
    }

    public IngressSpecFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    public IngressSpecFluent.BackendNested<A> withNewBackendLike(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    public IngressSpecFluent.BackendNested<A> editBackend() {
        return withNewBackendLike(getBackend());
    }

    public IngressSpecFluent.BackendNested<A> editOrNewBackend() {
        return withNewBackendLike(getBackend() != null ? getBackend(): new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder().build());
    }

    public IngressSpecFluent.BackendNested<A> editOrNewBackendLike(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend item) {
        return withNewBackendLike(getBackend() != null ? getBackend(): item);
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName=ingressClassName; return (A) this;
    }

    public Boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public A withNewIngressClassName(String arg1) {
        return (A)withIngressClassName(new String(arg1));
    }

    public A withNewIngressClassName(StringBuilder arg1) {
        return (A)withIngressClassName(new String(arg1));
    }

    public A withNewIngressClassName(StringBuffer arg1) {
        return (A)withIngressClassName(new String(arg1));
    }

    public A addToRules(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item) {
        if (this.rules == null) {this.rules = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>();}
        io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item) {
        if (this.rules == null) {this.rules = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>();}
        io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule... items) {
        if (this.rules == null) {this.rules = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule> items) {
        if (this.rules == null) {this.rules = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule... items) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule> items) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule> getRules() {
        return build(rules);
    }

    public List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule> buildRules() {
        return build(rules);
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule buildMatchingRule(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>(); for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public IngressSpecFluent.RulesNested<A> addNewRuleLike(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    public IngressSpecFluent.RulesNested<A> setNewRuleLike(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    public IngressSpecFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public IngressSpecFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public IngressSpecFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public IngressSpecFluent.RulesNested<A> editMatchingRule(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public A addToTls(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item) {
        if (this.tls == null) {this.tls = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>();}
        io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);_visitables.get("tls").add(index >= 0 ? index : _visitables.get("tls").size(), builder);this.tls.add(index >= 0 ? index : tls.size(), builder); return (A)this;
    }

    public A setToTls(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item) {
        if (this.tls == null) {this.tls = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>();}
        io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);
        if (index < 0 || index >= _visitables.get("tls").size()) { _visitables.get("tls").add(builder); } else { _visitables.get("tls").set(index, builder);}
        if (index < 0 || index >= tls.size()) { tls.add(builder); } else { tls.set(index, builder);}
         return (A)this;
    }

    public A addToTls(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS... items) {
        if (this.tls == null) {this.tls = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>();}
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A addAllToTls(Collection<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS> items) {
        if (this.tls == null) {this.tls = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>();}
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A removeFromTls(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS... items) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeAllFromTls(Collection<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS> items) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item : items) {io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTls(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> predicate) {
        if (tls == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> each = tls.iterator();
        final List visitables = _visitables.get("tls");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS> getTls() {
        return build(tls);
    }

    public List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS> buildTls() {
        return build(tls);
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS buildTl(int index) {
        return this.tls.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS buildLastTl() {
        return this.tls.get(tls.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS buildMatchingTl(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder item: tls) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTl(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder item: tls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTls(List<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS> tls) {
        if (this.tls != null) { _visitables.get("tls").removeAll(this.tls);}
        if (tls != null) {this.tls = new ArrayList<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>(); for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
    }

    public A withTls(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS... tls) {
        if (this.tls != null) {this.tls.clear();}
        if (tls != null) {for (io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
    }

    public Boolean hasTls() {
        return tls != null && !tls.isEmpty();
    }

    public IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    public IngressSpecFluent.TlsNested<A> addNewTlLike(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item) {
        return new TlsNestedImpl(-1, item);
    }

    public IngressSpecFluent.TlsNested<A> setNewTlLike(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item) {
        return new TlsNestedImpl(index, item);
    }

    public IngressSpecFluent.TlsNested<A> editTl(int index) {
        if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
        return setNewTlLike(index, buildTl(index));
    }

    public IngressSpecFluent.TlsNested<A> editFirstTl() {
        if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
        return setNewTlLike(0, buildTl(0));
    }

    public IngressSpecFluent.TlsNested<A> editLastTl() {
        int index = tls.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
        return setNewTlLike(index, buildTl(index));
    }

    public IngressSpecFluent.TlsNested<A> editMatchingTl(Predicate<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tls.size();i++) { 
        if (predicate.test(tls.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
        return setNewTlLike(index, buildTl(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
        if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
        if (ingressClassName != null ? !ingressClassName.equals(that.ingressClassName) :that.ingressClassName != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(backend,  ingressClassName,  rules,  tls,  super.hashCode());
    }

    public class BackendNestedImpl<N> extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>> implements IngressSpecFluent.BackendNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder builder;

        BackendNestedImpl(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend item) {
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder(this);
        }

        public N and() {
             return (N) IngressSpecFluentImpl.this.withBackend(builder.build());
        }

        public N endBackend() {
             return and();
        }
    }


    public class RulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>> implements IngressSpecFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder(this);
        }

        public N and() {
             return (N) IngressSpecFluentImpl.this.setToRules(index,builder.build());
        }

        public N endRule() {
             return and();
        }
    }


    public class TlsNestedImpl<N> extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>> implements IngressSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder builder;
        private final int index;

        TlsNestedImpl(int index,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder(this);
        }

        public N and() {
             return (N) IngressSpecFluentImpl.this.setToTls(index,builder.build());
        }

        public N endTl() {
             return and();
        }
    }


}
