package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerMetricsBuilder extends ContainerMetricsFluentImpl<ContainerMetricsBuilder> implements VisitableBuilder<ContainerMetrics,ContainerMetricsBuilder>{
  public ContainerMetricsBuilder() {
    this(false);
  }
  public ContainerMetricsBuilder(Boolean validationEnabled) {
    this(new ContainerMetrics(), validationEnabled);
  }
  public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerMetrics(), validationEnabled);
  }
  public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,ContainerMetrics instance) {
    this(fluent, instance, false);
  }
  public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,ContainerMetrics instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUsage(instance.getUsage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerMetricsBuilder(ContainerMetrics instance) {
    this(instance,false);
  }
  public ContainerMetricsBuilder(ContainerMetrics instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUsage(instance.getUsage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ContainerMetricsFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerMetrics build() {
    ContainerMetrics buildable = new ContainerMetrics(fluent.getName(),fluent.getUsage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}