package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface ContainerMetricsFluent<A extends ContainerMetricsFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToUsage(String key,Quantity value);
    public A addToUsage(Map<String,Quantity> map);
    public A removeFromUsage(String key);
    public A removeFromUsage(Map<String,Quantity> map);
    public Map<String,Quantity> getUsage();
    public A withUsage(Map<String,Quantity> usage);
    public Boolean hasUsage();
}
