package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMetricsBuilder extends PodMetricsFluentImpl<PodMetricsBuilder> implements VisitableBuilder<PodMetrics,PodMetricsBuilder> {

    PodMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public PodMetricsBuilder() { 
        this(true);
    }


    public PodMetricsBuilder(Boolean validationEnabled) { 
        this(new PodMetrics(), validationEnabled);
    }


    public PodMetricsBuilder(PodMetricsFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodMetricsBuilder(PodMetricsFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodMetrics(), validationEnabled);
    }


    public PodMetricsBuilder(PodMetricsFluent<?> fluent,PodMetrics instance) { 
        this(fluent, instance, true);
    }


    public PodMetricsBuilder(PodMetricsFluent<?> fluent,PodMetrics instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withContainers(instance.getContainers()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withTimestamp(instance.getTimestamp()); 
        fluent.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodMetricsBuilder(PodMetrics instance) { 
        this(instance,true);
    }


    public PodMetricsBuilder(PodMetrics instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withContainers(instance.getContainers()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTimestamp(instance.getTimestamp()); 
        this.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodMetrics build() {
        PodMetrics buildable = new PodMetrics(fluent.getApiVersion(),fluent.getContainers(),fluent.getKind(),fluent.getMetadata(),fluent.getTimestamp(),fluent.getWindow());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMetricsBuilder that = (PodMetricsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
