package io.fabric8.kubernetes.api.model.apps;

import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ControllerRevisionFluentImpl<A extends ControllerRevisionFluent<A>> extends BaseFluent<A> implements ControllerRevisionFluent<A>{
  public ControllerRevisionFluentImpl() {
  }
  public ControllerRevisionFluentImpl(ControllerRevision instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withData(instance.getData()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private VisitableBuilder<? extends KubernetesResource,?> data;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Long revision;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildData instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getData() {
    return this.data!=null?this.data.build():null;
  }
  public KubernetesResource buildData() {
    return this.data!=null?this.data.build():null;
  }
  public A withData(KubernetesResource data) {
    if (data instanceof DeploymentList){ this.data= new DeploymentListBuilder((DeploymentList)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSetUpdateStrategy){ this.data= new DaemonSetUpdateStrategyBuilder((DaemonSetUpdateStrategy)data); _visitables.get("data").add(this.data);}
    if (data instanceof ReplicaSet){ this.data= new ReplicaSetBuilder((ReplicaSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof LabelSelector){ this.data= new LabelSelectorBuilder((LabelSelector)data); _visitables.get("data").add(this.data);}
    if (data instanceof Container){ this.data= new ContainerBuilder((Container)data); _visitables.get("data").add(this.data);}
    if (data instanceof GenericKubernetesResource){ this.data= new GenericKubernetesResourceBuilder((GenericKubernetesResource)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetStatus){ this.data= new StatefulSetStatusBuilder((StatefulSetStatus)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetOrdinals){ this.data= new StatefulSetOrdinalsBuilder((StatefulSetOrdinals)data); _visitables.get("data").add(this.data);}
    if (data instanceof RollingUpdateStatefulSetStrategy){ this.data= new RollingUpdateStatefulSetStrategyBuilder((RollingUpdateStatefulSetStrategy)data); _visitables.get("data").add(this.data);}
    if (data instanceof ReplicaSetCondition){ this.data= new ReplicaSetConditionBuilder((ReplicaSetCondition)data); _visitables.get("data").add(this.data);}
    if (data instanceof PodTemplateSpec){ this.data= new PodTemplateSpecBuilder((PodTemplateSpec)data); _visitables.get("data").add(this.data);}
    if (data instanceof LocalObjectReference){ this.data= new LocalObjectReferenceBuilder((LocalObjectReference)data); _visitables.get("data").add(this.data);}
    if (data instanceof ReplicaSetSpec){ this.data= new ReplicaSetSpecBuilder((ReplicaSetSpec)data); _visitables.get("data").add(this.data);}
    if (data instanceof ResourceRequirements){ this.data= new ResourceRequirementsBuilder((ResourceRequirements)data); _visitables.get("data").add(this.data);}
    if (data instanceof RollingUpdateDeployment){ this.data= new RollingUpdateDeploymentBuilder((RollingUpdateDeployment)data); _visitables.get("data").add(this.data);}
    if (data instanceof ControllerRevisionList){ this.data= new ControllerRevisionListBuilder((ControllerRevisionList)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetList){ this.data= new StatefulSetListBuilder((StatefulSetList)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSet){ this.data= new DaemonSetBuilder((DaemonSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof DeploymentSpec){ this.data= new DeploymentSpecBuilder((DeploymentSpec)data); _visitables.get("data").add(this.data);}
    if (data instanceof DeploymentStatus){ this.data= new DeploymentStatusBuilder((DeploymentStatus)data); _visitables.get("data").add(this.data);}
    if (data instanceof ReplicaSetStatus){ this.data= new ReplicaSetStatusBuilder((ReplicaSetStatus)data); _visitables.get("data").add(this.data);}
    if (data instanceof ControllerRevision){ this.data= new ControllerRevisionBuilder((ControllerRevision)data); _visitables.get("data").add(this.data);}
    if (data instanceof DeploymentCondition){ this.data= new DeploymentConditionBuilder((DeploymentCondition)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSetCondition){ this.data= new DaemonSetConditionBuilder((DaemonSetCondition)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetPersistentVolumeClaimRetentionPolicy){ this.data= new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder((StatefulSetPersistentVolumeClaimRetentionPolicy)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSetList){ this.data= new DaemonSetListBuilder((DaemonSetList)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetCondition){ this.data= new StatefulSetConditionBuilder((StatefulSetCondition)data); _visitables.get("data").add(this.data);}
    if (data instanceof ReplicaSetList){ this.data= new ReplicaSetListBuilder((ReplicaSetList)data); _visitables.get("data").add(this.data);}
    if (data instanceof ObjectReference){ this.data= new ObjectReferenceBuilder((ObjectReference)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSetStatus){ this.data= new DaemonSetStatusBuilder((DaemonSetStatus)data); _visitables.get("data").add(this.data);}
    if (data instanceof RawExtension){ this.data= new RawExtensionBuilder((RawExtension)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSet){ this.data= new StatefulSetBuilder((StatefulSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetSpec){ this.data= new StatefulSetSpecBuilder((StatefulSetSpec)data); _visitables.get("data").add(this.data);}
    if (data instanceof RollingUpdateDaemonSet){ this.data= new RollingUpdateDaemonSetBuilder((RollingUpdateDaemonSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof ObjectMeta){ this.data= new ObjectMetaBuilder((ObjectMeta)data); _visitables.get("data").add(this.data);}
    if (data instanceof PersistentVolumeClaim){ this.data= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)data); _visitables.get("data").add(this.data);}
    if (data instanceof DeploymentStrategy){ this.data= new DeploymentStrategyBuilder((DeploymentStrategy)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSetSpec){ this.data= new DaemonSetSpecBuilder((DaemonSetSpec)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSetUpdateStrategy){ this.data= new StatefulSetUpdateStrategyBuilder((StatefulSetUpdateStrategy)data); _visitables.get("data").add(this.data);}
    if (data instanceof Deployment){ this.data= new DeploymentBuilder((Deployment)data); _visitables.get("data").add(this.data);}
    return (A) this;
  }
  public Boolean hasData() {
    return this.data != null;
  }
  public A withDeploymentListData(DeploymentList deploymentListData) {
    _visitables.get("data").remove(this.data);
    if (deploymentListData!=null){ this.data= new DeploymentListBuilder(deploymentListData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentListDataNested<A> withNewDeploymentListData() {
    return new ControllerRevisionFluentImpl.DeploymentListDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentListDataNested<A> withNewDeploymentListDataLike(DeploymentList item) {
    return new ControllerRevisionFluentImpl.DeploymentListDataNestedImpl(item);
  }
  public A withDaemonSetUpdateStrategyData(DaemonSetUpdateStrategy daemonSetUpdateStrategyData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetUpdateStrategyData!=null){ this.data= new DaemonSetUpdateStrategyBuilder(daemonSetUpdateStrategyData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetUpdateStrategyDataNested<A> withNewDaemonSetUpdateStrategyData() {
    return new ControllerRevisionFluentImpl.DaemonSetUpdateStrategyDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetUpdateStrategyDataNested<A> withNewDaemonSetUpdateStrategyDataLike(DaemonSetUpdateStrategy item) {
    return new ControllerRevisionFluentImpl.DaemonSetUpdateStrategyDataNestedImpl(item);
  }
  public A withReplicaSetData(ReplicaSet replicaSetData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetData!=null){ this.data= new ReplicaSetBuilder(replicaSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
    return new ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
    return new ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl(item);
  }
  public A withLabelSelectorData(LabelSelector labelSelectorData) {
    _visitables.get("data").remove(this.data);
    if (labelSelectorData!=null){ this.data= new LabelSelectorBuilder(labelSelectorData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.LabelSelectorDataNested<A> withNewLabelSelectorData() {
    return new ControllerRevisionFluentImpl.LabelSelectorDataNestedImpl();
  }
  public ControllerRevisionFluent.LabelSelectorDataNested<A> withNewLabelSelectorDataLike(LabelSelector item) {
    return new ControllerRevisionFluentImpl.LabelSelectorDataNestedImpl(item);
  }
  public A withContainerData(Container containerData) {
    _visitables.get("data").remove(this.data);
    if (containerData!=null){ this.data= new ContainerBuilder(containerData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ContainerDataNested<A> withNewContainerData() {
    return new ControllerRevisionFluentImpl.ContainerDataNestedImpl();
  }
  public ControllerRevisionFluent.ContainerDataNested<A> withNewContainerDataLike(Container item) {
    return new ControllerRevisionFluentImpl.ContainerDataNestedImpl(item);
  }
  public A withGenericKubernetesResourceData(GenericKubernetesResource genericKubernetesResourceData) {
    _visitables.get("data").remove(this.data);
    if (genericKubernetesResourceData!=null){ this.data= new GenericKubernetesResourceBuilder(genericKubernetesResourceData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.GenericKubernetesResourceDataNested<A> withNewGenericKubernetesResourceData() {
    return new ControllerRevisionFluentImpl.GenericKubernetesResourceDataNestedImpl();
  }
  public ControllerRevisionFluent.GenericKubernetesResourceDataNested<A> withNewGenericKubernetesResourceDataLike(GenericKubernetesResource item) {
    return new ControllerRevisionFluentImpl.GenericKubernetesResourceDataNestedImpl(item);
  }
  public A withStatefulSetStatusData(StatefulSetStatus statefulSetStatusData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetStatusData!=null){ this.data= new StatefulSetStatusBuilder(statefulSetStatusData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetStatusDataNested<A> withNewStatefulSetStatusData() {
    return new ControllerRevisionFluentImpl.StatefulSetStatusDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetStatusDataNested<A> withNewStatefulSetStatusDataLike(StatefulSetStatus item) {
    return new ControllerRevisionFluentImpl.StatefulSetStatusDataNestedImpl(item);
  }
  public A withStatefulSetOrdinalsData(StatefulSetOrdinals statefulSetOrdinalsData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetOrdinalsData!=null){ this.data= new StatefulSetOrdinalsBuilder(statefulSetOrdinalsData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetOrdinalsDataNested<A> withNewStatefulSetOrdinalsData() {
    return new ControllerRevisionFluentImpl.StatefulSetOrdinalsDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetOrdinalsDataNested<A> withNewStatefulSetOrdinalsDataLike(StatefulSetOrdinals item) {
    return new ControllerRevisionFluentImpl.StatefulSetOrdinalsDataNestedImpl(item);
  }
  public A withNewStatefulSetOrdinalsData(Integer start) {
    return (A)withStatefulSetOrdinalsData(new StatefulSetOrdinals(start));
  }
  public A withRollingUpdateStatefulSetStrategyData(RollingUpdateStatefulSetStrategy rollingUpdateStatefulSetStrategyData) {
    _visitables.get("data").remove(this.data);
    if (rollingUpdateStatefulSetStrategyData!=null){ this.data= new RollingUpdateStatefulSetStrategyBuilder(rollingUpdateStatefulSetStrategyData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.RollingUpdateStatefulSetStrategyDataNested<A> withNewRollingUpdateStatefulSetStrategyData() {
    return new ControllerRevisionFluentImpl.RollingUpdateStatefulSetStrategyDataNestedImpl();
  }
  public ControllerRevisionFluent.RollingUpdateStatefulSetStrategyDataNested<A> withNewRollingUpdateStatefulSetStrategyDataLike(RollingUpdateStatefulSetStrategy item) {
    return new ControllerRevisionFluentImpl.RollingUpdateStatefulSetStrategyDataNestedImpl(item);
  }
  public A withReplicaSetConditionData(ReplicaSetCondition replicaSetConditionData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetConditionData!=null){ this.data= new ReplicaSetConditionBuilder(replicaSetConditionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetConditionDataNested<A> withNewReplicaSetConditionData() {
    return new ControllerRevisionFluentImpl.ReplicaSetConditionDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetConditionDataNested<A> withNewReplicaSetConditionDataLike(ReplicaSetCondition item) {
    return new ControllerRevisionFluentImpl.ReplicaSetConditionDataNestedImpl(item);
  }
  public A withNewReplicaSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withReplicaSetConditionData(new ReplicaSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withPodTemplateSpecData(PodTemplateSpec podTemplateSpecData) {
    _visitables.get("data").remove(this.data);
    if (podTemplateSpecData!=null){ this.data= new PodTemplateSpecBuilder(podTemplateSpecData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.PodTemplateSpecDataNested<A> withNewPodTemplateSpecData() {
    return new ControllerRevisionFluentImpl.PodTemplateSpecDataNestedImpl();
  }
  public ControllerRevisionFluent.PodTemplateSpecDataNested<A> withNewPodTemplateSpecDataLike(PodTemplateSpec item) {
    return new ControllerRevisionFluentImpl.PodTemplateSpecDataNestedImpl(item);
  }
  public A withLocalObjectReferenceData(LocalObjectReference localObjectReferenceData) {
    _visitables.get("data").remove(this.data);
    if (localObjectReferenceData!=null){ this.data= new LocalObjectReferenceBuilder(localObjectReferenceData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.LocalObjectReferenceDataNested<A> withNewLocalObjectReferenceData() {
    return new ControllerRevisionFluentImpl.LocalObjectReferenceDataNestedImpl();
  }
  public ControllerRevisionFluent.LocalObjectReferenceDataNested<A> withNewLocalObjectReferenceDataLike(LocalObjectReference item) {
    return new ControllerRevisionFluentImpl.LocalObjectReferenceDataNestedImpl(item);
  }
  public A withNewLocalObjectReferenceData(String name) {
    return (A)withLocalObjectReferenceData(new LocalObjectReference(name));
  }
  public A withReplicaSetSpecData(ReplicaSetSpec replicaSetSpecData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetSpecData!=null){ this.data= new ReplicaSetSpecBuilder(replicaSetSpecData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetSpecDataNested<A> withNewReplicaSetSpecData() {
    return new ControllerRevisionFluentImpl.ReplicaSetSpecDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetSpecDataNested<A> withNewReplicaSetSpecDataLike(ReplicaSetSpec item) {
    return new ControllerRevisionFluentImpl.ReplicaSetSpecDataNestedImpl(item);
  }
  public A withResourceRequirementsData(ResourceRequirements resourceRequirementsData) {
    _visitables.get("data").remove(this.data);
    if (resourceRequirementsData!=null){ this.data= new ResourceRequirementsBuilder(resourceRequirementsData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ResourceRequirementsDataNested<A> withNewResourceRequirementsData() {
    return new ControllerRevisionFluentImpl.ResourceRequirementsDataNestedImpl();
  }
  public ControllerRevisionFluent.ResourceRequirementsDataNested<A> withNewResourceRequirementsDataLike(ResourceRequirements item) {
    return new ControllerRevisionFluentImpl.ResourceRequirementsDataNestedImpl(item);
  }
  public A withRollingUpdateDeploymentData(RollingUpdateDeployment rollingUpdateDeploymentData) {
    _visitables.get("data").remove(this.data);
    if (rollingUpdateDeploymentData!=null){ this.data= new RollingUpdateDeploymentBuilder(rollingUpdateDeploymentData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.RollingUpdateDeploymentDataNested<A> withNewRollingUpdateDeploymentData() {
    return new ControllerRevisionFluentImpl.RollingUpdateDeploymentDataNestedImpl();
  }
  public ControllerRevisionFluent.RollingUpdateDeploymentDataNested<A> withNewRollingUpdateDeploymentDataLike(RollingUpdateDeployment item) {
    return new ControllerRevisionFluentImpl.RollingUpdateDeploymentDataNestedImpl(item);
  }
  public A withControllerRevisionListData(ControllerRevisionList controllerRevisionListData) {
    _visitables.get("data").remove(this.data);
    if (controllerRevisionListData!=null){ this.data= new ControllerRevisionListBuilder(controllerRevisionListData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ControllerRevisionListDataNested<A> withNewControllerRevisionListData() {
    return new ControllerRevisionFluentImpl.ControllerRevisionListDataNestedImpl();
  }
  public ControllerRevisionFluent.ControllerRevisionListDataNested<A> withNewControllerRevisionListDataLike(ControllerRevisionList item) {
    return new ControllerRevisionFluentImpl.ControllerRevisionListDataNestedImpl(item);
  }
  public A withStatefulSetListData(StatefulSetList statefulSetListData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetListData!=null){ this.data= new StatefulSetListBuilder(statefulSetListData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetListDataNested<A> withNewStatefulSetListData() {
    return new ControllerRevisionFluentImpl.StatefulSetListDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetListDataNested<A> withNewStatefulSetListDataLike(StatefulSetList item) {
    return new ControllerRevisionFluentImpl.StatefulSetListDataNestedImpl(item);
  }
  public A withDaemonSetData(DaemonSet daemonSetData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetData!=null){ this.data= new DaemonSetBuilder(daemonSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
    return new ControllerRevisionFluentImpl.DaemonSetDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
    return new ControllerRevisionFluentImpl.DaemonSetDataNestedImpl(item);
  }
  public A withDeploymentSpecData(DeploymentSpec deploymentSpecData) {
    _visitables.get("data").remove(this.data);
    if (deploymentSpecData!=null){ this.data= new DeploymentSpecBuilder(deploymentSpecData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentSpecDataNested<A> withNewDeploymentSpecData() {
    return new ControllerRevisionFluentImpl.DeploymentSpecDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentSpecDataNested<A> withNewDeploymentSpecDataLike(DeploymentSpec item) {
    return new ControllerRevisionFluentImpl.DeploymentSpecDataNestedImpl(item);
  }
  public A withDeploymentStatusData(DeploymentStatus deploymentStatusData) {
    _visitables.get("data").remove(this.data);
    if (deploymentStatusData!=null){ this.data= new DeploymentStatusBuilder(deploymentStatusData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentStatusDataNested<A> withNewDeploymentStatusData() {
    return new ControllerRevisionFluentImpl.DeploymentStatusDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentStatusDataNested<A> withNewDeploymentStatusDataLike(DeploymentStatus item) {
    return new ControllerRevisionFluentImpl.DeploymentStatusDataNestedImpl(item);
  }
  public A withReplicaSetStatusData(ReplicaSetStatus replicaSetStatusData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetStatusData!=null){ this.data= new ReplicaSetStatusBuilder(replicaSetStatusData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetStatusDataNested<A> withNewReplicaSetStatusData() {
    return new ControllerRevisionFluentImpl.ReplicaSetStatusDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetStatusDataNested<A> withNewReplicaSetStatusDataLike(ReplicaSetStatus item) {
    return new ControllerRevisionFluentImpl.ReplicaSetStatusDataNestedImpl(item);
  }
  public A withControllerRevisionData(ControllerRevision controllerRevisionData) {
    _visitables.get("data").remove(this.data);
    if (controllerRevisionData!=null){ this.data= new ControllerRevisionBuilder(controllerRevisionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
    return new ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl();
  }
  public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
    return new ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl(item);
  }
  public A withDeploymentConditionData(DeploymentCondition deploymentConditionData) {
    _visitables.get("data").remove(this.data);
    if (deploymentConditionData!=null){ this.data= new DeploymentConditionBuilder(deploymentConditionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentConditionDataNested<A> withNewDeploymentConditionData() {
    return new ControllerRevisionFluentImpl.DeploymentConditionDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentConditionDataNested<A> withNewDeploymentConditionDataLike(DeploymentCondition item) {
    return new ControllerRevisionFluentImpl.DeploymentConditionDataNestedImpl(item);
  }
  public A withDaemonSetConditionData(DaemonSetCondition daemonSetConditionData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetConditionData!=null){ this.data= new DaemonSetConditionBuilder(daemonSetConditionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetConditionDataNested<A> withNewDaemonSetConditionData() {
    return new ControllerRevisionFluentImpl.DaemonSetConditionDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetConditionDataNested<A> withNewDaemonSetConditionDataLike(DaemonSetCondition item) {
    return new ControllerRevisionFluentImpl.DaemonSetConditionDataNestedImpl(item);
  }
  public A withNewDaemonSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withDaemonSetConditionData(new DaemonSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withStatefulSetPersistentVolumeClaimRetentionPolicyData(StatefulSetPersistentVolumeClaimRetentionPolicy statefulSetPersistentVolumeClaimRetentionPolicyData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetPersistentVolumeClaimRetentionPolicyData!=null){ this.data= new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(statefulSetPersistentVolumeClaimRetentionPolicyData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<A> withNewStatefulSetPersistentVolumeClaimRetentionPolicyData() {
    return new ControllerRevisionFluentImpl.StatefulSetPersistentVolumeClaimRetentionPolicyDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<A> withNewStatefulSetPersistentVolumeClaimRetentionPolicyDataLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return new ControllerRevisionFluentImpl.StatefulSetPersistentVolumeClaimRetentionPolicyDataNestedImpl(item);
  }
  public A withNewStatefulSetPersistentVolumeClaimRetentionPolicyData(String whenDeleted,String whenScaled) {
    return (A)withStatefulSetPersistentVolumeClaimRetentionPolicyData(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
  }
  public A withDaemonSetListData(DaemonSetList daemonSetListData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetListData!=null){ this.data= new DaemonSetListBuilder(daemonSetListData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetListDataNested<A> withNewDaemonSetListData() {
    return new ControllerRevisionFluentImpl.DaemonSetListDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetListDataNested<A> withNewDaemonSetListDataLike(DaemonSetList item) {
    return new ControllerRevisionFluentImpl.DaemonSetListDataNestedImpl(item);
  }
  public A withStatefulSetConditionData(StatefulSetCondition statefulSetConditionData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetConditionData!=null){ this.data= new StatefulSetConditionBuilder(statefulSetConditionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetConditionDataNested<A> withNewStatefulSetConditionData() {
    return new ControllerRevisionFluentImpl.StatefulSetConditionDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetConditionDataNested<A> withNewStatefulSetConditionDataLike(StatefulSetCondition item) {
    return new ControllerRevisionFluentImpl.StatefulSetConditionDataNestedImpl(item);
  }
  public A withNewStatefulSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withStatefulSetConditionData(new StatefulSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withReplicaSetListData(ReplicaSetList replicaSetListData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetListData!=null){ this.data= new ReplicaSetListBuilder(replicaSetListData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetListDataNested<A> withNewReplicaSetListData() {
    return new ControllerRevisionFluentImpl.ReplicaSetListDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetListDataNested<A> withNewReplicaSetListDataLike(ReplicaSetList item) {
    return new ControllerRevisionFluentImpl.ReplicaSetListDataNestedImpl(item);
  }
  public A withObjectReferenceData(ObjectReference objectReferenceData) {
    _visitables.get("data").remove(this.data);
    if (objectReferenceData!=null){ this.data= new ObjectReferenceBuilder(objectReferenceData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ObjectReferenceDataNested<A> withNewObjectReferenceData() {
    return new ControllerRevisionFluentImpl.ObjectReferenceDataNestedImpl();
  }
  public ControllerRevisionFluent.ObjectReferenceDataNested<A> withNewObjectReferenceDataLike(ObjectReference item) {
    return new ControllerRevisionFluentImpl.ObjectReferenceDataNestedImpl(item);
  }
  public A withDaemonSetStatusData(DaemonSetStatus daemonSetStatusData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetStatusData!=null){ this.data= new DaemonSetStatusBuilder(daemonSetStatusData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetStatusDataNested<A> withNewDaemonSetStatusData() {
    return new ControllerRevisionFluentImpl.DaemonSetStatusDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetStatusDataNested<A> withNewDaemonSetStatusDataLike(DaemonSetStatus item) {
    return new ControllerRevisionFluentImpl.DaemonSetStatusDataNestedImpl(item);
  }
  public A withRawExtensionData(RawExtension rawExtensionData) {
    _visitables.get("data").remove(this.data);
    if (rawExtensionData!=null){ this.data= new RawExtensionBuilder(rawExtensionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.RawExtensionDataNested<A> withNewRawExtensionData() {
    return new ControllerRevisionFluentImpl.RawExtensionDataNestedImpl();
  }
  public ControllerRevisionFluent.RawExtensionDataNested<A> withNewRawExtensionDataLike(RawExtension item) {
    return new ControllerRevisionFluentImpl.RawExtensionDataNestedImpl(item);
  }
  public A withNewRawExtensionData(Object value) {
    return (A)withRawExtensionData(new RawExtension(value));
  }
  public A withStatefulSetData(StatefulSet statefulSetData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetData!=null){ this.data= new StatefulSetBuilder(statefulSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
    return new ControllerRevisionFluentImpl.StatefulSetDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
    return new ControllerRevisionFluentImpl.StatefulSetDataNestedImpl(item);
  }
  public A withStatefulSetSpecData(StatefulSetSpec statefulSetSpecData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetSpecData!=null){ this.data= new StatefulSetSpecBuilder(statefulSetSpecData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetSpecDataNested<A> withNewStatefulSetSpecData() {
    return new ControllerRevisionFluentImpl.StatefulSetSpecDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetSpecDataNested<A> withNewStatefulSetSpecDataLike(StatefulSetSpec item) {
    return new ControllerRevisionFluentImpl.StatefulSetSpecDataNestedImpl(item);
  }
  public A withRollingUpdateDaemonSetData(RollingUpdateDaemonSet rollingUpdateDaemonSetData) {
    _visitables.get("data").remove(this.data);
    if (rollingUpdateDaemonSetData!=null){ this.data= new RollingUpdateDaemonSetBuilder(rollingUpdateDaemonSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.RollingUpdateDaemonSetDataNested<A> withNewRollingUpdateDaemonSetData() {
    return new ControllerRevisionFluentImpl.RollingUpdateDaemonSetDataNestedImpl();
  }
  public ControllerRevisionFluent.RollingUpdateDaemonSetDataNested<A> withNewRollingUpdateDaemonSetDataLike(RollingUpdateDaemonSet item) {
    return new ControllerRevisionFluentImpl.RollingUpdateDaemonSetDataNestedImpl(item);
  }
  public A withObjectMetaData(ObjectMeta objectMetaData) {
    _visitables.get("data").remove(this.data);
    if (objectMetaData!=null){ this.data= new ObjectMetaBuilder(objectMetaData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ObjectMetaDataNested<A> withNewObjectMetaData() {
    return new ControllerRevisionFluentImpl.ObjectMetaDataNestedImpl();
  }
  public ControllerRevisionFluent.ObjectMetaDataNested<A> withNewObjectMetaDataLike(ObjectMeta item) {
    return new ControllerRevisionFluentImpl.ObjectMetaDataNestedImpl(item);
  }
  public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData) {
    _visitables.get("data").remove(this.data);
    if (persistentVolumeClaimData!=null){ this.data= new PersistentVolumeClaimBuilder(persistentVolumeClaimData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
    return new ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl();
  }
  public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
    return new ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl(item);
  }
  public A withDeploymentStrategyData(DeploymentStrategy deploymentStrategyData) {
    _visitables.get("data").remove(this.data);
    if (deploymentStrategyData!=null){ this.data= new DeploymentStrategyBuilder(deploymentStrategyData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentStrategyDataNested<A> withNewDeploymentStrategyData() {
    return new ControllerRevisionFluentImpl.DeploymentStrategyDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentStrategyDataNested<A> withNewDeploymentStrategyDataLike(DeploymentStrategy item) {
    return new ControllerRevisionFluentImpl.DeploymentStrategyDataNestedImpl(item);
  }
  public A withDaemonSetSpecData(DaemonSetSpec daemonSetSpecData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetSpecData!=null){ this.data= new DaemonSetSpecBuilder(daemonSetSpecData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetSpecDataNested<A> withNewDaemonSetSpecData() {
    return new ControllerRevisionFluentImpl.DaemonSetSpecDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetSpecDataNested<A> withNewDaemonSetSpecDataLike(DaemonSetSpec item) {
    return new ControllerRevisionFluentImpl.DaemonSetSpecDataNestedImpl(item);
  }
  public A withStatefulSetUpdateStrategyData(StatefulSetUpdateStrategy statefulSetUpdateStrategyData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetUpdateStrategyData!=null){ this.data= new StatefulSetUpdateStrategyBuilder(statefulSetUpdateStrategyData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetUpdateStrategyDataNested<A> withNewStatefulSetUpdateStrategyData() {
    return new ControllerRevisionFluentImpl.StatefulSetUpdateStrategyDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetUpdateStrategyDataNested<A> withNewStatefulSetUpdateStrategyDataLike(StatefulSetUpdateStrategy item) {
    return new ControllerRevisionFluentImpl.StatefulSetUpdateStrategyDataNestedImpl(item);
  }
  public A withDeploymentData(Deployment deploymentData) {
    _visitables.get("data").remove(this.data);
    if (deploymentData!=null){ this.data= new DeploymentBuilder(deploymentData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
    return new ControllerRevisionFluentImpl.DeploymentDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
    return new ControllerRevisionFluentImpl.DeploymentDataNestedImpl(item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
    return new ControllerRevisionFluentImpl.MetadataNestedImpl();
  }
  public ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ControllerRevisionFluentImpl.MetadataNestedImpl(item);
  }
  public ControllerRevisionFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public Long getRevision() {
    return this.revision;
  }
  public A withRevision(Long revision) {
    this.revision=revision; return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (data != null ? !data.equals(that.data) :that.data != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  revision,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DeploymentListDataNestedImpl<N> extends DeploymentListFluentImpl<ControllerRevisionFluent.DeploymentListDataNested<N>> implements ControllerRevisionFluent.DeploymentListDataNested<N>,Nested<N>{
    DeploymentListDataNestedImpl(DeploymentList item) {
      this.builder = new DeploymentListBuilder(this, item);
    }
    DeploymentListDataNestedImpl() {
      this.builder = new DeploymentListBuilder(this);
    }
    DeploymentListBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentListData() {
      return and();
    }
    
  }
  class DaemonSetUpdateStrategyDataNestedImpl<N> extends DaemonSetUpdateStrategyFluentImpl<ControllerRevisionFluent.DaemonSetUpdateStrategyDataNested<N>> implements ControllerRevisionFluent.DaemonSetUpdateStrategyDataNested<N>,Nested<N>{
    DaemonSetUpdateStrategyDataNestedImpl(DaemonSetUpdateStrategy item) {
      this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
    }
    DaemonSetUpdateStrategyDataNestedImpl() {
      this.builder = new DaemonSetUpdateStrategyBuilder(this);
    }
    DaemonSetUpdateStrategyBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetUpdateStrategyData() {
      return and();
    }
    
  }
  class ReplicaSetDataNestedImpl<N> extends ReplicaSetFluentImpl<ControllerRevisionFluent.ReplicaSetDataNested<N>> implements ControllerRevisionFluent.ReplicaSetDataNested<N>,Nested<N>{
    ReplicaSetDataNestedImpl(ReplicaSet item) {
      this.builder = new ReplicaSetBuilder(this, item);
    }
    ReplicaSetDataNestedImpl() {
      this.builder = new ReplicaSetBuilder(this);
    }
    ReplicaSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetData() {
      return and();
    }
    
  }
  class LabelSelectorDataNestedImpl<N> extends LabelSelectorFluentImpl<ControllerRevisionFluent.LabelSelectorDataNested<N>> implements ControllerRevisionFluent.LabelSelectorDataNested<N>,Nested<N>{
    LabelSelectorDataNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorDataNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endLabelSelectorData() {
      return and();
    }
    
  }
  class ContainerDataNestedImpl<N> extends ContainerFluentImpl<ControllerRevisionFluent.ContainerDataNested<N>> implements ControllerRevisionFluent.ContainerDataNested<N>,Nested<N>{
    ContainerDataNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerDataNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endContainerData() {
      return and();
    }
    
  }
  class GenericKubernetesResourceDataNestedImpl<N> extends GenericKubernetesResourceFluentImpl<ControllerRevisionFluent.GenericKubernetesResourceDataNested<N>> implements ControllerRevisionFluent.GenericKubernetesResourceDataNested<N>,Nested<N>{
    GenericKubernetesResourceDataNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceDataNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endGenericKubernetesResourceData() {
      return and();
    }
    
  }
  class StatefulSetStatusDataNestedImpl<N> extends StatefulSetStatusFluentImpl<ControllerRevisionFluent.StatefulSetStatusDataNested<N>> implements ControllerRevisionFluent.StatefulSetStatusDataNested<N>,Nested<N>{
    StatefulSetStatusDataNestedImpl(StatefulSetStatus item) {
      this.builder = new StatefulSetStatusBuilder(this, item);
    }
    StatefulSetStatusDataNestedImpl() {
      this.builder = new StatefulSetStatusBuilder(this);
    }
    StatefulSetStatusBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetStatusData() {
      return and();
    }
    
  }
  class StatefulSetOrdinalsDataNestedImpl<N> extends StatefulSetOrdinalsFluentImpl<ControllerRevisionFluent.StatefulSetOrdinalsDataNested<N>> implements ControllerRevisionFluent.StatefulSetOrdinalsDataNested<N>,Nested<N>{
    StatefulSetOrdinalsDataNestedImpl(StatefulSetOrdinals item) {
      this.builder = new StatefulSetOrdinalsBuilder(this, item);
    }
    StatefulSetOrdinalsDataNestedImpl() {
      this.builder = new StatefulSetOrdinalsBuilder(this);
    }
    StatefulSetOrdinalsBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetOrdinalsData() {
      return and();
    }
    
  }
  class RollingUpdateStatefulSetStrategyDataNestedImpl<N> extends RollingUpdateStatefulSetStrategyFluentImpl<ControllerRevisionFluent.RollingUpdateStatefulSetStrategyDataNested<N>> implements ControllerRevisionFluent.RollingUpdateStatefulSetStrategyDataNested<N>,Nested<N>{
    RollingUpdateStatefulSetStrategyDataNestedImpl(RollingUpdateStatefulSetStrategy item) {
      this.builder = new RollingUpdateStatefulSetStrategyBuilder(this, item);
    }
    RollingUpdateStatefulSetStrategyDataNestedImpl() {
      this.builder = new RollingUpdateStatefulSetStrategyBuilder(this);
    }
    RollingUpdateStatefulSetStrategyBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endRollingUpdateStatefulSetStrategyData() {
      return and();
    }
    
  }
  class ReplicaSetConditionDataNestedImpl<N> extends ReplicaSetConditionFluentImpl<ControllerRevisionFluent.ReplicaSetConditionDataNested<N>> implements ControllerRevisionFluent.ReplicaSetConditionDataNested<N>,Nested<N>{
    ReplicaSetConditionDataNestedImpl(ReplicaSetCondition item) {
      this.builder = new ReplicaSetConditionBuilder(this, item);
    }
    ReplicaSetConditionDataNestedImpl() {
      this.builder = new ReplicaSetConditionBuilder(this);
    }
    ReplicaSetConditionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetConditionData() {
      return and();
    }
    
  }
  class PodTemplateSpecDataNestedImpl<N> extends PodTemplateSpecFluentImpl<ControllerRevisionFluent.PodTemplateSpecDataNested<N>> implements ControllerRevisionFluent.PodTemplateSpecDataNested<N>,Nested<N>{
    PodTemplateSpecDataNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecDataNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endPodTemplateSpecData() {
      return and();
    }
    
  }
  class LocalObjectReferenceDataNestedImpl<N> extends LocalObjectReferenceFluentImpl<ControllerRevisionFluent.LocalObjectReferenceDataNested<N>> implements ControllerRevisionFluent.LocalObjectReferenceDataNested<N>,Nested<N>{
    LocalObjectReferenceDataNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceDataNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endLocalObjectReferenceData() {
      return and();
    }
    
  }
  class ReplicaSetSpecDataNestedImpl<N> extends ReplicaSetSpecFluentImpl<ControllerRevisionFluent.ReplicaSetSpecDataNested<N>> implements ControllerRevisionFluent.ReplicaSetSpecDataNested<N>,Nested<N>{
    ReplicaSetSpecDataNestedImpl(ReplicaSetSpec item) {
      this.builder = new ReplicaSetSpecBuilder(this, item);
    }
    ReplicaSetSpecDataNestedImpl() {
      this.builder = new ReplicaSetSpecBuilder(this);
    }
    ReplicaSetSpecBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetSpecData() {
      return and();
    }
    
  }
  class ResourceRequirementsDataNestedImpl<N> extends ResourceRequirementsFluentImpl<ControllerRevisionFluent.ResourceRequirementsDataNested<N>> implements ControllerRevisionFluent.ResourceRequirementsDataNested<N>,Nested<N>{
    ResourceRequirementsDataNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsDataNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endResourceRequirementsData() {
      return and();
    }
    
  }
  class RollingUpdateDeploymentDataNestedImpl<N> extends RollingUpdateDeploymentFluentImpl<ControllerRevisionFluent.RollingUpdateDeploymentDataNested<N>> implements ControllerRevisionFluent.RollingUpdateDeploymentDataNested<N>,Nested<N>{
    RollingUpdateDeploymentDataNestedImpl(RollingUpdateDeployment item) {
      this.builder = new RollingUpdateDeploymentBuilder(this, item);
    }
    RollingUpdateDeploymentDataNestedImpl() {
      this.builder = new RollingUpdateDeploymentBuilder(this);
    }
    RollingUpdateDeploymentBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endRollingUpdateDeploymentData() {
      return and();
    }
    
  }
  class ControllerRevisionListDataNestedImpl<N> extends ControllerRevisionListFluentImpl<ControllerRevisionFluent.ControllerRevisionListDataNested<N>> implements ControllerRevisionFluent.ControllerRevisionListDataNested<N>,Nested<N>{
    ControllerRevisionListDataNestedImpl(ControllerRevisionList item) {
      this.builder = new ControllerRevisionListBuilder(this, item);
    }
    ControllerRevisionListDataNestedImpl() {
      this.builder = new ControllerRevisionListBuilder(this);
    }
    ControllerRevisionListBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endControllerRevisionListData() {
      return and();
    }
    
  }
  class StatefulSetListDataNestedImpl<N> extends StatefulSetListFluentImpl<ControllerRevisionFluent.StatefulSetListDataNested<N>> implements ControllerRevisionFluent.StatefulSetListDataNested<N>,Nested<N>{
    StatefulSetListDataNestedImpl(StatefulSetList item) {
      this.builder = new StatefulSetListBuilder(this, item);
    }
    StatefulSetListDataNestedImpl() {
      this.builder = new StatefulSetListBuilder(this);
    }
    StatefulSetListBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetListData() {
      return and();
    }
    
  }
  class DaemonSetDataNestedImpl<N> extends DaemonSetFluentImpl<ControllerRevisionFluent.DaemonSetDataNested<N>> implements ControllerRevisionFluent.DaemonSetDataNested<N>,Nested<N>{
    DaemonSetDataNestedImpl(DaemonSet item) {
      this.builder = new DaemonSetBuilder(this, item);
    }
    DaemonSetDataNestedImpl() {
      this.builder = new DaemonSetBuilder(this);
    }
    DaemonSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetData() {
      return and();
    }
    
  }
  class DeploymentSpecDataNestedImpl<N> extends DeploymentSpecFluentImpl<ControllerRevisionFluent.DeploymentSpecDataNested<N>> implements ControllerRevisionFluent.DeploymentSpecDataNested<N>,Nested<N>{
    DeploymentSpecDataNestedImpl(DeploymentSpec item) {
      this.builder = new DeploymentSpecBuilder(this, item);
    }
    DeploymentSpecDataNestedImpl() {
      this.builder = new DeploymentSpecBuilder(this);
    }
    DeploymentSpecBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentSpecData() {
      return and();
    }
    
  }
  class DeploymentStatusDataNestedImpl<N> extends DeploymentStatusFluentImpl<ControllerRevisionFluent.DeploymentStatusDataNested<N>> implements ControllerRevisionFluent.DeploymentStatusDataNested<N>,Nested<N>{
    DeploymentStatusDataNestedImpl(DeploymentStatus item) {
      this.builder = new DeploymentStatusBuilder(this, item);
    }
    DeploymentStatusDataNestedImpl() {
      this.builder = new DeploymentStatusBuilder(this);
    }
    DeploymentStatusBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentStatusData() {
      return and();
    }
    
  }
  class ReplicaSetStatusDataNestedImpl<N> extends ReplicaSetStatusFluentImpl<ControllerRevisionFluent.ReplicaSetStatusDataNested<N>> implements ControllerRevisionFluent.ReplicaSetStatusDataNested<N>,Nested<N>{
    ReplicaSetStatusDataNestedImpl(ReplicaSetStatus item) {
      this.builder = new ReplicaSetStatusBuilder(this, item);
    }
    ReplicaSetStatusDataNestedImpl() {
      this.builder = new ReplicaSetStatusBuilder(this);
    }
    ReplicaSetStatusBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetStatusData() {
      return and();
    }
    
  }
  class ControllerRevisionDataNestedImpl<N> extends ControllerRevisionFluentImpl<ControllerRevisionFluent.ControllerRevisionDataNested<N>> implements ControllerRevisionFluent.ControllerRevisionDataNested<N>,Nested<N>{
    ControllerRevisionDataNestedImpl(ControllerRevision item) {
      this.builder = new ControllerRevisionBuilder(this, item);
    }
    ControllerRevisionDataNestedImpl() {
      this.builder = new ControllerRevisionBuilder(this);
    }
    ControllerRevisionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endControllerRevisionData() {
      return and();
    }
    
  }
  class DeploymentConditionDataNestedImpl<N> extends DeploymentConditionFluentImpl<ControllerRevisionFluent.DeploymentConditionDataNested<N>> implements ControllerRevisionFluent.DeploymentConditionDataNested<N>,Nested<N>{
    DeploymentConditionDataNestedImpl(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionDataNestedImpl() {
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentConditionData() {
      return and();
    }
    
  }
  class DaemonSetConditionDataNestedImpl<N> extends DaemonSetConditionFluentImpl<ControllerRevisionFluent.DaemonSetConditionDataNested<N>> implements ControllerRevisionFluent.DaemonSetConditionDataNested<N>,Nested<N>{
    DaemonSetConditionDataNestedImpl(DaemonSetCondition item) {
      this.builder = new DaemonSetConditionBuilder(this, item);
    }
    DaemonSetConditionDataNestedImpl() {
      this.builder = new DaemonSetConditionBuilder(this);
    }
    DaemonSetConditionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetConditionData() {
      return and();
    }
    
  }
  class StatefulSetPersistentVolumeClaimRetentionPolicyDataNestedImpl<N> extends StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl<ControllerRevisionFluent.StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<N>> implements ControllerRevisionFluent.StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<N>,Nested<N>{
    StatefulSetPersistentVolumeClaimRetentionPolicyDataNestedImpl(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
    }
    StatefulSetPersistentVolumeClaimRetentionPolicyDataNestedImpl() {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this);
    }
    StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetPersistentVolumeClaimRetentionPolicyData() {
      return and();
    }
    
  }
  class DaemonSetListDataNestedImpl<N> extends DaemonSetListFluentImpl<ControllerRevisionFluent.DaemonSetListDataNested<N>> implements ControllerRevisionFluent.DaemonSetListDataNested<N>,Nested<N>{
    DaemonSetListDataNestedImpl(DaemonSetList item) {
      this.builder = new DaemonSetListBuilder(this, item);
    }
    DaemonSetListDataNestedImpl() {
      this.builder = new DaemonSetListBuilder(this);
    }
    DaemonSetListBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetListData() {
      return and();
    }
    
  }
  class StatefulSetConditionDataNestedImpl<N> extends StatefulSetConditionFluentImpl<ControllerRevisionFluent.StatefulSetConditionDataNested<N>> implements ControllerRevisionFluent.StatefulSetConditionDataNested<N>,Nested<N>{
    StatefulSetConditionDataNestedImpl(StatefulSetCondition item) {
      this.builder = new StatefulSetConditionBuilder(this, item);
    }
    StatefulSetConditionDataNestedImpl() {
      this.builder = new StatefulSetConditionBuilder(this);
    }
    StatefulSetConditionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetConditionData() {
      return and();
    }
    
  }
  class ReplicaSetListDataNestedImpl<N> extends ReplicaSetListFluentImpl<ControllerRevisionFluent.ReplicaSetListDataNested<N>> implements ControllerRevisionFluent.ReplicaSetListDataNested<N>,Nested<N>{
    ReplicaSetListDataNestedImpl(ReplicaSetList item) {
      this.builder = new ReplicaSetListBuilder(this, item);
    }
    ReplicaSetListDataNestedImpl() {
      this.builder = new ReplicaSetListBuilder(this);
    }
    ReplicaSetListBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetListData() {
      return and();
    }
    
  }
  class ObjectReferenceDataNestedImpl<N> extends ObjectReferenceFluentImpl<ControllerRevisionFluent.ObjectReferenceDataNested<N>> implements ControllerRevisionFluent.ObjectReferenceDataNested<N>,Nested<N>{
    ObjectReferenceDataNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceDataNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endObjectReferenceData() {
      return and();
    }
    
  }
  class DaemonSetStatusDataNestedImpl<N> extends DaemonSetStatusFluentImpl<ControllerRevisionFluent.DaemonSetStatusDataNested<N>> implements ControllerRevisionFluent.DaemonSetStatusDataNested<N>,Nested<N>{
    DaemonSetStatusDataNestedImpl(DaemonSetStatus item) {
      this.builder = new DaemonSetStatusBuilder(this, item);
    }
    DaemonSetStatusDataNestedImpl() {
      this.builder = new DaemonSetStatusBuilder(this);
    }
    DaemonSetStatusBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetStatusData() {
      return and();
    }
    
  }
  class RawExtensionDataNestedImpl<N> extends RawExtensionFluentImpl<ControllerRevisionFluent.RawExtensionDataNested<N>> implements ControllerRevisionFluent.RawExtensionDataNested<N>,Nested<N>{
    RawExtensionDataNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionDataNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endRawExtensionData() {
      return and();
    }
    
  }
  class StatefulSetDataNestedImpl<N> extends StatefulSetFluentImpl<ControllerRevisionFluent.StatefulSetDataNested<N>> implements ControllerRevisionFluent.StatefulSetDataNested<N>,Nested<N>{
    StatefulSetDataNestedImpl(StatefulSet item) {
      this.builder = new StatefulSetBuilder(this, item);
    }
    StatefulSetDataNestedImpl() {
      this.builder = new StatefulSetBuilder(this);
    }
    StatefulSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetData() {
      return and();
    }
    
  }
  class StatefulSetSpecDataNestedImpl<N> extends StatefulSetSpecFluentImpl<ControllerRevisionFluent.StatefulSetSpecDataNested<N>> implements ControllerRevisionFluent.StatefulSetSpecDataNested<N>,Nested<N>{
    StatefulSetSpecDataNestedImpl(StatefulSetSpec item) {
      this.builder = new StatefulSetSpecBuilder(this, item);
    }
    StatefulSetSpecDataNestedImpl() {
      this.builder = new StatefulSetSpecBuilder(this);
    }
    StatefulSetSpecBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetSpecData() {
      return and();
    }
    
  }
  class RollingUpdateDaemonSetDataNestedImpl<N> extends RollingUpdateDaemonSetFluentImpl<ControllerRevisionFluent.RollingUpdateDaemonSetDataNested<N>> implements ControllerRevisionFluent.RollingUpdateDaemonSetDataNested<N>,Nested<N>{
    RollingUpdateDaemonSetDataNestedImpl(RollingUpdateDaemonSet item) {
      this.builder = new RollingUpdateDaemonSetBuilder(this, item);
    }
    RollingUpdateDaemonSetDataNestedImpl() {
      this.builder = new RollingUpdateDaemonSetBuilder(this);
    }
    RollingUpdateDaemonSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endRollingUpdateDaemonSetData() {
      return and();
    }
    
  }
  class ObjectMetaDataNestedImpl<N> extends ObjectMetaFluentImpl<ControllerRevisionFluent.ObjectMetaDataNested<N>> implements ControllerRevisionFluent.ObjectMetaDataNested<N>,Nested<N>{
    ObjectMetaDataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaDataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endObjectMetaData() {
      return and();
    }
    
  }
  class PersistentVolumeClaimDataNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> implements ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,Nested<N>{
    PersistentVolumeClaimDataNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimDataNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endPersistentVolumeClaimData() {
      return and();
    }
    
  }
  class DeploymentStrategyDataNestedImpl<N> extends DeploymentStrategyFluentImpl<ControllerRevisionFluent.DeploymentStrategyDataNested<N>> implements ControllerRevisionFluent.DeploymentStrategyDataNested<N>,Nested<N>{
    DeploymentStrategyDataNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyDataNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentStrategyData() {
      return and();
    }
    
  }
  class DaemonSetSpecDataNestedImpl<N> extends DaemonSetSpecFluentImpl<ControllerRevisionFluent.DaemonSetSpecDataNested<N>> implements ControllerRevisionFluent.DaemonSetSpecDataNested<N>,Nested<N>{
    DaemonSetSpecDataNestedImpl(DaemonSetSpec item) {
      this.builder = new DaemonSetSpecBuilder(this, item);
    }
    DaemonSetSpecDataNestedImpl() {
      this.builder = new DaemonSetSpecBuilder(this);
    }
    DaemonSetSpecBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetSpecData() {
      return and();
    }
    
  }
  class StatefulSetUpdateStrategyDataNestedImpl<N> extends StatefulSetUpdateStrategyFluentImpl<ControllerRevisionFluent.StatefulSetUpdateStrategyDataNested<N>> implements ControllerRevisionFluent.StatefulSetUpdateStrategyDataNested<N>,Nested<N>{
    StatefulSetUpdateStrategyDataNestedImpl(StatefulSetUpdateStrategy item) {
      this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
    }
    StatefulSetUpdateStrategyDataNestedImpl() {
      this.builder = new StatefulSetUpdateStrategyBuilder(this);
    }
    StatefulSetUpdateStrategyBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetUpdateStrategyData() {
      return and();
    }
    
  }
  class DeploymentDataNestedImpl<N> extends DeploymentFluentImpl<ControllerRevisionFluent.DeploymentDataNested<N>> implements ControllerRevisionFluent.DeploymentDataNested<N>,Nested<N>{
    DeploymentDataNestedImpl(Deployment item) {
      this.builder = new DeploymentBuilder(this, item);
    }
    DeploymentDataNestedImpl() {
      this.builder = new DeploymentBuilder(this);
    }
    DeploymentBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentData() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ControllerRevisionFluent.MetadataNested<N>> implements ControllerRevisionFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}