package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetPersistentVolumeClaimRetentionPolicyBuilder extends StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl<StatefulSetPersistentVolumeClaimRetentionPolicyBuilder> implements VisitableBuilder<StatefulSetPersistentVolumeClaimRetentionPolicy,StatefulSetPersistentVolumeClaimRetentionPolicyBuilder>{
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder() {
    this(false);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(Boolean validationEnabled) {
    this(new StatefulSetPersistentVolumeClaimRetentionPolicy(), validationEnabled);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetPersistentVolumeClaimRetentionPolicy(), validationEnabled);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicyFluent<?> fluent,StatefulSetPersistentVolumeClaimRetentionPolicy instance) {
    this(fluent, instance, false);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicyFluent<?> fluent,StatefulSetPersistentVolumeClaimRetentionPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withWhenDeleted(instance.getWhenDeleted()); 
    fluent.withWhenScaled(instance.getWhenScaled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicy instance) {
    this(instance,false);
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(StatefulSetPersistentVolumeClaimRetentionPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withWhenDeleted(instance.getWhenDeleted()); 
    this.withWhenScaled(instance.getWhenScaled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StatefulSetPersistentVolumeClaimRetentionPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetPersistentVolumeClaimRetentionPolicy build() {
    StatefulSetPersistentVolumeClaimRetentionPolicy buildable = new StatefulSetPersistentVolumeClaimRetentionPolicy(fluent.getWhenDeleted(),fluent.getWhenScaled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}