package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequestConfigBuilder extends RequestConfigFluent<RequestConfigBuilder> implements VisitableBuilder<RequestConfig,RequestConfigBuilder>{
  public RequestConfigBuilder() {
    this(false);
  }
  public RequestConfigBuilder(Boolean validationEnabled) {
    this(new RequestConfig(), validationEnabled);
  }
  public RequestConfigBuilder(RequestConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RequestConfigBuilder(RequestConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequestConfig(), validationEnabled);
  }
  public RequestConfigBuilder(RequestConfigFluent<?> fluent,RequestConfig instance) {
    this(fluent, instance, false);
  }
  public RequestConfigBuilder(RequestConfigFluent<?> fluent,RequestConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RequestConfig());

    if (instance != null) {
      fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      fluent.withRequestTimeout(instance.getRequestTimeout());
      fluent.withScaleTimeout(instance.getScaleTimeout());
      fluent.withLoggingInterval(instance.getLoggingInterval());
      fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      fluent.withImpersonateUsername(instance.getImpersonateUsername());
      fluent.withImpersonateGroups(instance.getImpersonateGroups());
      fluent.withImpersonateExtras(instance.getImpersonateExtras());
      fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      fluent.withRequestTimeout(instance.getRequestTimeout());
      fluent.withScaleTimeout(instance.getScaleTimeout());
      fluent.withLoggingInterval(instance.getLoggingInterval());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RequestConfigBuilder(RequestConfig instance) {
    this(instance,false);
  }
  public RequestConfigBuilder(RequestConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RequestConfig());

    if (instance != null) {
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withImpersonateUsername(instance.getImpersonateUsername());
      this.withImpersonateGroups(instance.getImpersonateGroups());
      this.withImpersonateExtras(instance.getImpersonateExtras());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
    }
    this.validationEnabled = validationEnabled; 
  }
  RequestConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RequestConfig build() {
    RequestConfig buildable = new RequestConfig(fluent.getWatchReconnectLimit(),fluent.getWatchReconnectInterval(),fluent.getRequestTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadRequestTimeout());
    buildable.setImpersonateUsername(fluent.getImpersonateUsername());
    buildable.setImpersonateGroups(fluent.getImpersonateGroups());
    buildable.setImpersonateExtras(fluent.getImpersonateExtras());
    return buildable;
  }
  
}