package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SinkBindingSpecBuilder extends SinkBindingSpecFluentImpl<SinkBindingSpecBuilder> implements VisitableBuilder<SinkBindingSpec,SinkBindingSpecBuilder>{
  public SinkBindingSpecBuilder() {
    this(false);
  }
  public SinkBindingSpecBuilder(Boolean validationEnabled) {
    this(new SinkBindingSpec(), validationEnabled);
  }
  public SinkBindingSpecBuilder(SinkBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SinkBindingSpecBuilder(SinkBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SinkBindingSpec(), validationEnabled);
  }
  public SinkBindingSpecBuilder(SinkBindingSpecFluent<?> fluent,SinkBindingSpec instance) {
    this(fluent, instance, false);
  }
  public SinkBindingSpecBuilder(SinkBindingSpecFluent<?> fluent,SinkBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCeOverrides(instance.getCeOverrides()); 
    fluent.withSink(instance.getSink()); 
    fluent.withSubject(instance.getSubject()); 
    this.validationEnabled = validationEnabled; 
  }
  public SinkBindingSpecBuilder(SinkBindingSpec instance) {
    this(instance,false);
  }
  public SinkBindingSpecBuilder(SinkBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCeOverrides(instance.getCeOverrides()); 
    this.withSink(instance.getSink()); 
    this.withSubject(instance.getSubject()); 
    this.validationEnabled = validationEnabled; 
  }
  SinkBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SinkBindingSpec build() {
    SinkBindingSpec buildable = new SinkBindingSpec(fluent.getCeOverrides(),fluent.getSink(),fluent.getSubject());
    return buildable;
  }
  
}