package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApiServerSourceBuilder extends ApiServerSourceFluentImpl<ApiServerSourceBuilder> implements VisitableBuilder<ApiServerSource,ApiServerSourceBuilder>{
  public ApiServerSourceBuilder() {
    this(false);
  }
  public ApiServerSourceBuilder(Boolean validationEnabled) {
    this(new ApiServerSource(), validationEnabled);
  }
  public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApiServerSource(), validationEnabled);
  }
  public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,ApiServerSource instance) {
    this(fluent, instance, false);
  }
  public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,ApiServerSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ApiServerSourceBuilder(ApiServerSource instance) {
    this(instance,false);
  }
  public ApiServerSourceBuilder(ApiServerSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ApiServerSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ApiServerSource build() {
    ApiServerSource buildable = new ApiServerSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}