package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RevisionStatusFluentImpl<A extends RevisionStatusFluent<A>> extends BaseFluent<A> implements RevisionStatusFluent<A>{
  public RevisionStatusFluentImpl() {
  }
  public RevisionStatusFluentImpl(RevisionStatus instance) {
    this.withActualReplicas(instance.getActualReplicas()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withContainerStatuses(instance.getContainerStatuses()); 
    this.withDesiredReplicas(instance.getDesiredReplicas()); 
    this.withInitContainerStatuses(instance.getInitContainerStatuses()); 
    this.withLogUrl(instance.getLogUrl()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
  }
  private Integer actualReplicas;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
  private Integer desiredReplicas;
  private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
  private String logUrl;
  private Long observedGeneration;
  public Integer getActualReplicas() {
    return this.actualReplicas;
  }
  public A withActualReplicas(Integer actualReplicas) {
    this.actualReplicas=actualReplicas; return (A) this;
  }
  public Boolean hasActualReplicas() {
    return this.actualReplicas != null;
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl();
  }
  public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public RevisionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
  }
  public A setToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
    if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A removeFromContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (containerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = containerStatuses.iterator();
    final List visitables = _visitables.get("containerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public List<ContainerStatus> buildContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public ContainerStatus buildContainerStatus(Integer index) {
    return this.containerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstContainerStatus() {
    return this.containerStatuses.get(0).build();
  }
  public ContainerStatus buildLastContainerStatus() {
    return this.containerStatuses.get(containerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
    if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
    if (containerStatuses != null) {this.containerStatuses = new ArrayList(); for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
  }
  public A withContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... containerStatuses) {
    if (this.containerStatuses != null) {this.containerStatuses.clear();}
    if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasContainerStatuses() {
    return containerStatuses != null && !containerStatuses.isEmpty();
  }
  public A addNewContainerStatus(String imageDigest,String name) {
    return (A)addToContainerStatuses(new ContainerStatus(imageDigest, name));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl();
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl(-1, item);
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index,ContainerStatus item) {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl(index, item);
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index) {
    if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
    if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
    return setNewContainerStatusLike(0, buildContainerStatus(0));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
    int index = containerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerStatuses.size();i++) { 
    if (predicate.test(containerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public Integer getDesiredReplicas() {
    return this.desiredReplicas;
  }
  public A withDesiredReplicas(Integer desiredReplicas) {
    this.desiredReplicas=desiredReplicas; return (A) this;
  }
  public Boolean hasDesiredReplicas() {
    return this.desiredReplicas != null;
  }
  public A addToInitContainerStatuses(Integer index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(index >= 0 ? index : _visitables.get("initContainerStatuses").size(), builder);this.initContainerStatuses.add(index >= 0 ? index : initContainerStatuses.size(), builder); return (A)this;
  }
  public A setToInitContainerStatuses(Integer index,ContainerStatus item) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainerStatuses").size()) { _visitables.get("initContainerStatuses").add(builder); } else { _visitables.get("initContainerStatuses").set(index, builder);}
    if (index < 0 || index >= initContainerStatuses.size()) { initContainerStatuses.add(builder); } else { initContainerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
    if (this.initContainerStatuses == null) {this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").add(builder);this.initContainerStatuses.add(builder);} return (A)this;
  }
  public A removeFromInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("initContainerStatuses").remove(builder);if (this.initContainerStatuses != null) {this.initContainerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (initContainerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = initContainerStatuses.iterator();
    final List visitables = _visitables.get("initContainerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getInitContainerStatuses() {
    return initContainerStatuses != null ? build(initContainerStatuses) : null;
  }
  public List<ContainerStatus> buildInitContainerStatuses() {
    return initContainerStatuses != null ? build(initContainerStatuses) : null;
  }
  public ContainerStatus buildInitContainerStatus(Integer index) {
    return this.initContainerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstInitContainerStatus() {
    return this.initContainerStatuses.get(0).build();
  }
  public ContainerStatus buildLastInitContainerStatus() {
    return this.initContainerStatuses.get(initContainerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: initContainerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
    if (this.initContainerStatuses != null) { _visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);}
    if (initContainerStatuses != null) {this.initContainerStatuses = new ArrayList(); for (ContainerStatus item : initContainerStatuses){this.addToInitContainerStatuses(item);}} else { this.initContainerStatuses = null;} return (A) this;
  }
  public A withInitContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... initContainerStatuses) {
    if (this.initContainerStatuses != null) {this.initContainerStatuses.clear();}
    if (initContainerStatuses != null) {for (ContainerStatus item :initContainerStatuses){ this.addToInitContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasInitContainerStatuses() {
    return initContainerStatuses != null && !initContainerStatuses.isEmpty();
  }
  public A addNewInitContainerStatus(String imageDigest,String name) {
    return (A)addToInitContainerStatuses(new ContainerStatus(imageDigest, name));
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
    return new RevisionStatusFluentImpl.InitContainerStatusesNestedImpl();
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
    return new RevisionStatusFluentImpl.InitContainerStatusesNestedImpl(-1, item);
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(Integer index,ContainerStatus item) {
    return new RevisionStatusFluentImpl.InitContainerStatusesNestedImpl(index, item);
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(Integer index) {
    if (initContainerStatuses.size() <= index) throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
    if (initContainerStatuses.size() == 0) throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(0, buildInitContainerStatus(0));
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
    int index = initContainerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public RevisionStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainerStatuses.size();i++) { 
    if (predicate.test(initContainerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
    return setNewInitContainerStatusLike(index, buildInitContainerStatus(index));
  }
  public String getLogUrl() {
    return this.logUrl;
  }
  public A withLogUrl(String logUrl) {
    this.logUrl=logUrl; return (A) this;
  }
  public Boolean hasLogUrl() {
    return this.logUrl != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevisionStatusFluentImpl that = (RevisionStatusFluentImpl) o;
    if (actualReplicas != null ? !actualReplicas.equals(that.actualReplicas) :that.actualReplicas != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
    if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
    if (initContainerStatuses != null ? !initContainerStatuses.equals(that.initContainerStatuses) :that.initContainerStatuses != null) return false;
    if (logUrl != null ? !logUrl.equals(that.logUrl) :that.logUrl != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(actualReplicas,  annotations,  conditions,  containerStatuses,  desiredReplicas,  initContainerStatuses,  logUrl,  observedGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actualReplicas != null) { sb.append("actualReplicas:"); sb.append(actualReplicas + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (containerStatuses != null && !containerStatuses.isEmpty()) { sb.append("containerStatuses:"); sb.append(containerStatuses + ","); }
    if (desiredReplicas != null) { sb.append("desiredReplicas:"); sb.append(desiredReplicas + ","); }
    if (initContainerStatuses != null && !initContainerStatuses.isEmpty()) { sb.append("initContainerStatuses:"); sb.append(initContainerStatuses + ","); }
    if (logUrl != null) { sb.append("logUrl:"); sb.append(logUrl + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>> implements RevisionStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<RevisionStatusFluent.ContainerStatusesNested<N>> implements RevisionStatusFluent.ContainerStatusesNested<N>,Nested<N>{
    ContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  class InitContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<RevisionStatusFluent.InitContainerStatusesNested<N>> implements RevisionStatusFluent.InitContainerStatusesNested<N>,Nested<N>{
    InitContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    InitContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionStatusFluentImpl.this.setToInitContainerStatuses(index,builder.build());
    }
    public N endInitContainerStatus() {
      return and();
    }
    
  }
  
}