package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceStatusBuilder extends SequenceStatusFluentImpl<SequenceStatusBuilder> implements VisitableBuilder<SequenceStatus,SequenceStatusBuilder>{
  public SequenceStatusBuilder() {
    this(false);
  }
  public SequenceStatusBuilder(Boolean validationEnabled) {
    this(new SequenceStatus(), validationEnabled);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceStatus(), validationEnabled);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance) {
    this(fluent, instance, false);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withChannelStatuses(instance.getChannelStatuses()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
    this.validationEnabled = validationEnabled; 
  }
  public SequenceStatusBuilder(SequenceStatus instance) {
    this(instance,false);
  }
  public SequenceStatusBuilder(SequenceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withChannelStatuses(instance.getChannelStatuses()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
    this.validationEnabled = validationEnabled; 
  }
  SequenceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceStatus build() {
    SequenceStatus buildable = new SequenceStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getChannelStatuses(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSubscriptionStatuses());
    return buildable;
  }
  
}